+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-29T18:14:00-06:00"
lastmod = "2017-06-30T23:02:00-06:00"
preamble = "British soprano [Alice Privett](/scene/people/alice-privett/) stands out onstage; though her career is still young, she has under her belt roles like Giulietta (*I Capuleti e i Montecchi*), Ginevra (*Ariodante*), Mimì (*La bohème*), and the title role in *L'incoronazione di Poppea*. This summer, she takes on Sandrina in the Ryedale Festival's July production of [*La finta giardiniera*](http://www.ryedalefestival.com/index.php/2017-list/4-ryedale-festival-opera-the-garden-of-disguises).\n\nShe spoke with us about Mozart's early opera about social class and power, and what she has discovered about her professional life full of \"emotional highs and lows\"."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498782143331/2017-06-29---Alice-Privett.jpg.jpg"
publishDate = "2017-06-30T23:02:00-06:00"
related_articles = ["articles/spotlight-on-emily-edmonds.md","articles/spotlight-on-jennifer-davis.md","articles/spotlight-on-stephanie-tritchew.md","articles/talking-with-singers-clare-tunney.md"]
related_people = ["scene/people/alice-privett.md"]
short_description = "&quot;Mozart chose a libretto in which the principal female character has to forgive some heinous misdoings of her male counterpart. However, Like Rosina, she does get to exact her own revenge on him throughout the opera before finally capitulating. The main message seems to me to be that forgiveness is an integral part of loving somebody.&quot;"
slug = "spotlight-on-alice-privett"
title = "Spotlight on: Alice Privett"
+++

## Why do you sing professionally?

I grew up in a musical household and was surrounded by opera from an early age, so that certainly had a huge influence on me! I honestly have never felt that I wanted to do anything other than sing. Someone I once worked with said that it is our job on stage to hold up a mirror for the audience: they are given the opportunity to see their experiences reflected back at them, and ideally they are thus drawn into a state of empathy. This idea of communication, and of evoking a heightened state of empathy or compassion, is really important to me. (There's probably also an element of adrenaline junkie somewhere packed into the mix.)

## What do you know about the singing career that you wish you knew 10 years ago? 

There's nothing that I wish I had known, exactly - but I do feel that the most difficult aspect of the industry to adapt to has been the emotional highs and lows that we experience, and the reality of how they have an impact on daily life. We have to learn how to cope with rejection, competition, feelings of inadequacy... these are things that aren't taught in music college, and perhaps can't be taught at all, but rather have to be experienced.

## What do you think Mozart's *La finta giardiniera* says about romance, status/class, and forgiveness ?

I've found it really interesting to see how Mozart's presents class and status in *Finta* as compared to some of his more mature works. There are a lot of similarities. Both class and status are poked fun at: everyone, rich or poor, seem to be as hapless as each other. As in *The Marriage of Figaro*, the aristocracy are mostly portrayed as fundamentally impotent - none more so than the upper class heroine who dresses as a 'peasant' in order to escape her problems, and finds herself in other kinds of trouble. 

There are other parallels with *Figaro* - Mozart chose a libretto in which the principal female character has to forgive some heinous misdoings of her male counterpart. However, Like Rosina, she does get to exact her own revenge on him throughout the opera before finally capitulating. The main message seems to me to be that forgiveness is an integral part of loving somebody. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498782174110/2017-06-29---Alice-Privett-Sandrina-Nina-Brazier-Director.jpg.jpg)
<figcaption>Alice Privett (left) as Sandrina and director Nina Brazier, in rehearsal for *La finta giardiniera*.</figcaption>
</figure>

## What do you think are the unique challenges and advantages to singing an opera with a translated libretto?

The challenges almost always lie in aligning the newly translated text with the musical line. We have to work very hard to make sure that we're not automatically adopting the Mozart's musical phrasing at the expense of the nuance and meaning of the English words, which may need to be stressed in different places in order for the audience to hear and understand them. We also have to work to ensure that the translation suits the production's historical setting, as audiences are quick to notice any outdated text in their native tongue if the show has been updated. 

One of the clear advantages of using a translated text is that the audience has a more immediate connection with what the characters are saying, and their focus isn't drawn by them having to look at surtitles. It does mean we have to work hard at being particularly clear with our text - there is nowhere to hide! 

## Mozart wrote *La finta giardiniera* when he was 18 years old; what were you doing at 18?

Nothing so auspicious! I went off to university to study English. I lasted one term and five days, and then left: something in me recognised that I was there, in a particularly intense environment, because I thought I ought to be there, rather than because I really wanted to be. Later in the year I applied to music college. 

>La finta giardiniera plays in Ryedale, North Yorkshire, July 15 and 17, before heading on tour in Scotland starting in September. To purchase tickets for the July performances, email the [Ryedale Festival's box office](box.office@ryedalefestival.com); for more details, [click here.](http://www.ryedalefestival.com/index.php/2017-list/4-ryedale-festival-opera-the-garden-of-disguises)
