+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-29T08:17:00-06:00"
lastmod = "2017-06-13T09:16:00-06:00"
preamble = "After singing Mercédès in *Carmen* and the title role in *Dido and Aeneas* at the [Deutsche Oper](/scene/companies/deutsche-oper-berlin/), American mezzo-soprano [Abigail Levis](/scene/people/abigail-levis/) returns to Berlin this summer for *Don Carlos* (Thibault). This fall, she heads to her home country to sing in Opera Philadelphia's double-bill, [*War Stories*](https://www.operaphila.org/whats-on/on-stage-2017-2018/war-stories/).\n\nUnique and refreshing, Levis talks about life after training, creating for herself room to grow as an artist, and focusing on the things a singer **can** control."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496067019447/2017-05-29---LEVIS-PHOTO.jpg.jpg"
publishDate = "2017-06-11T22:56:00-06:00"
related_articles = ["articles/spotlight-on-emma-char.md","articles/spotlight-on-cairan-ryan.md","articles/spotlight-on-sarah-vautour.md","articles/spotlight-on-jennifer-taverner.md"]
related_companies = ["scene/companies/deutsche-oper-berlin.md","scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/abigail-levis.md"]
short_description = "&quot;Once you are out of school, and as you move through your training programs, you find that there is no definite way to be an artist and there is no right way to be an opera singer. It&#039;s about making choices and standing by them. It&#039;s about trying new things and finding what works for you in this moment and what does not.&quot;"
slug = "spotlight-on-abigail-levis"
title = "Spotlight on: Abigail Levis"
+++

## Why do you sing, and why are you doing it professionally?

I sing because it is the language in which I best communicate with others and with myself. It allows me to best explore the world around me as well as my personal faith. 

I do it professionally because I feel that what I have to say is worth listening to. I feel I can use this language to speak to others and help them explore and communicate as well. Opera was the natural fit for my voice, but I have also found it to be one of the more powerful artistic mediums. It has everything. Theater, music, literature and poetry, language, history, beauty, all the complexity and depth of humanity - you can find it all during a night at the opera. 
        
## What does "good singing" mean to you? What does it feel like when you achieve it?

Technique-wise, I agree with the advice that after singing any role you should feel like you could sing it again (I mean...don't...rest is important, but you shouldn't feel trashed). 

I also listen to myself a lot. I record most of coachings, lessons, and rehearsals (and practice sessions) and listen to them while I drive or walk around. For me this is really important, because it reminds me that my default is a lot higher than I think it is. Just because that one phrase felt a little wild for me and sounded like a primordial scream in my head, does not mean it *actually* sounded that way to the listener. And it certainly doesn't mean the rest of the performance was null and void. When I have that reassurance, I can relax, remove the tension from my body (which was likely the culprit in the first place) and sing like a normal person.

However, when I'm singing well, I don't notice much. If I've prepared my technique well, I can sink into the character and the text and disappear completely. For me it feels like blacking out - my vision gets a little blurry and tunneled at first and just after, but I will remember nothing about the performance itself. This happens rarely, but when it does it's thrilling and the feedback is always incredible.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496067778964/2017-05-29---Levis---Messiah-TSO.jpg.jpg)
<figcaption>Abigail Levis singing Handel's *Messiah* with the Toronto Symphony Orchestra, 2016.</figcaption>
</figure>

## What do young singers need to do more of? What should they do less of?

Young singers need to spend more time allowing themselves to become artists. In school we learn how to sing and how to win auditions, but when it comes to owning who you are as an artist, many young singers today are on their own. I personally had a hard time even using the word "artist" to describe myself. 

For me, it has meant caring less about what other people think and trusting my own instincts. 

Once you are out of school, and as you move through your training programs, you find that there is no definite way to be an artist and there is no right way to be an opera singer. It's about making choices and standing by them. It's about trying new things and finding what works for you in this moment and what does not. No matter what you do, people will instruct and advise you to do it differently. All of the instruction is worthy of attention and consideration (listen to the people you sing for! that includes audience members who "know nothing"), but very little of it requires action. 

I spent a good portion of my twenties trying to impress the right people and do my work strategically. I found that not only was it extremely boring and unfulfilling for me as an artist, but it wasn't doing me much good. I would go into competitions and auditions and play by the strategy taught in many workshops, grad programs, and YAPs - sing the shortest but flashiest aria that somehow shows everything about you and what you can do (not what you want to do, what you *can* do), don't be too weird but make sure they remember you (but like...not for the wrong reasons...whatever that means), don't offer Baroque because then you'll be pegged as "Baroque only", don't offer something TOO modern because then you'll get pegged as "the new music girl". Don't wear a print. Don't wear flats, but don't wear shoes that are too high. Don't move too much. Always make pretty noises - only pretty noises - but, y'now...stand out. 

I did all of that. The feedback was always the same "pretty girl, pretty voice...meh". I felt unfulfilled and like a fraud. It wasn't me. 

And I hated that dress.

At some point I started repeating a line from Rick Nelson's song "Garden Party" over and over to myself: "You can't please everyone, so you've got to please yourself."

So I started doing what made me happy. I sang arias that no one else was singing and opened with Monteverdi. I danced. I straight toned (gasp!). I wrote my own oranaments. And little by little I noticed that my greatest successes would come when I was completely and genuinely myself. I wouldn't necessarily win the whole competition, but one or two of the judges would take me aside and tell me how I was the real standout. Someone would offer me a job or an audition or ask to stay in touch so that they could help me network. One judge at a major competition told me "I thought you were insane to even offer that aria, let alone open with it. But then you started singing and I remembered how GOOD this music is! Thank you for that."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496067742500/2017-05-29---Levis---Flora.jpg.jpg)
<figcaption>Abigail Levis as Flora in *La traviata*, Deutsche Oper Berlin, 2016.</figcaption>
</figure>

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

I am lucky that I have actually already sung a lot of roles that I found thrilling -  Monteverdi's Ottavia (*L'incoronazione di Poppea*), Purcell's Dido (*Dido and Aeneas*), Despina and Dorabella (*Così fan tutte*), Britten's Nancy (*Albert Herring*), Handel's Sesto (*Giulio Cesare*), The Fox in *The Cunning Little Vixen*, the alto solo in *St. John's Passion* - all of which I'd like to revisit again. I am even luckier that this season brings me two bucket list roles in Bernstein's *Trouble in Tahiti* (I'll sing the role of Dinah with Opera Parallele in San Francisco) and Prince Orlofsky in *Die Fledermaus* (with my home company of Utah Opera).

There are many other roles that I would love to sink my teeth into: The alto solo in *St. Matthew's Passion*, Charpentier's Medée, Lully's Armide, both Sesto and Annio in *La Clemenza di Tito*, Cenerentola and Cendrillon, both Nero and Poppea in *L'Incoronazione di Poppea*, Mozart's Idamante (*Idomeneo*), and every Handel role I can get my hands on - Irene, Ariodante, Xerxes, and Ruggiero.

## What have you learned about your career as a singer, solely through professional experience?

The performers who have always influenced me the most are the ones who make strong choices and commit themselves entirely to character and text. This has not changed for me, but what I am noticing about many of these people is that there seems to be a correlation between their ability to abandon themselves entirely onstage and a healthy personal life. Having a life outside of the practice room is just as, if not more important than doing your warm-ups everyday. 

Enjoying hobbies, exploring the world, meeting new people, falling in love, exploring your spiritual self - honestly, just experiencing life - is how we grow as artists. It's the people who have experienced life that actually have something to say about it.

>If you know an artist worthy of a little Spotlight, let us know! Get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)
