+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-11T21:08:00+01:00"
lastmod = "2016-10-13T11:44:00+01:00"
preamble = "Unison Media's exciting series, [*The Crypt Sessions*](http://deathofclassical.com/), begins its new season with a totally eerie combination of music and venue. On October 26 and 28, in Harlem's The Church of the Intercession, Unison Media collaborates with [On Site Opera](http://osopera.org/) to present the semi-staged premiere of [Gregg Kallor](/scene/people/gregg-kallor/)'s dramatic cantata, [*The Tell-Tale Heart*](http://deathofclassical.com/gregg-kallor/), based on the poem by Edgar Allan Poe. Kallor himself will be at the piano, with cellist [Joshua Roman](http://www.joshuaroman.com/) and mezzo-soprano [Elizabeth Pojanowski](/scene/people/elizabeth-pojanowski/), and [Sarah Meyers](http://sarahinameyers.com/) directs. \n\nThe night begins with wine & cheese at 7pm, before settling into the spooky evening at 8pm. We spoke with Kallor about his new work, Poe's music-worthy text, and how he writes \"creepiness in music.\"\n\nGrab your [tickets here!](http://www.eventbrite.com/o/the-crypt-sessions-by-unison-media-8512851732)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476350622205/2016-10-13---Kallor-Ousley.jpg.jpg"
primary_image_credit = "Pianist and composer Gregg Kallor. Photo by Andrew Ousley."
publishDate = "2016-10-13T11:31:00+01:00"
related_articles = ["articles/draculas-neighbour-nancy-allen-lundy.md","articles/6-operas-to-creep-you-out.md"]
related_companies = ["scene/companies/on-site-opera.md"]
related_people = ["scene/people/gregg-kallor.md","scene/people/elizabeth-pojanowski.md"]
short_description = "&quot;The old man&#039;s glass eye triggers her murderous rage – as she sings about the eye, she sees it and is held captive by its image – so the eye gets its own trance-like music. There&#039;s furtive, creepily joyful music while she describes her cunning murderous actions. There&#039;s a demented waltz that gets progressively weirder as the narrator&#039;s tenuous grip on sanity loosens.&quot;"
slug = "spooky-shows-the-telltale-heart"
title = "Spooky shows: The Tell-Tale Heart"
+++

## What drew you to set Poe's text to music?

Poe's worlds are dark, rich, creepy places filled with fascinating people – what could be better to set to music?! In *The Tell-Tale Heart*, Poe invites us to empathize with his murderer, who isn't exactly mentally balanced (hello, delightful criminally insane character!). The narration is a seething cauldron of rapidly changing emotional states: pride in how meticulously the atrocious crime is planned and carried out, fear, pity, frustration, anxiety, giddy excitement and demonic pleasure. Perfect for a musical ghost story.

## Why did you choose a cantata form, and piano/cello instrumentation?

I was thinking more about the vibe than about form – I want the performance of this music to feel like we're sitting around a campfire listening to a ghost story. After finding the sound-worlds of the piece, I just kept that campfire story-telling vibe in mind and it ended up being a sort of hybrid between an extended art song and a mini-opera.

I wanted to create a sense of foreboding, of the things that haunt and excite the narrator. The dark, rich timbre of the cello is perfect for that. It’s the shadowy presence in her mind, like a poltergeist hovering on the edge of her vision. The piano reflects the murderer's thoughts and emotional states, so that we experience what she experiences. Her terror and evil joy become ours. The piano/cello combination can be both light and facile, and big and rich – while being intimate enough to evoke that campfire ghost-story-telling vibe.

Of course, now I'm kind of excited to think about orchestrating the thing…

## Why do you think many composers find it difficult to write for the voice? What is unique about vocal composition?

I don't know how it is for other composers, but for me there has to be a reason that someone feels compelled to sing something – as if there were no other possible way to convey the thought than by singing it. That's my starting place for setting words to music – finding the impetus to express the idea through music.

I want my vocal music to feel and sound like heightened conversation, so I take my cues from the words and let them dictate the shape and sound of the music. I speak the text aloud. I sing it. I whisper it. I live with the words until I feel as though the thoughts are mine, born from my own experience. Then I know what the sound-world wants to be, and I set the words to music. 

Then I tweak the hell out of it…

The challenge is to find the right balance between letting the words register and deepening their emotional impact. The music needs to be effective on its own (if, say, the words are all changed to the syllable "la" or if the vocal line is played by a clarinet) – specific enough to help tell and propel the story, without distracting from the text.

In *The Tell-Tale Heart*, I want the music to let us feel as though we're in the narrator's world. Her suffering needs to be ours; her pride needs to be ours; her fear and shock and joy and anger and frustration and diminishing grip on sanity need to be ours. The music has to pull us even deeper into the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476353340758/2016-10-13---Gregg-Crypt-Announcement.jpg.jpg)
<figcaption>Photo by Andrew Ousley.</figcaption>
</figure>

## How do you write "scary" music?

There are lots of ways to conjure creepiness in music – I think the challenge is to create an arc to the storytelling that builds and heightens the suspense. It’s about the long, slow build – continually upping the ante. In *The Tell-Tale Heart*, I want to create a sense of scary within the music itself by keeping us riveted on the narrator's every utterance. 

The old man's glass eye triggers her murderous rage – as she sings about the eye, she sees it and is held captive by its image – so the eye gets its own trance-like music. There's furtive, creepily joyful music while she describes her cunning murderous actions. There's a demented waltz that gets progressively weirder as the narrator's tenuous grip on sanity loosens.

## What can people expect from this semi-staged premiere of *The Tell-Tale Heart*?

A ridiculously good time in a crypt! And, hopefully, something that they haven’t experienced before. This is about entering the world of Poe's murderer and being in her presence as the events unfold. Feeling her fear, and her excitement, and her pride and anxiety and frustration and anger. *The Tell-Tale Heart* is a familiar tale to a lot of people – we want to give it to them in new clothes.

The outside world melts away on the gorgeous grounds of the Church of the Intercession on 155th Street. Amidst beautifully carved stone arches, our guests will be plied with Halloween treats and plenty of wine. Then they'll walk through the moonlit church cemetery (!) before passing through a large wooden door, where they'll descend a grand stone staircase into the Crypt. Seating is limited to fifty people, who will be huddled in a semi-circle around the performers – like sitting around a campfire listening to a ghost story. Tough to imagine a more deliciously creepy way to premiere *The Tell-Tale Heart*!

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/BvSsoGjoJzc" frameborder="0" allowfullscreen></iframe>
</figure>

>For full details and ticket information about The Tell-Tale Heart, [click here.](http://www.eventbrite.com/o/the-crypt-sessions-by-unison-media-8512851732)
