+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-20T12:07:00-04:00"
lastmod = "2017-10-20T21:46:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508516194944/2017-10-20---Still3.jpg.jpg"
primary_image_credit = "Photo: Blake Hannahson."
publishDate = "2017-10-20T19:39:00-04:00"
related_articles = ["articles/mrozewski-delight-wonder.md","articles/dear-me-advice-to-my-freshman-self.md","articles/transfixing-soundstreams-presents-tan-duns-water-passion.md"]
related_companies = ["scene/companies/soundstreams.md"]
related_people = ["scene/people/owen-mccausland.md","scene/people/adanya-dunn.md","scene/people/keith-lam.md","scene/people/vania-chan.md"]
short_description = "With the daunting score has come an &quot;unbelievable&quot; level of focus from the performers. &quot;That&#039;s maybe even more powerful than this music, these people working either in pairs or quartets or quintets,&quot; he says of the &quot;fierce&quot; level of listening between the singers. &quot;They&#039;re totally wrapped up with this other person.&quot;"
slug = "soundstreams-musik-ende"
title = "&quot;It&#039;s his life, it&#039;s him.&quot; Soundstreams presents Musik für das Ende"
+++

10 singers are currently deep into rehearsals with stage director Chris Abraham and music director John Hess for what will be the premiere staged performance of Claude Vivier's 1971 work, *Musik für das Ende* (*Music of the End*). [Presented by Soundstreams](https://www.soundstreams.ca/performances/main-stage/musik-fur-das-ende/), **October 27 to November 4**, *Musik für das Ende* is programmed along with the last piece Vivier wrote before his premature death in 1983, *Glaubst du an die Unsterblichkeit der Seele* (*Do You Believe in the Immortality of the Soul?*)

Death and the afterlife were common ponderances of Vivier's, and *Musik für das Ende* is a piece that urges the artist to imitate a spiritual concept with the musical demands of the score. "Two threads join this body to the human spirit: a word and the rhythm assigned to it," writes Vivier in his composer's notes for the piece. "I specify these two elements because they belong not to a cosmic certitude, but to human verity. The *Music of the End* is where all is forever erased, where all becomes infinite silence."

Like with much of Vivier's work, the early steps of understanding and following the score can be alarmingly complicated. Even Hess, who is certainly no stranger to contemporary scores - "the weirder, the better, as far as I'm concerned" - found the piece a daunting project.

"I think the answer to that is 'slowly'," he says of the best way to rehearse something like *Musik für das Ende*. With patience, he and the singers arrived at an early checkpoint where they could understand Vivier's murky instructions. "Initially they're so obtuse and so confusing," says Hess of the unique notations in the score. "Sure enough, it became totally clear."

The singers are meant to assume a musical idea - a pitch, a syllable, and a "mantra," as Hess describes it - and throughout the work those elements are separated and exchanged between individual voices. "There are these compelling contradictory forces at play, and ultimately, they all end up in unison."

"It became lifting those ingredients out and working on them," he says of the rehearsal process. "Who am I colliding with, who am I together with?" The exchange of musical material feels both specific and universal; it's the crux of how *Musik für das Ende* is put together, and it's also the stuff of music in the most general sense.

Hess adds simply, "It's like how you rehearse Mozart - you repeat it until you get it right."

With the daunting score has come an "unbelievable" level of focus from the performers. "That's maybe even more powerful than this music, these people working either in pairs or quartets or quintets," he says of the "fierce" level of listening between the singers. "They're totally wrapped up with this other person."

Be it Vivier or Schubert, a heightened level of awareness between performers inevitably makes for a thrilling experience for the listeners. Yet from an artist's vantage point, the demands of a score like *Musik für das Ende* can feel like an endless list of minutia that will go largely unappreciated by an audience. Hess sums up the detail work involved in sorting out a bar of 17/16: "Does that *have* to happen?"

As it turns out, yes. "If it's only the quality of discomfort and unrest that it creates in your life, as a performer, it's worth it," he says. "Otherwise, you may as well do the whole thing in 4/4." Uncomfortable details are part of Vivier's aesthetic, even his person. "It's his life, it's him," Hess agrees. "I have a feeling that if you were hanging out with him, you would never be totally comfortable."

So, with all this hard work and discomfort, what can listeners get excited about with Soundstreams' night of Vivier? "It's completely from that world of everything's up for grabs, rules are made to be broken, burn your bras, smoke some dope, somebody tells you to do something, get up in a parade and do the exact opposite," says Hess, smiling (but not joking). "There needs to be a complete suspension of judgment in order to do that stuff," and by extension, take in a work like *Musik für das Ende*.

"There's something very powerful about these people going into this intense experience, finding a unified voice at the end."

Performances happen **October 27 to November 4** at Crow's Theatre, 345 Carlaw Avenue. Single tickets are available at 647-341-7390 or by following our box office links below; you can also see *Musik für das Ende* as part of a full or Pick 3 [subscription with Soundtreams](http://www.soundstreams.ca/20172018-season-subscriptions/).

<figure data-type="video">
<iframe src="https://player.vimeo.com/video/235015775" width="640" height="360" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
</figure>
