+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2023-05-17T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1684459336/sqBostonBaroque_Iphigenie.jpg"
primary_image_credit = "Soula Parassidis as Iphigénie and Jesse Blumberg as Oreste in Boston Baroque's production of Iphigénie en Tauride, 2023. Photo: Sam Brewer."
related_articles = ["articles/boston-baroques-louisa-muller-on-amadigi-di-gaula.md", "articles/opera-composers-we-just-dont-like-okay.md"]
related_companies = ["scene/companies/boston-baroque.md"]
related_people = [""]
short_description = " Parassidis gave what is perhaps one of the most electrifying performances I have ever seen at the opera house, and considering the amount of opera I have seen that is no small feat."
slug = "soula-parassidis-shines-in-iphigenie-en-tauride"
title = "Soula Parassidis shines in Iphigénie en Tauride"
youtube_url = ""

+++
Abrupt casting changes due to injury can always bring a strange energy to a performance: the performers usually have to adjust to whoever they're playing off, and audiences also do need to adjust expectations due to disappointment. There are a great many times where it can also get in the way of the energy of the performance. But there is that rare last-minute cast swap that ends up being for the better.

Thus, we come to [Boston Baroque](/scene/companies/boston-baroque/)'s production of Gluck's _Iphigénie en Tauride_, which had originally cast Wendy Bryn Harmer in the title role. I personally was quite looking forward to this, right up until she had to pull out of performances at the last minute due to an injury. Boston Baroque ended up hiring Soula Parassidis into the role, fresh off a different production in Athens. I do rather like Miss Harmer, so I was bracing myself for disappointment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684459335/BostonBaroque_Iphigenie_Soula_Parassidis_as_Iphig%C3%A9nie.jpg){{% /md %}}


<figcaption>Soula Parassidis as Iphigénie in Boston Baroque's production of Iphigénie en Tauride, 2023. Photo: Sam Brewer.</figcaption>
</figure>

What I got ended up blowing me away, and for all of the right reasons: Parassidis gave what is perhaps one of the most electrifying performances I have ever seen at the opera house, and considering the amount of opera I have seen that is no small feat. There was literally not a single thing wrong with her performance in any way that I could see, and that is an exceptionally rare thing to see. As an actress, she sold the role: her facial expressions engaged with where she was in the story every step of the way, there was not a single hand gesture out of place (even when trembling as they were during the fourth act), and her breaths came at just the right cadence every time. 

Vocally, however, she was a powerhouse. Her voice had a very lovely tone, but it was almost shocking to me that her voice was able to cut through the orchestra even at the half-whisper she adopted on a few notes. And man, was it an amazing half-whisper: she was always purposeful when employing this half-whisper, and this even more than the times that Gluck asks the singer to sing loudly showed the distress of Iphigénie as a character. She also engaged with the text she was singing in ways I have never heard an opera singer connect with such text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684459335/BostonBaroque_Iphigenie_Jesse_Blumberg_as_Oreste_and_William_Burden_as_Pylade.jpg){{% /md %}}

<figcaption>Jesse Blumberg as Oreste and William Burden as Pylade in Boston Baroque's production of Iphigénie en Tauride, 2023. Photo: Sam Brewer.</figcaption>
</figure>

Honestly, it was one of those performances where absolutely every note was right, from the fear she displays upon her entrance in the storm scene in the opening act, to the desperation she feels at having to sacrifice a Greek at the whims of the Scythian chief to the joy at being united with her brother Oreste. Parassidis did more than just embody Iphigénie in this performance: she made us believe in the character's internal world through sheer force of will alone.

It brings to mind something mentioned in the program about Gluck requiring extreme sensitivity and activation in performance. Something about this feels completely correct: Gluck's music in _Iphigénie en Tauride_ tends towards the simple, and while he has a very good sense of text painting and an unusually good sense of pace for pre-1800's opera there is still a lot the singer needs to fill in. Parassidis met the challenge head-on: every aspect of her performance injected life into the music, and even the less dramatically interesting moments felt like the most important thing in the world.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684459334/BostonBaroque_Iphigenie__Founding_Music_Director_Martin_Pearlman_the_Boston_Baroque_Orchestra.jpg){{% /md %}}

<figcaption>Founding Music Director Martin Pearlman & the Boston Baroque Orchestra in Boston Baroque's production of Iphigénie en Tauride, 2023. Photo: Sam Brewer.</figcaption>
</figure>

In my estimation, Parassidis gave what has to be one of my top five great opera performances that I have seen live. I do not state this lightly: this is an Iphigénie for the ages, and whenever she was off-stage I longed to see her on the stage again.

The supporting cast she worked with at least left a good impression, even if none of them could successfully match the energy Parassidis threw at the wall. David McFerrin's Thoas was perhaps a bit too paternal for what his main antagonistic character needed to bring to the table, but he still acted a part that really does not appear all that often and made it at least memorable. William Burden's Pylade left quite an impression as well: he had an absolutely beautiful lyric tenor that soared without ever seeming strained in any way. Jesse Blumberg's Oreste was also quite a good performance, and in my estimation he came the closest to matching Parassidis' energy with his own incredibly well-acted performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684459335/BostonBaroque_Iphigenie_Angela_Yam_as_Diana.jpg){{% /md %}}

<figcaption>Angela Yam as Diana in Boston Baroque's production of Iphigénie en Tauride, 2023. Photo: Sam Brewer.</figcaption>
</figure>

Where it perhaps falls apart slightly is in the chorus: the choral singing was competent enough, and the soloists that emerged from it to play the minor roles were also quite good at their jobs. I was not, however, a fan of the way the chorus stayed seated at the edges of the stage where they flanked the orchestra: there perhaps could have been ways to stage them more inventively, but parking them to the sides did take away from what they could do, especially when most of them sat to the sides after doing the bare minimum stage action. I would have liked to see a more active chorus in this opera's staging, with them perhaps breaking a chain when Iphigénie commands them to, or genuinely engaging in the grand battle that comes right before the _deus ex machina_ at the end of the work, or actually leading Pylade off the stage instead of just simply gesturing him off as what happens in the staging.

The rest of the staging, at least, was quite competently delivered. The projections on the screens around the stage were quite interesting: notable moments for this were the storm scene that opened the show, which was accompanied by lighting cues and images of a knife to illustrate Iphigénie's fears. Oreste's dream sequence with the furies in Act II was also a high point of the projection work, with silhouettes of the rest of the house of Agamemnon filling in blanks that the rest of the production could not fill. The costuming of the central characters was also quite interesting: I liked that Oreste and Iphigénie were costumed in matching clothes and a splotch of red on the hand: in a production where there was visually little else to connect the characters, the costuming here was much appreciated. There was not much else to comment on considering how simple the production was otherwise.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684459335/BostonBaroque_Iphigenie_Soula_Parassidis_as_Iphig%C3%A9nie_Angela_Yam_as_Diana_Jesse_Blumberg_as_Oreste_and_William_Burden_as_Pylad.jpg){{% /md %}}

<figcaption>Soula Parassidis as Iphigénie, Angela Yam as Diana, Jesse Blumberg as Oreste, and William Burden as Pylade in Boston Baroque's production of Iphigénie en Tauride, 2023. Photo: Sam Brewer.</figcaption>
</figure>

And how could I neglect to mention the performance of the orchestra of Boston Baroque? Their reading of Gluck's score was quite sensitive, dazzling when it needed to be but mostly hovering in the background and letting the singers do their thing. It's something I have come to expect rather consistently with period instrument performances, but with repertoire such as this they really let the strengths of Gluck's score shine. There were also almost no coordination problems to show for it, and barring a couple of places they played sensitively enough I could always hear the singers.

It was a performance full of a few little things, but Soula Parassidis was the glue that not only held it all together, but let the piece shine. This night belonged entirely to her, and the crazy thing to me is that we almost did not get this performance. I now cannot imagine what this night would have been like without Ms. Parassidis' incredible attention to detail, and since I have experienced it I cannot wait for her to return to the Boston opera scene, because I am expecting it to be full of fireworks in whatever form it takes next.
