+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-02-08T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1675825296/media/2023/02/sqCarnegie_Sun_banner_CH11305206_xy2a2e.jpg"
primary_image_credit = "Tenor Zhuohan Sun and pianist Yuriko Watanabe, SongStudio Young Artists Recital, Zankel Hall/Carnegie Hall, February 4, 2023. Photo: Jennifer Taylor."
related_articles = ["articles/the-met-s-at-home-gala.md", "articles/renee-fleming-brings-a-new-luster-to-dumbarton-oaks.md"]
related_companies = []
related_people = []
short_description = "If opera can be seen as a circle struggling to widen the circumference of its audience, concerts consisting of song alone are a much smaller and much more esoteric circle. Ms. Fleming is trying to change that and is currently devoting her life to ensuring that there will be at least one more generation of song artists. "
slug = "songstudio-leid-ing-the-way"
title = "SongStudio: Lied-ing the way"
youtube_url = ""

+++
Renée Fleming has been called "the people's diva," but her current moniker should be the "leader in lieder," or even "the high priestess of song," as a teacher to emerging singers. She has had her hand in a number of mentoring programs, including VOICES at the Kennedy Center in Washington, D.C., and VocalARTS in Aspen, Colorado.

Since 2017 she has been the guiding force behind [SongStudio](https://www.carnegiehall.org/Education/Programs/Workshops/Song-Studio), presented under the auspices of the Weill Music Institute at Carnegie Hall. Developing artists from all over the world are put through what is described as a "rigorous" audition process with ten pianists and ten vocalists making the final cut. Those lucky and talented few, receive one-on-one lessons from Ms. Fleming during the day for a week, and then master classes at night with other famous singer/musician teachers. The program concludes with a showcase recital at Carnegie's Zankel Hall. Teachers of the four master classes in the just-concluded 2023 edition of SongStudio, featured soprano Golda Schultz, mezzo Jamie Barton, pianist Hartmut Holl and Ms. Fleming herself. This reporter was able to attend the master classes by Ms. Fleming and Ms. Barton and the concluding concert.  (The students also receive some instruction on how to market and produce their work.)

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675824214/media/2023/02/Carnegie_Sun_CH11305106_rhldnt.jpg){{% /md %}}

<figcaption>Tenor Zhuohan Sun and pianist Yuriko Watanabe in masterclass with Renée Fleming, Weill Music Room/Carnegie Hall, February 2, 2023. Photo: Fadi Kheir.</figcaption>  
</figure>

Since announcing her retirement from staged works (though she returned recently to the Met for the new opera, _The Hours_) Ms. Fleming has toured the world in concert with programs consisting almost entirely of art songs. (In her master class, she told the audience that she prefers dropping the "art" and just referring to the programming as "song.") Half of her concert in Los Angeles ([reviewed here 2/8/18](/heavenly-voice-visits-the-city-of-angels/)), was devoted to German lieder, by Brahms. Upcoming concerts, where she will be accompanied by Evgeny Kissin, promise to have some focus on Russian music, including the prolific songwriter Sergei Rachmaninoff. Unlike opera, which has a large but finite canon, song is, in Ms. Fleming’s words, "infinite," as there are countless songs in many languages which have already been written, with countless numbers to come.

> When it's really good, it actually sounds smaller in your ear and so you think it's wrong but you have to trust that it's right.

More than anything, Ms. Fleming and Ms. Barton blanketed their students with encouragement and positivity. She acknowledges that singing this kind of music is difficult and exhausting. But Ms. Fleming said singers should never tell themselves "don't do that" when making mistakes or failing challenges (such as a mezzo having to hit an A or a tenor hitting a B-flat.)  She assured them that they will develop muscle memory to overcome chronic problems. "Singers don't have psychologists like sports figures," she said, and they can only overcome by ruminating and wrestling with these things in the practice room. (Sitting in the practice room at Carnegie Hall one is reminded of the old joke about "how to get here.")

Singers try too hard, often pushing too much air into a phrase or attempting to "hold" their voices to maintain control. One singer was shaking, holding on during a long, sustained note. Ms. Barton taught that the key was actually freedom – letting go. And Ms. Fleming reminded them that success was actually counterintuitive – when it's really good, it actually sounds smaller in your ear and so you think it's wrong but you have to trust that it's right.

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675824864/media/2023/02/Carnegie_Rognerud_CH11305211_Fotor_lqzls0.jpg){{% /md %}}

<figcaption>Soprano Eirin Rognerud and pianist Malte Schäfer, SongStudio Young Artists Recital, Zanker Hall/Carnegie Hall, February 4, 2023. Photo: Jennifer Taylor.</figcaption>  
</figure>

Ms. Fleming also gave helpful tips to the accompanists. During a Rachmaninoff piece, she told the pianist that Russian music must always have a "deeper" quality and that even the marking in sheet music of "piano" (as in "softly") is never completely "piano." (Note: the accompanists they have chosen for this program were clearly the best of the best candidates.)

The SongStudio students chose their own material, and while both Ms. Fleming and Ms. Barton helped with technique and what Ms. Fleming referred to as "diva secrets," they both emphasized "storytelling" for each piece. The musical complexity and difficulty of many of the compositions naturally skew singers toward the notes, but as Ms. Barton put it, "strip away the score and remember what you're saying." Make audiences "hang on phrases," wondering "what will happen next?" Ms. Fleming also encouraged the singers to animate the songs through the use of their faces and bodies, and to remember to give the songs "colors," because the composers and poets were more like "painters." She also encouraged the students to find a "personal connection" to the songs and to not be afraid of being "vulnerable."

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675825093/media/2023/02/Carnegie_Carmack_CH11305205_bgxw2s.jpg){{% /md %}}

<figcaption>Mezzo-soprano Maire Therese Carmack, SongStudio Young Artists Recital, Zankel Hall/Carnegie Hall, February 4, 2023. Photo: Jennifer Taylor.</figcaption>  
</figure>

Over the centuries, songs have been written in many languages. At SongStudio alone, you had German, Norwegian, Belgian, Spanish, Russian, French and English represented. The singers and pianists themselves represented no less than twelve countries. Many of the singers were multi-linguists – one of whom spoke seven languages. The training in this area was impressive – how remarkable, for example, to see a native Brazilian (baritone Vinicius Costa) sing with perfect German diction. It's a big challenge, as Ms. Fleming pointed out, "to bring a language to life that isn't your own." Ms. Fleming's favorite language to sing is French, and she taught her students to not "under-pronounce" – to "exaggerate the elegance of the language" and "explore each syllable." Ms. Barton is a lover of German, and marvels at how there are "multiple expressions describing everything."

Though worldly in language, the themes of the songs here were quite similar. They abounded with references to the beauty of nature, often describing in detail meadows, rivers, flowers and trees, and the simple life of those who live in the pastoral world. Some of the songs are very sexy, such as "Heimlich Aufforderung" by Strauss, where a lover flirts at a dinner party while eating and drinking, and looks forward to leaving the party discreetly for an assignation in the garden.

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675825021/media/2023/02/Carnegie_Costa_CH11305197_bnornh.jpg){{% /md %}}

<figcaption>Bass-baritone Vinícius Costa and pianist Hikaru Kanki, SongStudio Young Artists Recital, Zankel Hall/Carnegie Hall, February 4, 2023. Photo: Jennifer Taylor.</figcaption>  
</figure>

In the final concert, it was the women who seemed to incorporate what they had learned and had the most effective performances. They presented the drama and comedy of the stories they were telling and used everything they had to get there, not just their well-oiled vocal chords. And while tenor Zhuohan Sun and baritone Yuriy Hadzetskyy exhibited vocal perfection (and Hadzetskyy in particular had a tremendous presence) they seemed only slightly less uncomfortable then they were in the practice room. The same went for all the men, none of whom seemed quite sure what to do with their arms. Hadzetskyy could only match his expressive voice with his left hand.

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675824592/media/2023/02/Carnegie_Hadetsyy_CH11305217_gd8p02.jpg){{% /md %}}

<figcaption>Baritone Yuriy Hadzetskyy and pianist You Zhao, SongStudio Young Artists Recital, Zankel Hall/Carnegie Hall, February 4, 2023. Photo: Jennifer Taylor.</figcaption>  
</figure>

Two mezzos were the stars of the evening. Shannon Keegan programmed for herself a mini-concert, Franz Schubert’s "Der Einsame," and Samuel Barber's "The Desire for Hermitage," with both songs exploring the happiness and sadness of finding oneself alone. Ms. Keegan is a tremendous vocalist, but proved herself to be an actress as well, able to find her way believably and honestly into the deep feelings in the text. At one point, during a piano interlude, she turned her back to the audience and looked down at the keyboard as if it were another character on stage with her.  In her class with Ms. Barton, Ms. Keegan laughed about her "musical theatre me," but she obviously got her acting chops from somewhere, and if it was musical theatre then it's nothing to laugh off. Next time, SongStudio might want to include an actual acting class as part of its master class week.

Likewise, mezzo Maire Therese Carmack effectively used every tool at her disposal. In the song "Animal Passion" by Jake Heggie, she used the piano to lean or pose suggestively to interpret the highly sexual imagery of poet Gini Savage, who describes the desire for a passionate love as frenzied and free as a wild cat. (Credit for some clever lyrics such as "let the voyeurs voyent.") Her other piece, "Befreit" ("Released") by Richard Strauss, was set to the text of Richard Dehmel, whose poems inspired songs by many German composers. Animating her face and body, as per the master class instructions, Ms. Carmack easily navigated the deliberate contradictions of the words. While the theme is death, the singer must also convey the joy that will come from it – literally, "O, Gluck" ("O, joy.") She built the dramatic tension of the song, ending with a long, stirring final note. Ms. Carmack has many opera credits and even prior to SongStudio, she clearly had some performance training.

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675824355/media/2023/02/Carnegie_Wajnberg_CH11305215_evrwui.jpg){{% /md %}}

<figcaption>Soprano Charlotte Wajnberg and pianist Aaron Wajnberg, SongStudio Young Artists Recital , Zankel Hall/Carnegie Hall, February 4, 2023. Photo: Jennifer Taylor.</figcaption>  
</figure>

The same can be said for Belgian soprano Charlotte Wajnberg, accompanied by her husband Aaron Wajnberg. Again, you can see the seasoned actor who has appeared in a number of operas, rather than a career of recitals.

The inherent difficulty in attending song recitals is the language barrier. Opera companies have overcome this with supertitles. Also, the librettos for operas are readily available and audiences can do their homework no matter what languages they speak. With no such help at a concert like this and with the rather obscure compositions, one is dependent on trying to look at the librettos in the dark while trying to focus on the actual performers on stage. During the classes, each singer gave a summarized translation before each performance and one wishes that the singers had done this in the actual concert. If we don’t know every single word, we can at least get the overall gist and then let our imaginations run.

If opera can be seen as a circle struggling to widen the circumference of its audience, concerts consisting of song alone are a much smaller and much more esoteric circle. Ms. Fleming is trying to change that and is currently devoting her life to ensuring that there will be at least one more generation of song artists. With programs like SongStudio and Ms. Fleming as the medium’s very active and visible cheerleader, that much seems certain.