+++
author = ["authors/megan-moore.md"]
categories = "How-to"
date = "2015-12-12T12:34:00-05:00"
lastmod = "2015-12-17T12:15:00-05:00"
preamble = "We're continuing our [Song Guides](/song-guides-die-nacht/) series with another guest post by mezzo-soprano and founding member of the art song initiative [Lynx Project](/scene/companies/lynx-project/), [Megan Moore](/scene/people/megan-moore/). \"Widmung\" is one of many songs Robert Schumann wrote for his wife, Clara. Interesting history is the fun part, and to get there, singers need to master things like singing legato in German, and pulling off a successful two-against-three. Moore helps her fellow Lieder lovers through this beauty of German Romanticism. The text, as translated by Emily Ezust on [lieder.net](http://www.lieder.net/lieder/get_text.html?TextId=14028):\n\nYou my soul, you my heart,\nyou my bliss, o you my pain,\nyou the world in which I live;\nyou my heaven, in which I float,\no you my grave, into which \nI eternally cast my grief.\nYou are rest, you are peace,\nyou are bestowed upon me from heaven.\nThat you love me gives me my worth;\nyour gaze transfigures me;\nyou raise me lovingly above myself,\nmy good spirit, my better self!"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450370548794/2015-12-17---Clara.jpg.jpg"
primary_image_credit = "Clara Schumann, née Clara Wieck."
publishDate = "2015-12-17T12:12:00-05:00"
related_articles = ["articles/song-guides-die-nacht.md","articles/aria-guides-quando-men-vo.md"]
related_companies = ["scene/companies/lynx-project.md"]
related_people = ["scene/people/megan-moore.md","scene/people/caitleen-kahn.md"]
short_description = "We&#039;re continuing our Song Guides series with another guest post by mezzo-soprano and founding member of the art song initiative Lynx Project, Megan Moore. Schumann&#039;s &quot;Widmung&quot; is one of many songs Robert Schumann wrote for his wife, Clara. That&#039;s the fun part, and to get there, singers need to master things like singing legato in German, and pulling off a successful two-against-three."
slug = "song-guides-widmung"
title = "Song guides: Widmung"
+++

## So what is the correct tempo, anyway?

The piece is set in 3/2 and marked "innig, lebhaft". "Lively", people! We can be "innig" ("intimate", "heartfelt") without languishing, am I right? It’s also important to note that the "B" section traditionally, and I think appropriately, tends to yield slightly in tempo, so it’s really important not to start too slowly. On the other hand, Schumann sets us up with three distinct beats per measure, which definitely implies at least some broadness in tempo. Considering there’s room for flexibility within the lines, it’s important not to marry ourselves to a metronome marking, but find a broadness in the three pattern that balances with a lively energy; never faster than allows for clear text. 

## A thought on the piano part

Schumann writes an exciting, rhythmically energized line for the piano to start and end the piece, but singers: this is not our cue to abandon the long, beautiful line Schumann wrote for us. We can think of the piano’s rushing line as the excitement and passion of love boiling within us, while above it we maintain a sense of calm awe. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450369874251/Song-Guide---Widmung-p1---annotated.jpg.jpg)</figure>

1. The poem is essentially a long list, and a breath or lift after every single comma is unnecessary and even detrimental to the long legato phrases Schumann intended. A breath after "Seele", for example, is probably not needed. The first vocal phrase really continues through the half rest in measure three, and the breath and energy should continue through it. Clearly defining a concept of the different images presented in the poem will make the text clear. Making sure the important words, such as "Seele" and "Herz", are emphasized in phrasing and vocal color will also aid in textual clarity.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450369541730/Song-Guide---Widmung-p-2.jpg.jpg)
</figure>2. On the other hand, lifts or small breaths, after "lebe", for instance, are helpful, both textually and technically. The images listed in the text are now being elaborated upon, and the break will help with clarity. It also aids in the 
integrity of the legato line through "schwebe". In such an instance, this breath must be a lift: quick enough to not slow the climbing momentum and energy of the line.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450369948173/Song-Guide---Widmung---p3---annotated.jpg.jpg)
</figure>3. Make sure the [v] in "Wonn'" is articled on top of the pitch, as this can be a tricky place in the voice.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450369862912/Song-Guide---Widmung---p2---annotated.jpg.jpg)</figure>4. Repeated closed vowels on a Gb: not the nicest of Schumann. Make sure you aren’t biting down on the diphthong in “darein”. Hold the [a] until the last possible moment. Allow plenty of space in the mechanism through the end of the phrase.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450370247628/Song-Guide---Widmung---2-on-3.jpg.jpg)
</figure>5. Two against three! Make sure to sustain the integrity of the quarter notes of this middle section against the triplets in the piano’s right hand.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450370350575/Song-Guide---Widmung---L.jpg.jpg)</figure>6. Really stretch this *ritardando* across the bar line. Create added anticipation by enjoying the articulation of the [l] in “liebend”, almost as if it to double it. This will intensify the delicious modulation back to tonic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450370285274/Song-Guide---Widmung---ritard.jpg.jpg)
</figure>7. Think of tenuto markings over "mein guter Geist". This will give energy to the 
ritardando, and new emphasis as the text repeats for the final time.



## A note on the postlude

We all know what’s quoted here, right? It's a phrase from Schubert's *Ave Maria*, supposedly a favorite of Clara’s and often heard at weddings. Schumann wrote this piece in 1840, during his "year of song" and wrote it, along with the rest of Op.25, for his beloved Clara as a wedding gift. 

>Have questions? Want to request a piece for our Song Guides or Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).
