+++
author = ["authors/caitleen-kahn.md"]
categories = "How-to"
date = "2015-11-19T13:47:00-05:00"
lastmod = "2015-11-20T11:10:00-05:00"
preamble = "We've gotten great feedback from our ongoing series of Aria Guides, and so we've decided to branch out, into the world of art song. Soprano Caitleen Kahn, co-founder of the art-song-friendly [Lynx Project](/scene/companies/lynx-project/), kicks off our Song Guides with a staple from the repertoire. \"Die Nacht\" is a song taken from Richard Strauss's 1885 set, *8 Gedichte aus \"Letzte Blätter\"*, in which you'll find other favourites like \"Zueignung\" and \"Allerseelen\". Kahn offers up some proactive tips for singers of this gorgeous *Lied*. The text (translated by Lawrence Snyder and Rebecca Plack):\n\n>\"Aus dem Walde tritt die Nacht aus den Bäumen schleicht sie leise, schaut sich um im weitem Kreise, nun gib acht.\nAlle Lichter dieser Welt, alle Blumen, alle Farben löscht sie aus und stiehlt die Garben weg vom Feld.\nAlles nimmt sie, was nur hold, nimmt das Silber weg des Stroms, nimmt vom Kupferdach des Doms weg das Gold.\nAusgeplündert steht der Strauch, rücke näher, Seel an Seele; O die Nacht, mir bangt, sie stehle dich mir auch.\"\n\n>\"Night steps out of the woods, and sneaks softly out of the trees, looks about in a wide circle, now beware. All the lights of this earth, all flowers, all colors it extinguishes, and steals the sheaves from the field.\nIt takes everything that is dear, takes the silver from the stream, takes away, from the cathedral's copper roof, the gold. The shrubs stand plundered, draw nearer, soul to soul; Oh, I fear the night will also steal you from me.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448035818169/2015-11-19%20-%20Die%20Nacht.jpg.jpg"
publishDate = "2015-11-20T08:52:00-05:00"
related_articles = ["articles/aria-guides-deh-vieni-non-tardar.md","articles/aria-guides-una-voce-poco-fa.md","articles/song-guides-widmung.md"]
related_people = ["scene/people/caitleen-kahn.md"]
short_description = "We&#039;ve gotten great feedback from our ongoing series of Aria Guides, and so we&#039;ve decided to branch out, into the world of art song. Soprano Caitleen Kahn, co-founder of the art-song-friendly Lynx Project, kicks off our Song Guides with a staple from the repertoire. &quot;Die Nacht&quot; is a song taken from Richard Strauss&#039;s 1885 set, 8 Gedichte aus &quot;Letzte Blätter&quot;, in which you&#039;ll find other favourites like &quot;Zueignung&quot; and &quot;Allerseelen&quot;. "
slug = "song-guides-die-nacht"
title = "Song Guides: &quot;Die Nacht&quot;"
+++

## Some general wisdom

It’s German! Consonants are critical! In order to ensure that they do not interrupt Strauss’s beautiful line, keep your resonant space open and don’t stop the sound. Especially for laterals and nasals [l,m,n], sing through the consonants! Also pay close attention to long and short vowels, and allow more time on the consonants following short vowels (and double consonants) without closing down the vowel too early, of course.

## The details

1. The texture in this song begins quite sparsely, and requires the voice to lock in precisely and cleanly to the piano accompaniment. Because of the sparseness of the accompaniment, the singer should be wary of under-singing or "holding" the tone and not letting the voice ring freely. The line must still have forward motion, and in German particularly, must travel to final (most important) idea in the line! "Aus dem walde tritt die Nacht" for example, should take care not to lose momentum on the long "Walde" and to carry through all the way to "Nacht" (the subject of the sentence, and appropriately, the title of the song!).<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447958980498/Song-Guide---Die-Nacht---p1---annotated.jpg.jpg)
</figure>

2. There are **many** places in this song where the voice leaps up (often by a sixth) or down (by as much as a seventh). Singers should take care to maintain a beautiful legato line, especially on the descending leaps (watch for intonation—you’re very exposed!).  And they should make sure to start the lines that will leap up in a place where they won’t need to make a huge "adjustment" to compensate for the new register. <figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447959149322/Song-Guide---Die-Nacht---p2---annotated.jpg.jpg)
</figure>

3. These ascending passages are tricky! Keep the breath flowing throughout the passage and don’t "hold!" But DO make sure you have enough breath to sustain and grow on the top note. Particularly for the second passage, make sure you have enough air to carry through the G into "weg das Gold," with a beautiful legato.<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447959308403/Song-Guide---Die-Nacht---p3---annotated.jpg.jpg)
</figure>

4. The final section, beginning with "Ausgeplündert," marks a change of mood. Be sure to acknowledge this with a change of color in your voice—this is when the poem begins to get darker, and the fear of loss truly creeps in. <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447959334057/Song-Guide---Die-Nacht---p4---annotated.jpg.jpg)
</figure>

5. Time your crescendo carefully for "rükke näher, Seel’ an Seele". Get big too soon, and you’re left with no where to go by the middle of the line! Keep the momentum of the line and of your breath going through the low F# and back up again to the D. The diminuendo doesn’t start until the next phrase (Of course, you also don’t want to land on the unstressed syllable of "Seele," just make sure you’re not coming too far down dynamically with the beginning of "O, die Nacht", shown below).<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447961185024/Song-Guide---Die-Nacht---p5---annotated.jpg.jpg)</figure>

6. Set up your position for the final pianissimo on "stehle" with the preceding "sie". This is probably the most critical moment in the song, musically and textually. A color change here is also very appropriate, matching the change of color in the piano — we’ve just tonicized C Major and it’s haunting!.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447959553679/Song-Guide---Die-Nacht---p7---annotated.jpg.jpg)
</figure>

7. "Dich mir auch" is one thought! Even though there are rests separating the words, keep the momentum of the line going all the way through the end.

>For more, check out some of our Aria Guides in our [How-To section](/categories/how-to/). To request a song or aria, get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).
