+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2017-12-12T21:05:00-05:00"
lastmod = "2017-12-12T21:05:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513130709829/2017-12-12---Conductor-James-Levine.jpg.jpg"
primary_image_credit = "Photo: Associated Press."
publishDate = "2017-12-12T21:05:00-05:00"
related_articles = ["articles/operas-sexual-assault-secret.md","articles/musicians-sexual-harassment-blurred-lines.md","articles/audition-season-or-the-annual-festival-of-shattered-dreams.md","articles/when-opera-companies-protect-abusers.md","articles/levines-ugly-exit-the-disposable-met.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
short_description = "When it comes to Levine&#039;s abuse of those who are younger than him and who looked up to him, I&#039;m almost at a loss. Should he be judged for his actions in a contemporary arena, where the tolerance for is closer to zero? Should he be one who takes the fall for an industry that has turned a blind eye for too long? Should we crane our necks and look past Levine, towards the next abuser?"
slug = "some-uncomfortable-questions-about-the-levine-business"
title = "Some uncomfortable questions about the Levine business"
+++

"As anyone who truly knows me will attest, I have not lived my life as an oppressor or an aggressor." So said James Levine in a [statement](http://www.bbc.com/news/entertainment-arts-42278843) following fresh [accusations ](https://nypost.com/2017/12/02/legendary-opera-conductor-molested-teen-for-years-police-report/) of sexual assault and molestation of younger men.

After the accounts coming from four alleged victims - who tell similar stories of extended periods of abuse by Levine - the conductor and Music Director Emeritus of The Metropolitan Opera will [not face criminal charges](https://www.nytimes.com/2017/12/08/arts/music/james-levine-met-opera.html) over the accusations made in 2016 by Ashok Pai, who told police that the abuse began when he was 15.

After a report was filed last year in response to Pai's account, a detective contacted Met General Director Peter Gelb; Levine denied everything, and the Met excised themselves from the investigation, leaving it to the police.

Now, after the *New York Post* led what became a [series of new accusations](https://www.nytimes.com/2017/12/03/arts/music/james-levine-met-opera.html), the Met has suspended Levine from his upcoming conducting gigs with the company.

For many, the Met's actions scream, *too little, too late*. "Speculation surrounding Mr. Levine’s private life has swirled in classical music circles for decades as he rose to a position of unprecedented prominence at the Met," writes Michael Cooper in [*The New York Times*](https://www.nytimes.com/2017/12/03/arts/music/james-levine-met-opera.html). 

Indeed, his behaviour has been somewhat of an open secret among operatic circles; there are also the complementary rumours of the Met's having paid off decades' worth of accusers. Yet open secrets do not necessarily amount to damning evidence.

I am not one of those people who agrees that we should, as a gesture of solidarity or support, believe every alleged victim who claims sexual assault. Within the legal system, there are indeed hurdles - victim shaming, power imbalance, sexism - preventing accusers from always getting the credibility due to them; but automatically deeming every accusation as true is not a reasonable answer to the problem.

In the case of Levine, however, I do believe these accusers. His behaviour is detestable, and the fact that he won't face criminal charges (in this case) is saddening and gross.

A few questions arise; I'll ask them here, at the risk of becoming unpopular:

**The first question**: can we punish individuals for actions taken within a society that effectively permits their actions? 

The opera world is notoriously heirarchical, and competitive enough to create eager-to-please, unlikely-to-say-no young artists hoping to get their foot in the door. "Sleeping one's way to the top" does indeed happen within these circles - but perhaps it's more taboo to admit that it doesn't always end in tears, and it's not always abuse. Careers have been made this way - perhaps some of them by Levine himself.

On top of all of this is the fact that in the 1970s, when these abusive encounters began, Levine was a young conductor whose career was rising quickly; within the opera world, he was as much of a rockstar as one could get.

So, should we instead turn our attention more aggressively to the institution - the Met, of course, but perhaps the larger worlds of opera and classical music - rather than the individual? And maybe that's what's already happening; if you look at the comments on the Met's [Facebook post](https://www.facebook.com/MetOpera/posts/10159806195345533) following the initial December 2 story, it's clear that people are pointing fingers at the company for its perceived collusion and cover-ups.

That takes me to my **next question**: do we want the Metropolitan Opera to suffer for their handling of a figure like Levine? 

Open secrets and rumours - like the ones about the Met's paying to silence accusers - may not have legal weight, but they certainly pack a punch when it comes to public opinion. (Think: *Peter Grimes*)

The demographic of people who are most likely to denounce the Met for showing any whiff of support for Levine is the same demographic that the Met and every other opera company is trying to woo. Whether it's founded in fact or not, bad press surrounding sexual assault allegations and potential turning of a blind eye are nearly universal deal-breakers. With such a bad first impression, why would newcomers forgive the Met's actions for the sake of supporting opera and its artists?

I'm not saying that protecting the industry is a reason to forgive and forget Levine's actions; there isn't a reason to do that, period. But it's likely that there's no way to do so without dragging down the Met's reputation - whether they deserve it or not.

Since there are so many opera devotees who are weighing in against the Met on this topic, it's important that we ask ourselves: what happens if the Met loses ticket sales and donors, and takes a major financial hit because of this? Are we prepared for such a large void in the opera world?

The people in this industry - like Levine - who abuse and take advantage of their power are acting abhorrently, and need to be outed and stopped. And quite frankly, if the wave of exposing sexual harassers hits the opera world with any sort of thoroughness, there may be very few "innocents" left standing. It follows, then, without a shadow of a doubt: the problem lies within the institution, and it is larger than individuals.

Truthfully, we've all known this to be the case for many years. [I've written about it](/musicians-sexual-harassment-blurred-lines/) before, and [so have others](/operas-sexual-assault-secret/). Sometimes it's not even about sexual abuse, but about [abuse of power](/audition-season-or-the-annual-festival-of-shattered-dreams/). 

When it comes to Levine's abuse of those who are younger than him and who looked up to him, I'm almost at an exhausted loss. Should he be judged for his actions in a contemporary arena, where the tolerance for is closer to zero? Should he be punished, representative of an industry that has turned a blind eye to this garbage for too long? Should we crane our necks and look past Levine, towards the next abuser?

Is it enough that now, with Levine's open secrets newly exposed in the #MeToo era, there are likely others out there on podiums or in director's chairs who are shaking in their boots?
