+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2021-08-07T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1628190283/media/2021/08/sqTNnozze_StevenPisano_ihkkc0.jpg"
primary_image_credit = "Hans Tashjian as Figaro in Il barbiere di Siviglia, Teatro Nuovo, 2021. Photo: Steven Pisano."
related_articles = ["articles/in-review-the-barber-of-seville-at-the-coc.md", "articles/in-review-the-barber-of-seville-at-roh.md", "articles/barber-mo.md"]
related_companies = ["scene/companies/teatro-nuovo.md"]
related_people = ["scene/people/nicholas-simpson.md", "scene/people/hannah-ludwig.md", "scene/people/hans-tashjian.md"]
short_description = "Indeed Barber, the most thoroughbred of warhorses and the ultimate comic opera, has the potential to delight anew with a sense of tradition that feels like innovation, even in a sprawling park on a smiling summer night."
slug = "smiles-of-a-summer-night-barber-brings-live-opera-back-to-new-york"
title = "Smiles of a Summer Night: Barber brings live opera back to New York"
youtube_url = ""

+++
The night smiled, twice in fact, on two late July performances of Rossini's _Il barbiere di Siviglia_ in a semi-staged production by Teatro Nuovo. An ebullient New York City audience was delighted to be there for the return of live opera. Performing outdoors in the vast Damrosch Park at Lincoln Center, this _Barber_ would have played to better advantage in a smaller venue but an inviting park setting, with a socially distanced audience, heightened the pleasure of living and breathing opera. It was an occasion of considerable intelligence and charm.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1628190378/media/2021/08/TNnozze_StevenPisano_1_dhs3cq.jpg){{% /md %}}

<figcaption>(l-r) Hans Tashjian (Figaro), Alina Tamborini (Berta), Hannah Ludwig (Rosina), Scott Purcell (Doctor Bartolo), and Nicholas Simpson (Almaviva) in Il barbiere di Siviglia, Teatro Nuovo, 2021. Photo: Steven Pisano.</figcaption>

</figure>

The pulse of the city, which is to say the usual noise, seemed to agree or at least cooperate. Audiences appeared to be unbothered and the artists soldiered on through the hum of traffic and a siren or two. Even the airplanes flying northbound over the Hudson River were, like the audience, exceedingly well-mannered.

But the nights were not all smiles. The amplification of the orchestra and singers, always an issue for opera, was a mixed blessing in the park. The orchestra sounded thin and oddly dispersed, especially during the familiar overture that was not a harbinger for the effervescence to come. Happily the singers, a youthful and vibrant crew, sounded wonderfully natural. In fact it wasn't until a momentary sound drop on Wednesday night, caused by an ill-fitting microphone on a member of the chorus, that the degree of vocal amplification became evident.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1628190605/media/2021/08/TNnozze_StevenPisano_5_wd83m4.jpg){{% /md %}}

<figcaption>(l-r) Nicholas Simpson (Almaviva) and Hans Tashjian (Figaro) in Il barbiere di Siviglia, Teatro Nuovo, 2021. Photo: Steven Pisano.</figcaption>

</figure>

Teatro Nuovo, which emerged from Will Crutchfield's 20-year stint conducting early 19th-century Italian operas at the Caramoor Festival's Bel Canto at Caramoor program, brought to the fore its commitment to period performance practices. An orchestra of 35 musicians sized to match that of the opera's 1816 premiere, was co-conducted by Crutchfield at the fortepiano and Teatro Nuovo's Associate Artistic Director, violinist, Jakob Lehmann, concertmaster for the orchestra, conducting from a stool. Duo conductors were common back then and here we had an accomplished pair. Singers during Rossini's time were encouraged to embellish arias with their own ornamentation, an opportunity seized with skill by the group, bringing freshness and added agility to the composer's score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1628190418/media/2021/08/TNnozze_StevenPisano_2_zxe5mw.jpg){{% /md %}}

<figcaption>Hannah Ludwig (Rosina) and Nicholas Simpson (Almaviva) in Il barbiere di Siviglia, Teatro Nuovo, 2021. Photo: Steven Pisano.</figcaption>

</figure>

Amplification wasn't needed to know by his sly walk and rather haughty posture that bass [Hans Tashjian](/scene/people/hans-tashjian/) was Figaro. In a role Rossini originally intended for a tenor, Tashjian was an insinuating presence complete with conspiratorial comedic timing and his penetrating voice that was ever so stinging when needed. Much felt new about this Figaro as if he discovered his capabilities along the way. Even standing silent this self proclaimed jack-of-all-trades was at work, keenly reviewing the situation and his next strategic move. That Tashjian might one day own this role is a reasonable expectation.

Casting a mezzo-soprano as Rosina, the vocal type for which Rossini wrote the part, is not unusual today though sopranos have also made the role their own. Vocal types did not strictly correspond to the composer's assignments in the early 1800's with roles frequently transposed to meet the needs of a preferred singer. Still the casting of mezzo-soprano [Hannah Ludwig](/scene/people/hannah-ludwig/) felt radical and refreshingly so. Ludwig made a particularly assertive Rosina, for whose affections Dr. Bartolo, her benefactor and Almaviva, the smitten count visiting Seville, both vie. Ludwig's Rosina was more a truth-seeker than a determined and perplexed ingenue. Her lustrous mezzo with rich lower register was enhanced by gorgeous ornamentation.She gave the role dramatic momentum, a fascinating counterpoint to the comedy. 

Tenor [Nicholas Simpson](/scene/people/nicholas-simpson/) as Almaviva got off to a rocky start but found his voice replete with handsome lyrical ornamentation by the time he serenaded Rosina below her balcony. This Almaviva was typically entitled and imperious but managed to be likable, no small feat. Simpson was a superb buffoon when disguised as Lindoro, the drunken solider, in a disheveled shirt without coat and tie, a welcome costume alteration.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1628190445/media/2021/08/TNnozze_StevenPisano_3_ocghvr.jpg){{% /md %}}

<figcaption>Kyle Oliver (Fiorello, front) and the Teatro Nuovo Chorus in Il barbiere di Siviglia, Teatro Nuovo, 2021. Photo: Steven Pisano.</figcaption>

</figure>

Baritone Scott Purcell's annoying Doctor Bartolo and bass David Fridley as his skeptical spy Don Basilio sang with characteristically ridiculous authority and reveled in the pervasive farce of the piece. Fridley also displayed a cold-heartedness that indirectly explains Ludwig's strong Rosina.

Baritone Kyle Oliver, a member of the chorus, appeared briefly as Fiorello, Almaviva's servant. Oliver distinguished himself with expressive and animated singing. Berta, Bartolo's maid, was sung by soprano Alina Tamborini with spunk to spare.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1628190491/media/2021/08/TNnozze_StevenPisano_4_izlzau.jpg){{% /md %}}

<figcaption>Co-conductors Jakob Lehmann (Concertmaster and Teatro Nuovo Assistant Artistic Director) and Will Crutchfield (Fortepiano, General & Artistic Director) in Il barbiere di Siviglia, Teatro Nuovo, 2021. Photo: Steven Pisano.</figcaption>

</figure>

Teatro Nuovo and Will Crutchfield, its founder and General and Artistic Director, prove that adherence to the practices of period performance can lead the way to new thinking about _Il barbiere di Siviglia_ and other early works. Indeed _Barber_, the most thoroughbred of warhorses and the ultimate comic opera, has the potential to delight anew with a sense of tradition that feels like innovation, even in a sprawling park on a smiling summer night.