+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-04-11T11:55:00+01:00"
draft = true
lastmod = "2017-04-11T13:34:00+01:00"
slug = "slippery-slopes"
title = "Slippery slopes"
+++

You've likely heard it said by singers for decades: opera is all about the voice. It's not correct to say that it's *only* about the voice, but it's certainly hard for opera to be the affective art that it is without that one element firmly in place.

Between the extremes of a play with no music, and an opera with nothing but music, there exists a spectrum of theatre genres, each with a different landscape of priority given to acting and singing. In a play, acting skills are the foundational requirements for the cast, the same way that a trained voice is a requirement for opera singers. And in the complicated middle ground of this spectrum - populated by the broad term of "musical theatre" - it's a murky balance of the two.

Perhaps you heard about [Calgary Opera's troubled production of *South Pacific*](https://beta.theglobeandmail.com/arts/theatre-and-performance/director-performer-resign-after-calgary-opera-casts-white-woman-for-asian-role/article34634649/?ref=http%3A%2F%2Fwww.theglobeandmail.com&cmpid=rss1&click=dlvr.it), which saw its director, a designer, and a performer walk out after the company has, to date, only managed to secure a white performer to play the role of Bloody Mary, who is Tonkinese/Polynesian. Bob McPhee, retired General Director of Calgary Opera, told *The Globe and Mail* that they indeed had a white performer "on hold" for the role while they continued their search for someone who was more race-appropriate; according to McPhee, the show's original director, Mark Bellamy, said, "'Well, I can't agree with that,' and he said, 'I want to pull [out].'"

I'm left wondering about the full reasons for Bellamy's exit. Presumably, he wasn't happy that Calgary Opera hadn't found a South Asian singer, and maybe the white performer who was on standby was the straw that broke the camel's back. Bellamy's stance is noble, but it begs the question: what was it about a South Asian singer that he couldn't do without?

In *South Pacific*, Bloody Mary sings the famed "Bali Ha'i"; as much as Rodgers and Hammerstein can do, the aria has an exotic sound, full of harmonies that are really different from other numbers in the show, like Emile's "Some Enchanted Evening" (Emile is white, by the way). "Bali Ha'i" calls for vocal strength in the chest and head registers, and enough power to acoustically fill a decent-sized theatre, judging from *South Pacific*'s Broadway premiere in 1949.

What I'm saying is that Bloody Mary isn't a role where you could "hear" race in a singer's voice. Essentially, the difference is in appearance, and that's where the slope gets slippery.

Firstly: though it may not be an appealing thought, there's more that can be done to alter a performer's appearance than alter the sound of her voice. Anyone who has seen *Madama Butterfly* or *Turandot* can vouch for this; given enough distance and make-up skill, sopranos like Kristine Opolais and Othalie Graham - neither of whom are Japanese or Chinese - can step into these leading roles. These women are being cast for their voices, because voice is the most important element in a large-scale opera; no matter how much distance between audience and stage, voices can't be helped with make-up or lighting or costumes.

Secondly: where does one draw the line? Would Bellamy have walked out of a production of *Tosca* if the lead soprano had not been Italian? What if his Aida had been blonde? Or what if his Senta had been Indian? Does it not further complicate things to remember that there are light-skinned Egyptians, dark-skinned Italians, blonde Latinos, and white Africans?

In fairness, Bellamy's exit was likely about more than appearance; it's easy to imagine that Calgary Opera's failure to find a race-appropriate singer, and their on-hold white singer, left a bad taste in the director's mouth. Perhaps the most interesting question about these matters is the one asked by McPhee, after he insisted that Calgary Opera was indeed making an honest attempt to find the right performer for the role: "It's not from a lack of wanting to be sensitive to the issue. I understand. But is there repertoire we stop doing if we can't accomplish that goal?"

Questions like these are even more important for companies located outside of metropolitan areas; when a show demands acting, singing, *and* racial accuracy, does that mean companies located in Calgary, Annapolis, or Barrie aren't "allowed" to do shows if they can't find someone who looks the part for every role? Does that truly serve the art and its audiences?

Circling back to the top: does this now mean that appearance trumps voice? Is a racially accurate cast guaranteed to offer a better performance than a cast filled with the best singers? Does *that* serve the art and its audiences?

Finally, is it insensitive to separate what are essentially two issues? In one column is the presence of prejudicial casting decisions, and in the other is the criteria involved in casting a show that calls for acting and singing.
