+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = "2018-05-08T11:12:00-04:00"
lastmod = "2018-05-10T20:14:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525792262349/sqVancouverOperaTheOvercoatcredTimMatheson195A5504e.jpg.jpg"
primary_image_credit = "Geoffrey Sirett in The Overcoat: A Musical Tailoring, Vancouver Opera, 2018. Photo: Tim Matheson."
publishDate = "2018-05-08T11:12:00-04:00"
related_companies = ["scene/companies/vancouver-opera.md","scene/companies/tapestry-opera.md"]
related_people = ["scene/people/geoffrey-sirett.md","scene/people/peter-mcgillivray.md","scene/people/andrea-ludwig.md","scene/people/erica-iris.md","scene/people/caitlin-wood.md","scene/people/giles-tomkins.md","scene/people/asitha-tennekoon.md","scene/people/aaron-durand.md","scene/people/magali-simard-galdes.md","scene/people/meher-pavri.md"]
short_description = "Sometimes they&#039;ll just lay under the bed and watch the action taking place, or curl up into a corner; it is creepy and odd, but works so well for this style."
slug = "slightly-unsettling-the-overcoat"
title = "Slightly unsettling: The Overcoat"
+++

[*The Overcoat: A Musical Tailoring*](https://www.vancouveropera.ca/2017/03/27/the-overcoat-a-musical-tailoring/) is the second opera in the Vancouver Opera Festival, and is a co-production with Tapestry Opera and Canadian Stage. This production runs in the smaller Vancouver Playhouse, rather than VO's normal venue the Queen Elizabeth Theatre, and has all the trappings of a piece that is part opera, part musical, and part dance. Those pieces add up to a quirky, off-beat modern opera that is offbeat, thought-provoking, and introspective.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525791674649/VancouverOperaTheOvercaotcredTimMatheson195A5475e.jpg.jpg)
<figcaption>(l-r) Aaron Durand, Geoffrey Sirett, and Keith Klassen in *The Overcoat: A Musical Tailoring*, Vancouver Opera, 2018. Photo: Tim Matheson.</figcaption>
</figure>

The setting itself is that of 1920s Russia, but with settings and characters that are all vaguely familiar. The protagonist, Akakiy (played by baritone [Geoffrey Sirett](/scene/people/geoffrey-sirett/)) is an accountant that is, appropriately, obsessed with numbers, though impoverished and friendless. His thoughts and story are brought to life by the mad chorus of [Magali Simard-Galdes](/scene/people/magali-simard-galdes/), [Caitlin Wood](/scene/people/caitlin-wood/), and [Erica Iris Huang](/scene/people/eric-iris/). These three were challenged with some phenomenally difficult harmonies that were executed so well. They were simultaneously heartwarming, and mildly creepy and off-putting in their interactions, and their ensembles were some of the highlights of the show. Huang was particularly charming as the tailor's assistant Mrs. P., her voice smooth and dark, and her long-suffering attitude was funny and charming.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525791931948/Overcoat-DahliaKatz-6048.jpg.jpg)
<figcaption>Meher Pavri, Courtenay Stevens, Peter McGillivray, Aaron Durand, Geoffrey Sirett, Giles Tomkins, and Asitha Tennekoon in *The Overcoat: A Musical Tailoring*, Vancouver Opera, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

The trio of [Keith Klassen](/scene/people/keith-klassen/), [Aaron Durand](/scene/people/aaron-durand/), and [Giles Tomkins](/scene/people/giles-tomkins/) as the antagonistic co-workers were cold and hostile in their menace towards Akakiy. Their ensemble pieces were such a pleasure to listen to, with harmonies that are eerie and dissonant, and added to their distasteful characters. 

The women in this are also somewhat of an exaggeration - from the ultra-sexy secretary played by [Meher Pavri](/scene/people/meher-pavri/) to the hyper-sexualized Landlady played by [Andrea Ludwig](/scene/people/andrea-ludwig/) (who reminded me of Carol Burnett's Miss Hannigan in *Annie*), the women are all a little over-the-top, to add to the feeling of this whole world being not-quite-right.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525791700023/VancouverOperaTheOvercoatcredTimMatheson195A2930abe.jpg.jpg)
<figcaption>Andrea Ludwig and Geoffrey Sirett in *The Overcoat: A Musical Tailoring*, Vancouver Opera, 2018. Photo: Tim Matheson.</figcaption>
</figure>

The entire piece is staged in a very hyper-realistic and slightly crazed way. Everyone's movements are slightly exaggerated, the acting is always a little too much, and the whole show has an odd pace which, along with a frenetic, energetic score, makes the strangeness of the production and the story all the more present. 

There are also movement performers (Colin Heath and Courtenay Stevens), who ostensibly move the set pieces around, but in this case added so much to the performance. While they speak and sing no lines, they interact with the cast, props, and set pieces in such dynamic and unique ways, adding even more to the mildly crazed feeling of everything. Sometimes they'll just lay under the bed and watch the action taking place, or curl up into a corner; it is creepy and odd, but works so well for this style.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525791735013/Overcoat-DahliaKatz-6273.jpg.jpg)
<figcaption>Caitlin Wood, Erica Iris Huang, Magali Simard-Galdes, Keith Klassen, and Colin Heath in *The Overcoat: A Musical Tailoring*, Vancouver Opera, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

Sirett as Akakiy was spectacular, with a difficult role that nearly never leaves the stage and a huge amount of movement and choreography, he was still vocally powerful throughout. While much of the score is more speech-like in the singing quality, when he finally opens up at the end of Act I, it was phenomenal, with such a beautiful strength that sounded effortless. 

The orchestra under the direction of Leslie Dala was significantly reduced from a standard opera orchestra, but the blend was flawless, and the difficult score sounded light and agile under Dala's direction.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525791751512/VancouverOperaTheOvercoatCredTimMatheson195A5374e.jpg.jpg)
<figcaption>Geoffrey Sirett and Courtenay Stevens in *The Overcoat: A Musical Tailoring*, Vancouver Opera, 2018. Photo: Tim Matheson.</figcaption>
</figure>

[*The Overcoat*](https://www.vancouveropera.ca/2017/03/27/the-overcoat-a-musical-tailoring/) is a modern blend of different art styles that add up to something very unique, and is put together in a way that is compelling, thought-provoking, and slightly unsettling (in a good way).

>The Overcoat runs through May 12. For details and tickets, [click here.](https://www.vancouveropera.ca/2017/03/27/the-overcoat-a-musical-tailoring/)
