+++
author = ["authors/john-hohmann.md"]
categories = "Interview"
date = 2020-05-17T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[Minnesota Opera's 2020-21 season](https://mnopera.org/season/2020-2021/), scheduled to open on September 26 and running through May 23, includes _The Abduction from the Seraglio_, _Eugene Onegin_ and _Cinderella_. Two contemporary operas, _Blue_, a racially charged work by Jeanine Tesori and Tazewell Thompson, and _The Shining_ complete the season."
preamble = "[Minnesota Opera](https://mnopera.org/season/2020-2021/at-home-with-mn-opera/)'s assistant conductor and chorus director Andrew Whitfield was busy producing a virtual production of \"Sleep Chorus\", from the Pulitzer Prize-winning opera [_Silent Night_](/kevin-puts-i-know-who-i-am-as-a-composer/) by Kevin Puts and Mark Campbell. The chorus gives voice to a Christmas night truce between warring soldiers in the trenches of World War I. Meanwhile, costume director Corinna Bakken along with costume and scene shop personnel and a raft of volunteers were busy in their homes sewing over 10,000 much-needed medical masks to protect against the Covid-19 virus.\n\nThe [company](https://mnopera.org/season/2020-2021/at-home-with-mn-opera/) launched the \"Sleep Chorus\" to promote a special fund raising drive to compensate artists on and off stage during the pandemic shutdown while the protective masks went to organizations without access to traditional health care resources including assisted-living homes, veterinarians, blood services, shelters, and more. I talked with Andrew Whitfield about these impressive undertakings."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1589567526/media/2020/05/sqMNOpera-SleepChorus_clrppm.jpg"
primary_image_credit = ""
related_articles = ["articles/covid.md", "articles/the-met-s-at-home-gala.md"]
related_companies = ["scene/companies/minnesota-opera.md"]
related_people = ["scene/people/kevin-puts.md"]
short_description = "The company launched the \"Sleep Chorus\" to promote a special fund raising drive to compensate artists on and off stage during the pandemic shutdown while the protective masks went to organizations without access to traditional health care resources including assisted-living homes, veterinarians, blood services, shelters, and more"
slug = "sleep-chorus-mask-making-keep-minnesota-opera-visible-during-pandemic"
title = "\"Sleep Chorus\" & mask-making keep Minnesota Opera visible during pandemic"
youtube_url = ""

+++
**You have the dual roles of assistant conductor and chorus master at Minnesota Opera. That sounds like a great job. Tell us about a typical day handling those position, especially in terms of the upcoming season, not that anyone has experienced anything "typical" in the last couple of months.**

**Andrew Whitfield:** In spite of current events, things have been rather typical of any period in which we are not in production. We are looking at the upcoming season, and planning. At the moment there are a lot of interesting virtual projects that we have been working on as well. Obviously it is not the same as working with people in person, but I feel very fortunate to have the diversion of making art during these very weird times.

**I've been sharing the "Sleep Chorus" with friends, all of whom think it's a wonderful production as do I. In the frame of pianist Allen Periello, your company's head of music, there is a video of you conducting. I assume each member of the chorus had that video.**

**AW:** Yes. I sent them the video of me conducting with Allen playing. I didn’t use a click-track for this chorus which I think was a good choice. Having a metronome slamming your eardrums, in my opinion, is antithetical to music-making. In the end, what you might lack in 100% precision, you get back in feeling.

<figure data-type="video">{{% md %}}<iframe width="1280" height="720" src="https://www.youtube.com/embed/HTbwy2wyudY" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

**Then you used the same technique as Yannick Nézet-Séguin when he conducted the MET orchestra in the Intermezzo from _Cavalleria rusticana_ for the MET's at-home gala.**

**AW:** I taught him everything he knows. But in all seriousness, when he explained the process of compiling the tracks for the orchestral excerpts, and specifically stated that he didn't want to use a click-track, I did feel somewhat vindicated.

**That says something about both of you. The two big virtual productions that caught my attention, one being the MET at-home gala of course and other the Stephen Sondheim 90th birthday celebration, both experienced some technical issues along the way. Did you run into any problems or are all the members of the Minnesota Opera chorus as technically savvy as you?**

**AW:** The MET made the very courageous decision to do their gala live. You lost some of the technical polish that you can achieve in post-production, but I think it was a good choice.  Seeing all those great artists in their living rooms was about as intimate as you can possibly get. As far as the technical prowess of the Minnesota Opera Chorus, I'll just say that I benefit from having a lot of millennials in my chorus.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1589566970/media/2020/05/MNO-SilentLightChorus-collage_bz5mng.jpg){{% /md %}}

<figcaption>Kevin Puts (right) and Mark Campbell (bottom left), composer and librettist of Silent Night, and Andrew Whitfield (top left), Assistant Conductor and Chorus Master, Minnesota Opera.</figcaption>

</figure>

**An admirable admission! I completely enjoyed the relatively primitive nature of both productions, especially the MET artists who accompanied themselves on the piano, like Erin Morley and Matthew Polenzani. Tell us about _Silent Night_. It premiered in 2011 at the Minnesota Opera and won the Pulitzer Prize. It was revived recently, correct?**

**AW:** It has had enormous success since its premiere. Minnesota Opera brought the original production back last season with most of the original cast. I had prepared the chorus at Opera San Jose a few years before, and it was very interesting to come back to the piece with the creators in the room. It's an experience you rarely have in opera. The production was recorded for commercial release in the near future.

**The "Sleep Chorus" video promotes the company's Artist Support Fund. Is there any indication yet of how that is going? Did the Minnesota Opera establish a policy regarding artists compensation during the shutdown? Obviously this has been quite an issue around the country since entire seasons were cut short or cancelled all together.**

**AW:** The [Artists Support Fund](https://my.mnopera.org/donate/contribute1) was a big success, and we were actually able to pay all, or most, of the fees for our canceled operas. I am very proud to work for an opera company that values their artists as highly.

**The company deserves a major pat on the back for that. And the community for its support as well. I read in the _New York Times_ about the medical mask making initiative. Aside from meeting a glaring, need Minnesota Opera's masks appear to have a certain cachet as well.**

**AW:** I think everyone in the costume and scene departments were very inspired by the initiative. It was moving to hear about the reactions of the healthcare workers when they were delivered. And they even sent me two masks, which are not only functional, but also fashionable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1589566954/media/2020/05/MNO-facemasks_pvnxdh.jpg){{% /md %}}

<figcaption>Protective masks were made by Minnesota Opera costume and scene shop personnel. Over 10,000 masks were distributed to health care workers, assisted-living homes, veterinarians, blood services, shelters, and other places in need. These masks pictured were made for MN Opera board members from material used is costumes for past productions including La Traviata, Carmen, and The Manchurian Candidate. Photo: MN Opera</figcaption>

</figure>

**They certainly are if those in the photo are any indication. I was surprised to learn that making the masks to medical specifications was so complex. From what I understand your costume department received material from a variety of sources to make the masks including old hospital gowns. It's great that health care providers could recycle their own materials to help meet the need.**

**AW:** \[Costume director\[ Corinna Bakken, and the entire Minnesota Opera costume department are miracle workers. One of my favorite days during the production period is the first day of tech in the theater when we first see the cast and chorus in their costumes. That is always the day when the opera starts to really come to life for me.

**You're working on another virtual project, this one with Paul Moravec and Mark Campbell that involves Opera America. This is the team who wrote _The Shining_, that is part of Minnesota Opera's** [**upcoming season**](https://mnopera.org/season/2020-2021/)**. What is the Opera America project and when can we see it?**

**AW:** The piece we are working on is called "Light Shall Lift Us". It was premiered in 2016 in memory of the victims of the Pulse nightclub shooting in Orlando, Florida. We have assembled over 100 of the most prominent singers in the business, including Ailyn Perez, Mary Dunleavy, Emily Pulley, Cecilia Lopez, Brenda Rae, Sasha Cooke, Daniela Mack, Jennifer Cano, Joyce Castle, Victoria Livengood, Matthew Polenzani, David Portillo, William Burden, Alek Shrader, Edward Parks, Soloman Howard, and Morris Robinson; all of whom donated their services. Although I look forward to being in front of a live ensemble again, I can't imagine ever having the opportunity to work with a more glittering array of artists.

<figure data-type="video">{{% md %}}<iframe width="1280" height="720" src="https://www.youtube.com/embed/u8A8fIGbYyY" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

**You mentioned earlier that you are planning for next season. I know the season closes with _The Shining_. Based on the Stephen King novel and with Stanley Kubrick's film in mind, it is bound to be an incredibly unnerving experience. What can you tell us about it?**

**AW:** So I was traumatized by the movie at an early age, and have had a fascination with the story ever since. I went in dubious as to whether the opera could live up to my high expectations, but I am happy to say that it absolutely does. In fact, in adds a lot more depth to the relationships between the characters in a way that only opera can do. I am very excited to dive into in next year.

**Having to contend with social distancing and staying indoors, it's great that performing arts organizations are stepping up to the plate to stay in touch by giving their audiences new things to look at and listen to. Do you think these computer-based events might become part of the "new normal" in cultural outreach in the post-pandemic world?**

**AW:** I don't think they will become the new normal. I think that the absence of art is only reinforcing how vital it is in all our lives, and once this is over, we will see a huge resurgence of people attending live performances. I do think, however, that there are a lot of lessons that will carry over into the "new normal" regarding how we incorporate technology into the process of putting on a show. I also feel that in one hundred years, historians will write books about the proliferation of art created during this strange time.

**It's apparent that Minnesota Opera places a high priority on community involvement and outreach. It must be gratifying to work in an organization that encourages such broad participation**.

**AW:** One of the things that I love most about Minnesota Opera is its commitment to promoting diversity in the world of opera. I am very fortunate to be in a state where there is a long tradition of choral singing, stemming from their Lutheran roots. This means a lot of very talented and skilled singers in the area. However, despite the readily available talent at my disposal, we are still very mindful of making sure that we are reaching out to communities who have been traditionally overlooked by the opera world to make sure that the group of singers on stage mirrors the actual community that we are serving.

**Andy, it's been a pleasure talking to you. Congratulations to you, Corinna Bakken and the company on some major accomplishments during this difficult time and best of luck with the 2020-21 season.**