+++
author = ["authors/erik-flaten.md"]
categories = "Review"
date = "2018-09-21T18:47:00-04:00"
lastmod = "2018-09-21T18:51:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569914373/sqSKYONSWINGS08SP.jpg.jpg"
primary_image_credit = "Martha (mezzo-soprano Marietta Simpson) experiences an Alzheimer's hallucination in Sky on Swings, Opera Philadelphia's O18 Festival, 2018. Photo: Steven Pisano."
publishDate = "2018-09-21T18:47:00-04:00"
related_articles = ["articles/brenda-rae-earns-her-ovation-in-o18-lucia.md","articles/racette-an-unmissable-elle-in-o18s-ne-quittez-pas.md","articles/the-astonishing-product-glass-handel-at-o18.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
short_description = "The most captivating moments in the opera are those that involve only von Stade and Simpson together onstage. They create a sense of emotional intimacy and truth, by superb acting and unshakable presence. Their performance is the epitome of genuine artistry and truthful expression."
slug = "sky-on-swings-a-mustsee-of-o18"
title = "Sky on Swings a must-see of O18"
+++

Last night at a bustling and energetic Kimmel Center, a sea of "Opera Ambassadors" in bright red shirts welcomed patrons to the opening of [Opera Philadelphia](/scene/companies/opera-philadelphia/)'s festival, [O18](https://www.operaphila.org/festival/). Opening in the Perelman Theater was the world premiere of [*Sky On Swings*](https://www.operaphila.org/whats-on/on-stage-2018-2019/sky-on-swings/), a one-act opera with music by Lembit Beecher and a libretto by Hannah Moscovitch. This is the duo's second year in a row presenting their collaboration to Philadelphia's opera crowd: [*I Have No Stories To Tell You*](/war-stories-o17/) captivated sold-out audiences during O17.

*Sky on Swings* tells a story that is centered around two women living with Alzheimer's disease. While the plot is simple, the entire work is enhanced by the free pre-show Opera Overtures talk, led by Education Manager, Steven Humes. Opera Overtures take place in the SEI Innovation Studio, one hour prior to curtain for each performance. Humes draws attention to the tremendous journey that Beecher's and Moscovitch's work has undergone to reach its premiere. Their opera is a product of meticulous planning and straightforward storytelling. Beecher's extensive research on Alzheimer's is reflected in his vocal writing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569674595/SKYONSWINGS14SP.jpg.jpg)
<figcaption>Danny (Frederica von Stade) struggles to come to terms with her condition. *Sky on Swings*, Opera Philadelphia's O18 Festival, 2018. Photo: Steven Pisano.</figcaption>
</figure>

*Sky on Swings* presents juxtapositions of simplicity and complexity, and fantasy and reality are frequently seen back to back. The core cast consists of only eight singers, but there are often almost thirty people onstage. The four principle characters, Danny, Martha, Ira, and Winnie are connected as family, but they are separated by age and disease. The set, designed by Andrew Lieberman, is simultaneously stark and beautiful. Its bareness is haunting, and when paired with the lighting design by Pat Collins, the singers are elevated even further to a place of heightened expression, which is thrilling. While the opera weaves in and out of reality and fantasy, the contemporary costume designs by Tilly Grimes contribute a sense of relatability.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569662011/SKYONSWINGS02DM.jpg.jpg)
<figcaption>Danny (mezzo-soprano Frederica von Stade) argues with her son, Ira (tenor Daniel Taylor), over her forgetfulness, as he pushes her to take an Alzheimer's test. *Sky on Swings*, Opera Philadelphia's O18 Festival, 2018. Photo: Dominic M. Mercier.</figcaption>
</figure>

Mezzo-soprano Frederica von Stade, one of the greatest American artists of our time, portrays the character of Danny. Von Stade's voice, showing no sign of aging, still carries its famous warmth and lush sound. Daniel Taylor, a young but skilled tenor, sings the role of Danny's son, Ira. Taylor sings with ease, truth, and consistency. The mother and son moments between Taylor and von Stade are warm and touching. Marietta Simpson portrays Martha, mother to Winnie. Coloratura soprano, [Sharleen Joynt](/scene/people/sharleen-joynt/) makes her Opera Philadelphia debut as Winnie, and her best singing is in the high, delicate, and very difficult vocal writing. Simpson's rich and powerful lower register contrasts well with Joynt's sound, which is reflective of their characters' differences. It is the character driven vocal lines of Beecher's writing that brings out the humanity in his music. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569652800/SKYONSWINGS04DM.jpg.jpg)
<figcaption>Sharleen Joynt as Winnie in the world premiere of *Sky on Swings*, Opera Philadelphia's O18 Festival, 2018. Photo: Dominic M. Mercier.</figcaption>
</figure>

The most captivating moments in the opera are those that involve only von Stade and Simpson together onstage. They create a sense of emotional intimacy and truth, by superb acting and unshakable presence.  Their performance is the epitome of genuine artistry and truthful expression. Together they deliver powerful drama and their scenes are a masterclass for all singing actors.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569645136/SKYONSWINGS06SP.jpg.jpg)
<figcaption>Martha (mezzo-soprano Marietta Simpson) and Danny (Frederica von Stade) meet in an Alzheimer's care facility. *Sky on Swings*, Opera Philadelphia's O18 Festival, 2018. Photo: Steven Pisano.</figcaption>
</figure>

Beecher's score begins with a gripping musical atmosphere, and as the opera progresses, his orchestration reflects the characters' inevitable departures from reality. The music transitions back and forth between a complex harmonic vocabulary and a satisfying simplicity. A simple melody involving an oscillation between two half steps works to accompany supernumeraries, who are wandering aimlessly around the stage. Beecher's artistry is heard in his clear and efficient orchestration, played with precision by an ensemble of elevent instrumentalists. Geoffrey McDonald leads the singers and the instrumentalists with authority.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569637260/SKYONSWINGS15SP.jpg.jpg)
<figcaption>Frederica von Stade with supernumerary Renée Rollin in the world premiere of *Sky on Swings*, Opera Philadelphia's O18 Festival, 2018. Photo: Steven Pisano.</figcaption>
</figure>

Like many of Opera Philadelphia's offerings, *Sky on Swings* is an opportunity for its audiences to reflect on the meaning and the place of modern opera in our world. Opera has a long history of provoking social engagement, and its role as a catalyst for social dialogue is part of what makes it so important to our society. *Sky on Swings* does not disappoint in this category. If you are an opera fan, this production is a must-see. While it may not be ideal for first-time opera goers, *Sky on Swings* is a powerful work that is grounded in Alzheimers research, showcases a high-level cast of singers, and explores the complexities of memory-loss in an unconventional and unique production. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537569625018/SKYONSWINGS19DM.jpg.jpg)
<figcaption>Martha (mezzo-soprano Marietta Simpson) and Danny (Frederica von Stade) enter a surrealist landscape together. *Sky on Swings*, Opera Philadelphia's O18 Festival, 2018. Photo: Dominic M. Mercier.</figcaption>
</figure>

>*Sky on Swings* runs through September 29. For details and ticket information, [click here.](https://www.operaphila.org/whats-on/on-stage-2018-2019/sky-on-swings/)
