+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-12-05T15:59:00+00:00"
lastmod = "2016-12-12T09:17:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481282618509/2016-12-9---relax.jpg.jpg"
publishDate = "2016-12-12T09:11:00+00:00"
related_companies = ["scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
short_description = "You&#039;re busier during your final years of school than in the first years of your career; without classes and school-produced concerts to keep you motivated (I&#039;ll admit, I took much of my school&#039;s resources for granted for too long), the early stages of a professional life can feel like you&#039;re twiddling your thumbs."
slug = "skills-to-learn-downtime-on-the-job"
title = "Skills to learn: downtime on the job"
+++

Right up there with engineering students, and likely something leading to medicine, music students are some of the busiest academics in any post-secondary school. Their class load includes private lessons and performance-based classes where the weekly theory assignments and history papers also include learning the Poulenc *Sonata for Clarinet and Piano*, conducting a movement of a Mozart Symphony, and singing a concert with the choir.

It's fantastic, and it's exhilarating. If you're someone who feeds off a busy schedule, a music degree can make you feel like you're buzzing with *ability*, your brain and body becoming engaged so often in this really cool way.

The catch - and it's easy to fall for this one - is that a nonstop schedule of studio classes and final recitals is *not* indicative of a career as a professional classical musician. 

You're busier during your final years of school than in the first years of your career; without classes and school-produced concerts to keep you motivated (I'll admit, I took much of my school's resources for granted for too long), the early stages of a professional life can feel like you're twiddling your thumbs.

Ask any experienced opera singer: downtime is a big part of the job.

Unless a singer is working in their hometown, they've likely arrived in a new(ish) city for a few weeks to sing a run of performances. They have a rehearsal schedule and a performance schedule - which can be subject to change - and outside of those hours, a singer is free to fill their time, however they'd like. Tourism, gym memberships, and cooking are popular picks; yet without fail, a working singer will experience a sense of inertia, boredom, even, as they wait for the next rehearsal, or grow bored with sight-seeing between performances.

It's something that can be learned, if not from schools, from summer programs. Programs like the [Centre for Opera Studies in Italy](https://www.dropbox.com/s/x896vtmodo3clf7/2017%20COSI%20handout_Dec10online%28R%29.pdf?dl=0) (COSI), which presents [fully staged productions](https://www.dropbox.com/s/x896vtmodo3clf7/2017%20COSI%20handout_Dec10online%28R%29.pdf?dl=0), reflect the pacing of a production schedule, including the downtime that comes with it. In a safe environment, young summer program-goers can get a sense of how their energy levels rise and fall at various checkpoints throughout a rehearsal process:

The first sing-through is always fun, and the *Sitzprobe* and first dress rehearsals are certainly favourites for the singers. Yet there's also the monotony of rehearsing chorus choreography, or standing quietly on your mark as the director works with everybody but you. Or toughest of all, staying motivated in the final days of the program, after the high of opening night has worn off and you're starting to look forward to coming home.

If you can learn to stay present and positive in those less-fun parts of the job, that's a huge clue that the career is right for you; if you find it difficult, it's a good thing to learn at a summer program. 

Particularly when they're far from home, like [COSI](http://www.co-si.com/)'s base in Sulmona, Italy, summer programs are a good picture of living a suitcase life. There are more everyday variables - navigating the city, finding groceries, *a shower that's not your own* - and your rehearsal schedule is doled out to you one day at a time. Not many long-term plans are made, and even the most schedule-loving control freak will learn to be flexible and spontaneous.

So, young artists who attend summer programs, take stock of your program schedule. If it keeps changing, if you have large breaks between rehearsals and coachings, pay attention to how you react to that. Are you antsy because no one has scheduled you for anything? Do you feel like time is being wasted? For working freelancers - which is what you'll essentially be - these are familiar sentiments, and the artists who make it know how to fill their own free time. 

Rehearsal lulls, or a sense of hurry-up-an-wait - it's all entirely indicative of a professional's day on the job, and summer programs can offer to a young artist their first picture of what the career really means.

And do make an honest try of the spontaneity/flexibility tack. You'll meet wonderful people, and have experiences that stay with you. Plus, if you spend a [summer in Italy](https://www.dropbox.com/s/x896vtmodo3clf7/2017%20COSI%20handout_Dec10online%28R%29.pdf?dl=0), there will be gelato.
