+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-05T21:16:00+01:00"
lastmod = "2016-04-06T11:55:00+01:00"
preamble = "The [Bel Canto Summer Voice Program](http://belcantosinging.com/) offers an intensive opportunity for emerging singers to hone their skills in beautiful Munich, Germany. Founded by Artistic Director Narelle Martinez, Bel Canto offers a variety of programs in July for young artists, focusing on everything from German language classes to collaborative piano to acting and voice lessons. This summer, Bel Canto introduces its new two-week [Audition Training Program](http://belcantosinging.com/programs/audition-training-program/), running August 26 to September 10, which allows singers to meet and audition for [German agents](http://zav.arbeitsagentur.de/nn_462294/kv/Navigation/Kontakt/Muenchen.html__nnn=true), familiarize themselves with the German Fach system, and learn to put together a stellar résumé.\n\nWe spoke with Martinez about the program, along with mezzo-soprano and [Bayerische Staatsoper](/scene/companies/bayerische-staatsoper/) Ensemble member Angela Brower, who gave a masterclass to the 2015 participants, and stage director Barbara Schöne, who will conduct training sessions in auditioning and scene study in 2016."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459939628297/2016-04-07---Munich.jpg.jpg"
publishDate = "2016-04-06T11:55:00+01:00"
related_articles = ["articles/how-to-make-the-most-of-your-summer-program.md"]
related_companies = ["scene/companies/bayerische-staatsoper.md"]
short_description = "&quot;Unfortunately, colleges and universities offer far too little in order to prepare young people to the reality of the day to day work in this profession. Following the completion of their vocal studies, young singers attend their first auditions and are completely stunned when they realise how high the competition is as that there are many others good singers on the market. Young professionals must be prepared and ready to compete for the same roles against very experienced singers of all ages.&quot;"
slug = "singing-in-germany-bel-canto-summer-voice-program"
title = "Singing in Germany: Bel Canto Summer Voice Program"

+++
## What does Bel Canto offer to young artists that is unique among summer programs?

**Narelle Martinez**: Bel Canto Audition Training participants have the chance to be heard by German agents (private and from the [ZAV](http://zav.arbeitsagentur.de/nn_462294/kv/Navigation/Oper-Operette.html__nnn=true), the German Government Artistic Agency) at the end of the program, after having a rigorous training on their German audition package. Our program, designed for advanced as well as undergrad singers, is held in Munich, Germany, a beautiful city with a rich opera tradition which started in the 17th century.

Another point which makes our program so interesting is that all our participants have the chance to hear the best singers in the world by attending several performances at the renowned Munich Opera Festival, which is held every July. In addition, special guests from the Bayerische Staastoper also come to our program to share their experience with our participants.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459939742590/Salzburg.jpg.jpg)
<figcaption>The Bel Canto team on a trip to Salzburg.</figcaption>
</figure>

**Angela Brower**: It is absolutely crucial to provide opportunities for emerging singers to not only learn the repertoire they need as they begin their career, but also the opportunity to perform such repertoire. The participants of the Bel Canto program will be given these crucial steps, as well as the added benefit of working with a respected stage director who will give them the tools they need in order to make the best impression for their future employment. What also makes this program unique is the masterclasses they will receive from young professionals who have already established themselves on some of the world's most respected opera stages.

In addition, those ready to participate and move forward in their career will also be offered the distinct chance to audition for a well-respected German agency, allowing them the opportunity to start their career.

**Barbara Schöne**: The Bel Canto Summer Voice Program represents the perfect opportunity (in every way) for young artists to prepare their entry unto the theatre world. In addition to refining the technique of the singers, special focus is given to stage craft as well as audition preparation with emphasis on roles, scenes, and audition arias. The participants will be taught how to delve deeper into the psychological aspect of the character. (by better understanding the context in which it is set into the work).

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1546052834/media/2018/12/20160406NarellePianists.jpg)

<figcaption>Narelle Martinez and two collaborative pianists from the Bel Canto program.</figcaption>
</figure>

## What do you feel are important priorities for training emerging singers?

**NM**: Young emerging singers who aspire to a career in Europe must learn how to audition for German speaking houses and agents. We provide them with advice and guidance on their audition package to adapt it to the German market and give them the right tools to better prepare them for their audition tours. We offer several workshops on German Resume Writing and The Fach System. Choosing the right arias for your voice type is indeed crucial to enhance your chances to get a job in Germany.

**BS**: I think young singers today must be all-rounded, i.e. have a solid technique, be versatile, have a distinctive sound as well as great acting skills. It is no longer enough to only have a beautiful voice. The voice, and also the performance must touch and stand out among hundreds of other singers. Considering the difficult freelance market and demanding schedule of nowadays' theatres, the voice must be technically solid to survive the long hours of singing, while remaining vocally healthy. Psychologically, you must develop a thick skin to become immune to the frequent rejections and failures that is part of an artistic life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459888694581/2016-04-06---Angela-Brower.jpg.jpg)<figcaption>Angela Brower, American mezzo-soprano.</figcaption>
</figure>

## Why do you think young artists seek out training programs like Bel Canto as a supplement to their regular voice lessons and coachings?

**NM**: As today's opera world is very demanding and competitive, young artists realise that they need more tools to be able to start a career. Bel Canto offers acting lessons and stage craft, scene study, German language and dialogue training, which are all aimed on giving our participants the appropriate training to succeed in the German opera world.

**BS**: Unfortunately, colleges and universities offer far too little in order to prepare young people to the reality of the day to day work in this profession. Following the completion of their vocal studies, young singers attend their first auditions and are completely stunned when they realise how high the competition is as that there are many others good singers on the market. Young professionals must be prepared and ready to compete for the same roles against very experienced singers of all ages. The importance of developing your acting skills and stage experience cannot be emphasized enough, as this will give you the confidence to shine during an audition.

For this reason, many students decide to attend summer programs such as Bel Canto to acquire the right tools to present themselves as perfectly as possible for the German market.

## Can you tell us about the workshop in April, and the gala in June?

**NM**: We are thrilled to announce that three of our participants have been invited to attend a workshop given by the [ZAV](http://zav.arbeitsagentur.de/nn_462294/kv/Navigation/Kontakt/Muenchen.html__nnn=true) in April (starting today!) and perform at a gala concert where several German theatre managers and agents will be recruiting their new artists.

> The application deadline for Bel Canto is May 1st. [Click here](http://belcantosinging.com/programs/audition-training-program/) to find out more!