+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-11-23T10:36:00-05:00"
lastmod = "2015-11-23T12:10:00-05:00"
preamble = "For English speaking singers, singing in their native language is harder than you'd think. It's difficult to think of your own language objectively, and English is often a complicated mess of vague vowels. In today's opera and classical music scenes, it's more important than ever for young singers to sing well in English, and to be understood by their audiences. Crisp consonants can go a long way, but here are three valuable tips to keep your listeners' attention, and eventually make same-language surtitles a thing of the past."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448295056098/2015-11-22---English.jpg.jpg"
publishDate = "2015-11-23T12:08:00-05:00"
related_articles = ["articles/quick-tips-the-rolled-r-test.md", "articles/5-ways-to-build-your-rhythmic-chops.md", "articles/singable-text-when-composers-make-it-tricky.md", "articles/4-myths-from-music-school.md", "articles/how-much-to-tell-your-students-about-the-voice.md", "articles/4-ways-to-test-your-memory.md", "articles/dear-me-advice-to-my-freshman-self.md", "articles/3-ways-your-english-is-showing.md", "articles/rhythm-the-good-the-bad-and-the-stressful.md", "articles/4-english-language-habits-that-make-a-singers-life-harder.md", "articles/4-foreign-language-challenges-for-singers.md"]
short_description = "It&#039;s hard to think of your own language objectively, and English is often a complicated mess of vague vowels. In today&#039;s opera and classical music scenes, it&#039;s more important than ever for young singers to sing well in English, and to be understood by their audiences. Crisp consonants can go a long way, but here are three valuable tips to keep your listeners&#039; attention, and eventually make same-language surtitles a thing of the past."
slug = "singing-in-english-3-reasons-why-no-one-can-understand-you"
title = "Singing in English: 3 reasons why no one can understand you"

+++
## 1. Your schwas sound like something else

One of the biggest habits of native English speakers is avoiding unstressed schwas. Words like "salvation" or "emotion" or "passion" should end with a gentle \[ə\]; instead, it can be a habit to sing more of an \[a\] (like in "**fa**ther). Take that line from John Adams' _Nixon in China_, "We no longer need Confucius"; if you were to speak the word as \[konfjuʃas\] ("Con-fyoo-shahs"), no amount of consonant-spitting will help listeners understand the name better. Instead, \[kən'fjuʃəs\] is how we actually say the word, and it takes less effort than a loud letter F.

The same goes for words like "creator" or "beloved"; instead of ending in \[tɔr\] and \[vɛd\], be precise about singing more neutral schwa.

>While you're holding a vowel for beats and beats, listeners can actually forget how the word began.

## 2. You forgot about the diphthong

English has _tons_ of vowels in it. More so than in Italian or French, diphthongs are a huge part of making an English word intelligible. Harmless-seeming words like "go" or "day", if sung \[gɔ\] or \[de\], would go unheard by English-speaking audiences. A deliberate \[u\] at the end of "go" makes the word complete, just like the \[ɪ\] at the end of "day".

Words like "heart" or "alarm" are tricky, too; to only sing \[hɑ:t\] ("haht") or \[ə'lɑ:m\] ("alahm") isn't quite enough to get the word, but too much hard R can sound ugly. Often you can split the difference using a focused schwa in place of the R, as in \[ø\] or \[œ\]. (It'll sound weird to you, but not to your listeners.) The catch is, it's another diphthong to remember.

>English has a rhythm to it, like all languages do.

All of this becomes even more important with sung text, since the words are stretched to exaggerated lengths. While you're holding a vowel for beats and beats, listeners can actually forget how the word began; without a final diphthong to remind them, they won't understand you, and they'll begin to lose interest in what you're singing.

## 3. The word "the" is too long

English has a rhythm to it, like all languages do. These rhythms come from varied combinations of syllables that are long and short, stressed and unstressed; when it comes to understand English clearly, this rhythm is arguably as important as the proper pronunciation of words.

The word "the" (\[ðə\]) is a definite article, so it's everywhere in English. It's often the default for a singer to unknowingly sing a nice, long schwa on the word "the"; if you take any sentence with "the" in it and say it out loud for yourself, you'll hear how weird that sounds.

When you're singing, make it a point to find all the instances of the word "the", and look at the word that follows it. If it starts with a consonant, you can probably get away with doubling it. "The sun" can almost look like \[ðə 'ssʌn\] when you're singing the text. "The fire" can be \[ðə 'ffaɪər\], "the glory" sounds \[ðə 'gglɔri\].

If you're diligent with making this difference, it can help in a big way with text clarity. The rhythms of English will be more natural, and your listeners won't have to work as hard to understand you.

> Have tips of your own? Share them in the comment section below!