+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-05-25T05:23:00-04:00"
lastmod = "2017-09-28T11:28:00-04:00"
preamble = "There's no faking what opera singers do onstage. It's the result of legitimate hard work, and the staggering skills they show come precisely from not taking shortcuts or band-aid approaches to fixing problems. Real as it is, these artists have their bags of tricks. Singers, please forgive us for outing some of your little secrets..."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506612476636/2017-09-28---Illusion.jpg.jpg"
publishDate = "2016-05-25T06:53:00-04:00"
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md","articles/5-ways-to-build-your-rhythmic-chops.md"]
short_description = "There&#039;s no faking what opera singers do onstage. It&#039;s the result of legitimate hard work, and the staggering skills they show come precisely from not taking shortcuts or band-aid approaches to fixing problems. Real as it is, these artists have their bags of tricks. Singers, please forgive us for outing some of your little secrets..."
slug = "singers-masters-of-illusions"
title = "Singers: masters of illusions"
+++

## Vowels are not what they seem

Vowel modification is one of the first tricks of the trade that singers learn. It's more common in opera and classical music than in other styles of singing, because there's a greater need for efficiency and balance. Singers work for a basic concept of achieving the maximum resonance and minimum effort on any combination of vowel and pitch, and sometimes the way we speak certain vowels doesn't serve when it comes to sustaining a sound. It's related to the fact that we don't always know a pop singer is British or North American until we hear them speak.

An [i] ("ee") vowel on a high note is a great example. When we speak, we make an [i] sound by raising the back of the tongue and spreading the lips laterally. You can feel it for yourself by saying the word "sweet" very slowly. Opera singers need a relaxed tongue and lots of resonant space in the mouth (and other spaces in the head), especially when they approach the top of their range. So, they compromise with vowel modification. (Note: some singers do away with "modification" altogether, and outright change the undesirable vowel with their favourite one instead. Our thoughts on this are mixed, depending on how beautiful the resulting sound is.)

Tenors, for example, often experiment with replacing [i] sounds with [e]-ish vowels instead (anywhere from "eh" as in "bed" to "ay" as in "day"), or even singing an [y] sound (an umlauted [u], as in "über"). In the case of the latter, it's a neat option, since the [y] sound has both [u] and [i] in it; the singer is basically reaping the rewards of one side or another, depending on which serves better for sound and comfort.

In English, words like "father" or "earth" have vowel-like problems with the "r" sounds; these sounds don't sustain well, and they can mess up the singer's balance of resonance and relaxation. If you listen closely to great singers in English, they replace the "r" sounds with a schwa of sorts, anywhere from [ø] to [œ]; to North Americans, it can sound like very posh British English (roughly, "fathuh" or "uhth").

Of course, the singers who do this best just sound like they're singing clear text, like Jerry Hadley does with Tom Rakewell's aria in Stravinsky's *The Rake's Progress*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/DdJw86l22JA?start=408" frameborder="0" allowfullscreen></iframe>
</figure>

## Staccato notes that aren't

Singers, like string players, wisely adhere to the more literal definition of "staccato", which is "detached". Often when we see a staccato marking in a score, there's an implication that the notes should sound not only separated, but very short, like little sound pellets. Assuming that the singer is aiming for beauty on top of honouring staccato markings, what they'll actually produce isn't quite what we imagine. 

A pianist has the option to touch and release a key in an instant, and since everything about the piano's sound comes down the initial attack of the note, there's little worry about how the sound will "ring" once the key has been depressed. Singers, on the other hand, have to worry about their sound the whole time it's happening. A piano-like staccato, when sung, sounds more like a yipping dog than a human being. Down low, they can sound like burps. *Unless*, the singer pushes the limits of staccato. If they aim for a sound that lasts one or two vibrations, rather than timing it to the millisecond, the sound will be, well, more beautiful. Of course, beauty may not always be a priority, and that's a singer's decision to make. 

Still, the secret is out: a singer's staccato is technically true, just not necessarily "short". Have a listen to the way Erin Morley tears up the "Doll Song" from *Les contes d'Hoffmann*:

<figure data-type="video"><iframe width="854" height="480" src="https://www.youtube.com/embed/VXKsOeccz8w" frameborder="0" allowfullscreen></iframe>
</figure>

## What vocal registers?

It may be a weird analogy, but opera singers are to vocal registers as everyday people are to their underwear: we've all got them, but we rarely want explicit confirmation.

What we mean is, a huge amount of a singer's training is about smoothing over the natural "breaks" between the registers in the voice. Basically, there's your chest voice, and your head voice, plus a few extra extremes on either end. Mezzo-sopranos, for example, spend eons buffing out the cracks and lines between their chest and head voices, so they can sing from the bottom to the top of their range in a seamless line of gorgeous. Though most male voice types don't officially include the pure head voice, there are still breaks, like gears in an engine, along their vocal range.

So, when we listen to a great two-octave scale, or a glorious leap from low to high and back down, what we're really hearing is a long, complicated vocal illusion. Singers find magical ways of "mixing" their registers, blurring the register lines so they're inaudible to our ears. They employ the aforementioned vowel modification to help, but really, it just comes from years of careful practice.

Here's Elīna Garança, singing an aria from *La Cenerentola*, to show you the illusion in action:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/sllhVK2_Gug" frameborder="0" allowfullscreen></iframe>
</figure>

>Singers, what are your favourite secrets of vocal technique? Let us know in the comments below!
