+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-04-21T17:50:00-04:00"
lastmod = "2015-05-13T09:00:00-04:00"
preamble = "This is the second instalment in our series designed to help singers and other artists use the Internet to their advantage. [Check out part 1 right here](/singers-heres-how-to-use-social-media/), on getting social-media-savvy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1431486985946/coffee-iphone-macbook-air-166_Fotor.jpg.jpg"
publishDate = "2015-05-13T08:00:00-04:00"
related_articles = ["articles/singers-heres-how-to-use-social-media.md","articles/musician-marketing-masterclass.md","articles/stephen-bell-singer-by-night-coffeeshop-creative-by-day.md"]
related_people = ["scene/people/erin-wall.md"]
short_description = "Singers, I know you&#039;ve heard this before, but seriously, you all need to get websites. Some of you don&#039;t have websites, or Twitter accounts, or Facebook pages. I&#039;d name names, but you&#039;re not on the Internet."
slug = "singers-heres-what-you-need-to-know-about-your-website"
title = "Singers: here&#039;s what you need to know about your website"
+++

Singers, I know you've heard this before, but seriously, you all need to get websites. Some of you don't have websites, *or* Twitter accounts, *or* Facebook pages. I'd name names, but you're not on the Internet.

Why is it so important? Basically, so that you're not a name without context. Any time I write a review, I try to add an external link for every name I mention. Now, the point of a singer's website isn't necessarily to rack up high volumes of traffic, but it's nice for readers who see your name in a review or promotional piece, to be able to find out more. They want to see what you look like when you're not in costume, and they want to see what else you're about.

If a singer has a manager, he or she probably has an artist page on their management's website. This usually has all the important information, but it doesn't really say anything about who you are. That might sound like icing rather than a necessity, but you guys are performers, and you're not just presenting the sound of your voice. Your *own* online presence will be what satisfies a curious Googler.

So, what does your website need?

### Simplicity

This is one of the most important parts. Things like a "welcome" screen*****, random animations, or even a too-busy homepage can obscure the information that you want out there. Your home page really only needs a photo, and any social media or external links. Visually, less is more. [Erin Wall](http://www.erinwall.com/) is a Canadian soprano, and I absolutely *love* [her website](http://www.erinwall.com/). It's stunning to look at, and easy to navigate.

Less is more when it comes to the entry point of your website. Live Twitter feeds, videos here, your blog, an Instagram feed - they're all good ideas, just not all on the same screen. Clutter doesn't get people to explore your site, but simplicity will pique their interest.

*****One exception to the No-Welcome-Screen rule is if your website is bilingual. Multi-lingual websites can still be easy to peruse; [Anna Netrebko's site](http://www.annanetrebko.com/) is in three languages, with no extra steps.

### Headshot

Photos are important for public and media-related visitors to your site. Lots of singers have photo galleries available, but I often find that I can't do anything with the photos except admire them. This is totally fine, but you should have a couple of preferred shots available to download, at a minimum size of 1024x728. Size does matter in this case; it's the difference between a beautifully crisp shot of you, and a pixellated mess. Also, be sure to clearly credit your photographer.

### Biography

Also vital is an updated biography. Résumés are good for auditions and applications, but for media, the bio is where it's at. You should have a long and short bio available for download, right next to your headshots. Personally, when I use a biography, I don't want to misrepresent the singer, so I put my trust in what he or she has available online. When I search for a singer's bio, and that singer doesn't have a website or management page, often I get results from promotional pages from their past gigs. These bios may have been altered to fit a specific company, and I'm hesitant to use them (they also may be private property). It should be very easy to find your biography from a "primary source," like your website or management page.

Keep in mind that most media workers will use your biography as is, so make sure you're satisfied with what's there. Depending on how frequently you're working, be sure to keep your bio updated; at the very least, make sure you don't have past gigs listed as "upcoming events."

### Audio & Video

For me, I don't find these as necessary as a headshot or bio, but they're a good idea if you're a singer. Your recordings can be simple links to your Soundcloud account or YouTube channel, or you can embed the media right into your website (keeping in mind the value of simplicity).

One thing I really don't recommend is having audio or video that plays automatically when someone visits your site. It's more annoying than inviting, so leave the listening opportunities to the discretion of your audience.

### Social Media Links

Twitter and Facebook allow for people to keep track of you in real-time. Links to your Facebook, Twitter, YouTube, etc., should be clearly visible on the homepage of your website, and the links should open these pages in a new tab (so your viewers don't have to leave your website to see your Instagram account). I write more about using social media to your advantage in [part 1](/singers-heres-how-to-use-social-media/).

>Keep your eyes out for a follow-up post on this topic, with detailed advice from a web developer's point of view. If you're leaving your website to a pro, you'll know just what to ask for. In the meantime, leave any questions you have in the comment section.
