+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2016-02-25T09:32:00-05:00"
lastmod = "2016-02-26T09:28:00-05:00"
preamble = "One of the biggest signs of that a composer has written well for the voice is when he or she sets the text in an organic way. In a broad sense, this means finding a rhythm and melody that works with the text, allowing it to be expressed the way the composer wants. In the same way that Verdi seemed to naturally fuse his music with the librettos he set, there are just as many examples of text setting that seems unnatural. The curious singer will look at the weird combination of music and words, and try to solve the mystery of what the composer was after. Those mysteries get especially interesting when we're dealing with great composers. What do we mean? Here are a few examples:\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456450037198/2016-02-26---Typography.jpg.jpg"
primary_image_credit = "Photo: ncsamyscott.wordpress.com."
publishDate = "2016-02-26T09:28:00-05:00"
related_articles = ["articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/4-steps-to-taking-fixing-notes.md"]
short_description = "One of the biggest signs of that a composer has written well for the voice is when he or she sets the text in an organic way. In a broad sense, this means finding a rhythm and melody that works with the text, allowing it to be expressed the way the composer wants. In the same way that Verdi seemed to naturally fuse his music with the librettos he set, there are just as many examples of text setting that seems unnatural."
slug = "singable-text-when-composers-make-it-tricky"
title = "Singable text: when composers make it tricky"
+++

## *Carmen*

It's a little funny, how many times Bizet paints himself into a text-setting corner in this opera, and it's all the fault of those Spanish dances. Two of Carmen's most famous arias are purposefully set to the rhythms of the "Habanera" and the "Seguidilla"; except they're sung in French. It doesn't sound like a big deal, but just like any "poetic" translation of a Mozart opera found in one of those Schirmer scores (kind of like the *Carmen* example below), it's almost impossible to put one language into the rhythm of another without some awkwardness. Example:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456411731190/Bad-Text-Setting---Habanera.jpg.jpg)
</figure>

If one were to ignore the musical setting, and simply speak this sentence in French, it would go a bit like, "L'a**mour** est un ois**eau** re**belle** que **nul** ne peut apprivoi**ser**." Yet, look at all the weak syllables on strong beats; the first two words always make me wince a little bit, despite their cornerstone position in the operatic repertoire. To speak it the way Bizet sets it, "**L'a**mour **est**..." is clunky, and definitely not French (perhaps it's Carmen's Spanish accent emerging?).

The same goes for the text setting in Carmen's second aria, the "Seguidille":

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456411744616/Bad-Text-Setting---Seguidilla.jpg.jpg)
</figure>

Disastrous. This sentence, spoken, would look a bit like, "**Oui**, mais **toute seule** on s'en**nuie**, et le **vrais** plai**sirs** sont à **deux**." The Seguidilla rhythm, plus those pesky mute schwa endings in French ("toute" is two syllables, for example), make it hard to avoid the weird limpings of weak syllables on strong beats. 

These awkward moments are not a result of Bizet's poor skills in setting French to music. Rather, it's a great example of what a singer needs to do with any text set to music; there will be awkward moments, even in music by the greatest composers, and the singer needs to find the larger rhythm of the sentence, in order to put it in context with the rhythm of the music. It's about being careful not to land too heavily on strong beats when the text doesn't warrant it, and it's more about truly speaking the language in a sustained way.

## *Don Giovanni*

Mozart may have spoken German first, but no one is questioning his understanding of the rhythm of Italian. Yet, there are a few little oddities in this famous serenade from *Don Giovanni* that would probably sound a little more organic if the aria weren't, again, written in a dance rhythm. For the record, I'm *all about* this aria; I think the serenade rhythms and instrumentation are why this simple piece is so effective, both as part of the show, and as something that stands alone. Check out the first phrase:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456411769083/Bad-Text-Setting---Deh-Vieni-1.jpg.jpg)
</figure>

Spoken, it would sound like, "Deh **vie**ni alla fin**e**stra, o mio te**so**ro." It's pretty close to what Mozart wrote, except for the word, "alla". All it means is "to the", so it's odd that it's both on the highest note of the phrase, and on one of the strong beats. Even the way the word "mio" (meaning "my") is stretched almost across the whole bar, isn't really how an Italian would say it; they'd go through the "mio", right to "tesoro".

Something similar happens in the second phrase:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456411779174/Bad-Text-Setting---Deh-Vieni-2.jpg.jpg)
</figure>

The setting of "il pianto mio" isn't problematic, per se, but it's unnatural compared to the rhythm of speech: "il **pia**nto **mi**o". So, to give a long note for "il" ("the") and to have the word "pianto" rise up to that high note on the weak syllable, is to give another hard task to any Giovanni that sings this aria. Like in the *Carmen* example, the singer has to keep the phrase alive and sustained, across several strong beats, in order to prioritize the language over the serenade. Even better, since this is Don Giovanni we're talking about, the singer gets to use the stretchiness of harmless words like "mio" to make his serenade really pack a punch.

## *The Rake's Progress*

For many of our readers, English is a comfortable language, and examples from opera in English can illuminate the sometimes odd-seeming choices by composers who set text.

In one corner is Stravinsky's *The Rake's Progress*, a complicated score with tight, instrumental rhythms that seem, in the early stages of learning, to be inorganic to the language. You can find an example in the first sung notes of the opera:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456441710857/Bad-Text-Setting---Rake-2.jpg.jpg)
</figure>

It goes, "the **woods** are **green**", right? So why did Stravinsky put "the" and "are" on the downbeats? It's not because he doesn't understand the inflection of English; you can find examples of ingenious text setting throughout his opera. In this instance, I think it's about seeing the rhythmic forest for the trees. Sure, "the" is on beat 1, but the orchestra comes in with the more important word, "woods". It's a case where downbeat ≠ heavy.

Another example is from Tom Rakewell's cocky little aria at the top of the show:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456441811621/Bad-Text-Setting---Rakewell-1.jpg.jpg)
</figure>

If we said, "Till **I** die **then** of **fever** or **by** light**ning** am **struck**," we'd have a pretty memorable accent in our speech. Yet Stravinsky wrote this down. I think it's evidence of the composer's faith in his singers; smart singers learn their notes and rhythm, and they also learn *why* the notes and rhythms exist. Dramatically, Tom Rakewell is a fickle person, so perhaps the unnatural lilt is Stravinsky's commentary on that.

## Benjamin Britten

There's also the genius of English opera, Benjamin Britten; it's crystal clear, in studying Britten's scores, that he's a master of setting the text. He gives his characters in his operas unique personalities, using their varying ways of "speaking". A great example is from *A Midsummer Night's Dream*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456442081023/Bad-Text-Setting---Tytania.jpg.jpg)
</figure>

Tytania is the Queen of the Fairies in Shakespeare's magical world; she has a lovely vocabulary, yet she's not exactly human. So, the way she says "cour**teous**", with all the excitement on the wrong syllable, isn't because Britten is careless; it's because she's a supernatural being. When you think about it, why *should* fairies speak the same as humans?

Finally, there's this small, yet significant example from Ellen Orford's "Embroidery Aria" in Britten's *Peter Grimes*:

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456448708568/Bad-Text-Setting---Embroidery.jpg.jpg)
</figure>

English speakers would say this line, "Now my **broi**dery...", yet there's so much that happens on the word "now": a portamento upwards, a diminuendo, and a dovetail effect into an entirely different musical colour. In this aria, Ellen is fearful; she's confirming ideas about Peter that she's had for a while, and the fact that she's found evidence to confirm her suspicions is not a forensic triumph. She's terrified and sad for her friend, and for the dead boy. All the detail that Britten writes, simply for the word "now", is Ellen's horrified recoil from the sweater she finds.

>What are your favourite moments of odd text setting? What do they tell you about your music? Let us know in the comments below!
