+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2018-05-04T18:40:00-04:00"
lastmod = "2018-05-04T20:50:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525476137150/06_Kirby-MacIntosh.jpg.jpg"
primary_image_credit = "Johnathon Kirby and Anne-Marie MacIntosh in Così fan tutte, Calgary Opera's Emerging Artists, 2018. Photo: Jan van der Hooft."
publishDate = "2018-05-04T20:50:00-04:00"
related_companies = ["scene/companies/calgary-opera-emerging-artist-development-program.md"]
related_people = ["scene/people/morgan-traynor.md","scene/people/jillian-bonner.md","scene/people/annemarie-macintosh.md","scene/people/johnathon-kirby.md","scene/people/geoffrey-schellenberg.md","scene/people/daevyd-pepper.md"]
short_description = "Of course, the success of Così fan tutte rests with the six singers and the magic they create both individually and in various combinations of duets, trios and more. For this production, two of the characters - Ferrando and Despina - are double cast, while the other four characters remain constant for the run."
slug = "simpler-cos-offers-sizzle-substance-for-emerging-artists"
title = "Simpler Così offers sizzle &amp; substance for Emerging Artists"
+++

Ever go to a performance where it's all sizzle and no substance? Where the production put so much effort into special effects that it overshadows what was most important?

Not a problem when you see Calgary Opera's production of Mozart's *Così fan tutte*. Indeed, less is definitely more, especially with a talented sextet of Emerging Artists.

*Così fan tutte* offers so much more than a hilarious plot between two sets of lovers. The opera contains some of Mozart's best orchestral and vocal writing. From the long sustained passages to the challenging melismas and Mozartean leaps, *Così* is a feast for the ears. And with a spartan set and limited costuming, the onus is on musicians to deliver a memorable performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525473544265/01_Pepper-Bonner-Traynor-Schellenberg.jpg.jpg)
<figcaption>Daevyd Pepper, Jillian Bonner, Morgan Traynor, and Goeffrey Schellenberg in *Così fan tutte*, Calgary Opera Emerging Artists Program, 2018. Photo: Jan van der Hooft.</figcaption>
</figure>

Of note, the production plays to the smaller space of the Mamdani Opera Centre, a converted church in downtown Calgary. The chamber orchestra, led by Calgary Opera's Resident Conductor Kimberley-Ann Bartczak, consisted of ten players (with Bartczak doubling her conducting duties with keyboard/harpsichord duties for the plethora of recitative), which gave the production a more intimate sound than that of a larger auditorium. The chamber orchestra played from under a balcony that was off to one side of the stage. At times, the distance between orchestra and singer resulted in a temporary lack of synchronicity, especially among the men, but the singers adjusted accordingly as the opera continued.

The blocking, provided by Acting and Creative Consultant Robert Herriot, also provided a surround-sound experience for the audience. In addition to entrances and exits off each wing of the stage, the singers also used an aisle through the audience, oftentimes beginning their singing from within the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525473552064/02_Schellenberg-Traynor-Pepper.jpg.jpg)
<figcaption>Geoffrey Schellenberg, Morgan Traynor, and Daevyd Pepper in *Così fan tutte*, Calgary Opera Emerging Artists Program, 2018. Photo: Jan van der Hooft.</figcaption>
</figure>

Of course, the success of *Così fan tutte* rests with the six singers and the magic they create both individually and in various combinations of duets, trios and more. For this production, two of the characters - Ferrando and Despina - are double cast, while the other four characters remain constant for the run.

The pair of soldiers, Guglielmo and Ferrando, are played by baritone [Geoffrey Schellenberg](/scene/people/geoffrey-schellenberg/) and, on this night, tenor [Daevyd Pepper](/scene/people/daevyd-pepper/) (Jan van der Hooft plays Ferrando on May 4). Schellenberg has a natural expressiveness with his soothing baritone and particularly with his facial expressions, especially his eyes. The comic moments he shares with Ferrando, especially in the aria "Non siate ritrosi" when the two disguised soldiers try to win over each other's girlfriends, showcase Schellenberg's natural ability to connect with the audience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525473560516/03_Schellenberg-Traynor-Pepper.jpg.jpg)
<figcaption>Geoffrey Schellenberg, Morgan Traynor, and Daevyd Pepper in *Così fan tutte*, Calgary Opera Emerging Artists Program, 2018. Photo: Jan van der Hooft.</figcaption>
</figure>

Tenor Daevyd Pepper has a pleasant, clear sound that fits well for the role of Ferrando. On this night, however, he lacked a bit of vibrancy that affected his intonation, which is quite uncharacteristic of his other performances. His "Un'aura amorosa", in which Ferrando tells a famished Guglielmo that love will sate one's hunger, was nicely sung but it felt somewhat restrained and cautious. Hopefully the more intimate venue and acoustic for this production doesn't adversely affect Pepper's ability to share the full range of his voice when he reprises the role on May 5.

With so much duet work for the sisters Fiordiligi and Dorabella, much care is taken to cast the right voices. Soprano [Morgan Traynor](/scene/people/morgan-traynor/) and mezzo-soprano [Jillian Bonner](/scene/people/jillian-bonner/) are equally brilliant in their respective roles, with beautifully matching and complementary vocal tones. Traynor impresses with a world-class ability at coloratura, to quickly change dynamics on high, long-held notes, and a confident, expressive manner to reach out to the audience. On this note, her performance of the difficult aria "Come scoglio" was exceptional, handling the difficult leaps with ease and consistent tone. Bonner is blessed with a tremendous depth and warmth to her voice. She handled her role's challenging tessitura with aplomb, showing off an enviable richness in her upper register.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525473582183/04_Pepper-Schellenberg-Kirby.jpg.jpg)
<figcaption>Daevyd Pepper, Geoffrey Schellenberg, and Johnathon Kirby in *Così fan tutte*, Calgary Opera Emerging Artists Program, 2018. Photo: Jan van der Hooft.</figcaption>
</figure>

Soprano [Anne-Marie MacIntosh](/scene/people/anne-marie-macintosh/) shows off impressive comedic acting chops as the maid Despina. Often in Mozart operas, it is the servants who drive the action, and the worldly Despina is no exception. MacIntosh sparkles with a free, supple tone that only experience provides; her "In uomini, in soldati", in which Despina tells her mistresses that one cannot expect men, especially soldiers, to be faithful, was a highlight on this night. Her cameo appearances as a doctor and a notary show off a natural ease in comedic roles that definitely endears her to the audience. For the May 4 performance, Despina will be played by soprano Nofar Yacobi.

The standout performance on this night was by bass-baritone [Johnathon Kirby](/scene/people/johnathon-kirby/) as the scheming Don Alfonso. Kirby appeared well at ease and sang in fine vocal form; his silky, robust tone filled the hall with delicious warmth and presence. His ability at recitative, in particular, was well polished: clear and conversational, never hurried or abrupt unless it was for dramatic purposes. In addition, his chemistry with MacIntosh as Despina translated into a hilarious tandem for the scheming duo, which was at the heart of this first-rate production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525473591782/05_MacIntosh-Pepper-Traynor-Bonner-Schellenberg-Kirby.jpg.jpg)
<figcaption>Anne-Marie MacIntosh, Daevyd Pepper, Morgan Traynor, Jillian Bonner, Goeffrey Schellenberg, and Johnathon Kirby in *Così fan tutte*, Calgary Opera Emerging Artists Program, 2018. Photo: Jan van der Hooft.</figcaption>
</figure>

This intimate staging of *Così fan tutte* is definitely a winner. While the absence of a sprawling set and lavish costumes mutes the amount of sizzle, the singers needed real substance to sell the product, and sell it they did.
