+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-09-15T12:59:00-04:00"
lastmod = "2017-09-25T23:09:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505494538889/2017-09-15---Square---osborne4.jpg.jpg"
primary_image_credit = "Photo: Bo Huang."
publishDate = "2017-09-25T22:57:00-04:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/talking-with-singers-jamie-barton.md","articles/talking-with-singers-brenda-rae.md","articles/james-robinson-elixir.md","articles/he-saidshe-said-a-sweet-elixir-at-the-coc.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/simone-osborne.md","scene/people/gordon-bintner.md","scene/people/andrew-haji.md"]
short_description = "&quot;For the first couple of seasons that I came back I still very much felt like I had to prove myself,&quot; says Osborne of returning to what she considers her home company. She admits to feeling pressure to bring consistently great performances to the COC, where the standard of artistry is high and the audiences are in-the-know. &quot;It&#039;s probably the pressure I put on myself.&quot;"
slug = "simone-osborne"
title = "Talking with singers: Simone Osborne"
+++

"I had a conversation with Jim Robinson, our director," says soprano [Simone Osborne](/scene/people/simone-osborne/) about her early days in rehearsal for [*The Elixir of Love* at the Canadian Opera Company](http://coc.ca/PerformancesAndTickets/1718Season/ElixirofLove.aspx). "I said to him, 'full disclosure, I really don't love it when Adina is played as a mean girl.'"

The beautiful, savvy young woman in Donizetti's *bel canto* comedy, *The Elixir of Love*, is a role debut for Osborne. On top of the vocal demands written for Adina, there's also a dramaturgical challenge of creating a sympathetic character out of a woman who spends much of the opera holding her devoted admirer, Nemorino, at arm's length.

"I think she does have an edge, but I think she has a really good heart," says Osborne, who chalks up to distrust, even boredom, some of Adina's ridicule of love and her suitors. "She is extremely well-read, she's up on current events, she knows what's going on."

In Robinson's production, which sets the action in pre-WWI small-town Ontario, there's an understanding that Adina and Nemorino have known each other all their lives; at the start of the opera, Adina's attitude towards Nemorino is closer to that of an older sister than potential love-interest. And according to Osborne, it's for good reason.

"I think the reason that she's standoffish with Nemorino is actually because she doesn't want to lead him on," she explains. Even in the early-20th-century setting of this production, a woman who entertains a man's advances doesn't just open herself up to love; it inevitably means marriage, kids, and a certain loss of independence. "She's not into [Nemorino], and she's not into anyone. If she's flirtatious in any way, he's going to get the wrong idea."

It's a fine dramatic balance to strike, particularly with the characters' polar differences as laid out in the libretto by Felice Romani; Adina is smart almost to a fault, and Nemorino is almost pitiably lovesick. On top of that, her onstage opposite is as endearing as Nemorino himself. "[Andrew Haji](/talking-with-singers-andrew-haji/) is the sweetest, most generous person in real life and onstage," Osborne smiles. "Everyone would hate Adina if she was a witch to him, ever."

Exaggerated though it may be, Adina's story in *Elixir of Love* is a familiar one, about a woman who "realizes her feelings for him, but she still can't say it first."

"I have to say, I identify with that," Osborne admits. "Until I met my now husband, I didn't really let anybody in, or date anyone for a long time. It was really scary to me, the possibility of getting hurt and not being in control."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505494736366/2017-09-15---Osborne-Ballo-13-14-04-MC-D-0034.jpg.jpg)
<figcaption>Simone Osborne as Oscar in the Canadian Opera Company production of *A Masked Ball*, 2014. Photo: Michael Cooper.</figcaption>
</figure>

## "I fell in love with him before I ever heard him sing."


"This is the first contract we're doing as a married couple," says Osborne of sharing the stage with her husband, bass-baritone [Gordon Bintner](/scene/people/gordon-bintner/). "We've never worked together on an opera." The pair will also give a duo recital - another first - on October 19th in the Richard Bradshaw Amphitheatre as part of the COC's [Free Concert Series](http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx).

Within the small world of opera, it would be a difficult task for Osborne and Bintner to keep their relationship entirely under wraps; yet they seem to have found a sweet spot between keeping their personal life secret and wholly public. 

For Osborne, her singing career and her marriage to a fellow opera singer are two concurrent - and independent - parts of her life. "I fell in love with him before I ever heard him sing," she says of Bintner. "I'm not successful as a soprano because he's my husband, and he's not successful as a bass-baritone because I'm his wife."

With their first contract together, Osborne admits to having put some thought into the new rehearsal-room dynamics, but she found that any insecurity of how they would work together was soon overshadowed by her - and Bintner's - focus on the job. "We've been working so much longer than we've been together," she says, adding with a smile, "of course, when he hits a great note... holy cow."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505494600274/2017-09-15---Osborne-Riel-16-17-05-MC-D-0796.jpg.jpg)
<figcaption>Simone Osborne as Marguerite Riel in the Canadian Opera Company's new production of *Louis Riel*, 2017. Photo: Michael Cooper.</figcaption>
</figure>

## "It's not hard to feel the joy in a piece like this!"

Osborne's husband isn't the only thing that's familiar about her return to the COC. She's a graduate of the company's Ensemble Studio program, and in recent seasons she has been a regular presence on the Four Seasons Centre stage, singing Gilda in *Rigoletto*, Oscar in *Un ballo in maschera*, Nannetta in *Falstaff*, Micaëla in *Carmen*, and Marguerite Riel in Peter Hinton's much-anticipated new production of *Louis Riel*.

"For the first couple of seasons that I came back I still very much felt like I had to prove myself," says Osborne of returning to what she considers her home company. She admits to feeling pressure to bring consistently great performances to the COC, where the standard of artistry is high and the audiences are in-the-know. "It's probably the pressure I put on myself."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505494608476/2017-09-15---Osborne-Carmen-15-16-03-MC-D-4225.jpg.jpg)
<figcaption>Simone Osborne as Micaëla and Russell Thomas as Don José in the Canadian Opera Company production of *Carmen*, 2015. Photo: Michael Cooper.</figcaption>
</figure>

"I know that there are people out in the audience that support me, and have been invested in coming to shows since I was younger," she says. "That means a lot to me and I take that really seriously." Osborne is conscious of how her home audience follows her international career between Toronto appearances, and that many of them have invested and believed in her, perhaps when others didn't. "I think it's my job to prove them right," she says, adding, "that's intimidating."

Though the pressure she puts on herself comes out of her own drive and high standards - decidedly a good place - there are inevitably larger demands of being a singer in the competitive opera industry. Osborne wisely lets it roll off her back and out of the way of her work. In past years, she may have had the expectations of others in her head; "now I realize mine are enough," she laughs.

"If I kept worrying about all that stuff, it was just going to eat me alive and take away all the joy."

Happily, working on *The Elixir of Love* brings plenty of levity to her day-to-day work. "It's so light and bright and fun, and it's a young cast and everyone's willing to try things," she says. "It's not hard to feel the joy in a piece like this!"

>Simone Osborne sings Adina in The Elixir of Love at the Canadian Opera Company, October 11 to November 4. For details and ticket information, follow our box office links below.
