+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-24T14:59:00+01:00"
lastmod = "2016-09-27T13:09:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474725623578/2016-09-22---Sidney-Outlaw.jpg.jpg"
primary_image_credit = "Photo: Hai Tran"
publishDate = "2016-09-27T12:53:00+01:00"
related_articles = ["articles/talking-with-singers-luca-pisaroni.md","articles/spotlight-on-musa-ngqungwana.md","articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-jorell-williams.md","articles/talking-with-singers-craig-irvin.md","articles/spotlight-on-alexander-hajek.md","articles/two-emerging-singers-to-make-their-carnegie-hall-debut-in-2017.md","articles/spotlight-on-iain-macneil.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/sidney-outlaw.md"]
short_description = "&quot;I try my best to lead by example,&quot; he says. Outlaw sees his singing as an opportunity for putting something positive in the world, &quot;to perform and sing and be a blessing in people&#039;s lives, so if they have that kind of hate in their heart, when I&#039;m done with them, they don&#039;t any more.&quot;"
slug = "sidney-outlaw-stairs-success"
title = "Talking with singers: Sidney Outlaw"
+++

New York-based baritone [Sidney Outlaw](/scene/people/sidney-outlaw/) likens his career as a singer to a quote from actress [Jenifer Lewis](imdb.com/name/nm0507338/): "The elevator to success is broken, honey. Take the stairs."

"Things didn't really take off for me right out of school," remembers the Juilliard grad of his early professional life. Patience is a virtue among many low-voiced men, who, on top of finding consistent work, often have to wait for their instrument to mature before finding consistency of voice. "I had to hustle, I'm still hustling. I'm OK with that. Life is good." 

Outlaw's résumé speaks loudly of a versatile artist, and the baritone enjoys a mix of concert work, like his upcoming performance with the [Memphis Symphony](http://www.memphissymphony.org/2016-2017-season), and on the opera stage as Dandini, Don Giovanni, Demetrius, and the title role in Andrew Davis' *X, The Life and Times of Malcolm X*. He is also a national semi-finalist of the Metropolitan Opera National Council Auditions, the 2nd prize winner of the 2011 Gerda Lissner Foundation Awards, and the Grand Prize winner of the Concurso Internacional de Canto Montserrat Caballé.

"[It's about] what you do along the road to make that journey fun on your way to the top," says Outlaw out his impressive path through the volatile, tough world of opera. "So, I'm on the stairs. I am happily walking up the stairs to success, and on my way to out-Viola Viola Davis!" He laughs when we begged some explanation, "That means it was *amazing*, because Viola Davis could say the ABC's and you would be astonished."

Outlaw's current season includes singing Mercutio in *Roméo et Juliette* at Madison Opera, concerts with the Memphis Symphony and the New York Philharmonic, and recitals with the renowned Warren Jones. "I've very fortunate that I caught up with him before all the other people did," says Outlaw of his collaborations with Jones. "You have to catch him, honey." 

Jones is one of the "greats" from whom Outlaw has had the privilege of learning. "Warren taught me how to lead with the voice," he says, adding that "he still teaches me." Outlaw has also studied with the likes of Marilyn Horne and Montserrat Caballé ("She put a weight on my stomach. *A weight!* And then she says, 'Now, breathe.'") 

## "It's a part of my spirit."

His voice found a home in the school of singing taught by Horne and Caballé, and Outlaw makes a name for himself in roles that move. He tell his manager, "Anything you can get me by Handel, Mozart, Rossini, get it!" Outlaw took advantage of the direction in which his voice went, creating a brand for himself with his vocal niche. When companies are on the hunt for a Barber of Seville, he says, "I want my name at least to be on the short list of five."

Though the repertoire sits comfortably in his voice, his insists, "I practice technique every day of my life." For Outlaw, it's about finding a consistent way to call upon his healthiest, most effortless voice. His daily routine of setting aside dedicated time to concentrate and listen to his body has paid off; his technique is now "so consistent, it's a part of my spirit."

On top of his singing regime, Outlaw trains at Olympic weightlifting and CrossFit. "I have a great coach here in the city, and he's found a really great way to relate singing to the strength portion of our workout." He compares great singing to the fleeting moment of zero-gravity when lifting a weight above his head. "I kind of think of singing, in that way," he says. When things are going right, "it feels free, it feels weightless, effortless. And the reason that it feels effortless is because of the air flow."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474836852778/2016-09-25---Outlaw.jpg.jpg)
<figcaption>Sidney Outlaw, baritone and avid Olympic weightlifter. Photo: Anthony Lucic.</figcaption>
</figure>

"Whenever I stand up to sing, there are no flukes, there are no surprises," Outlaw explains. Though it may sound like a sterile approach to something like singing, it gives him the freedom to truly perform. "For it to be spontaneous, the foundation, the *act* of singing needs to be second nature."

It doesn't matter what it is that he's singing, or where he sings it; for Outlaw, it's about remembering that "people love stories." 

"Even in concert, I'm not myself. I am a character," he says. "Whenever I go to the Memphis Symphony, I'm singing Vaughan Williams' *Dona Nobis Pace* - I'm somebody. I will be somebody telling a story." Song recitals come with the task of becoming multiple characters, something that Outlaw calls, "great practice for when they want me to be *one* character."

Operatic roles by Handel, Rossini, and Mozart offer a dramatic puzzle within the score itself. "If I'm singing something and it has a humongous coloratura passage, or patter, I will come up with a dramatic reason to sing that," Outlaw explains. "Somewhere, I'll come up with it. It might have been two pages before, like 'I meant to say this two pages before, but I'm gonna say this now, and it's going to take me 18 bars.'"

It comes from imagination, but Outlaw insists that he and other successful singers "do the homework," by reading composer's biographies, letters, and collecting knowledge of the history surrounding the music they sing. "I try to do what maestro Rossini wanted, or maestro Handel. They laid stuff out." With the tools supplied by the composer, Outlaw can piece together a character, one who warrants love, hate, or pity.

"I try to out-Viola Viola Davis," he laughs.

## "When they go low, we go high."

"It's there, and I'm sure there are a lot of people who will give you a dossier on it, about being black and an opera singer. Not too many, though." 

The question of an opera singer's life made tougher by discrimination against race and body type is an important one, and Outlaw agrees that it can be "touchy" for black singers to acknowledge it out loud. 

"For me, yes, I've experienced racism in the opera world, but I was also stopped and frisked at the Flushing stop last Thursday," he says, adding that there is some level of "getting used to it."

He recalls the words of Michelle Obama: "When they go low, we go high." There will always be productions cast with a bias towards a certain colour or body type, and Outlaw sees it as a company's prerogative to do so. "All you can do is say, 'Ok, next!'"

It's a topic that carries weight, but it doesn't take up a lot of head space for Outlaw. "I don't have time to think about racism. I acknowledge that it's there, but I don't have time to dwell on it because I'm living life, trying to be the best artist I can be."

"I try my best to lead by example," he says. Outlaw sees his singing as an opportunity for putting something positive in the world, "to perform and sing and be a blessing in people's lives, so if they have that kind of hate in their heart, when I'm done with them, they don't any more."

"There's so much hate in the world, and people look to us as artists to be there. They use music and art as a means of release and forgetting about that," he explains of what he calls his "charge" as a singer. "People look to musicians for that, people look to singers. It is the most high art form, what we do."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474836762023/2016-09-25---Outlaw-Jones.jpg.jpg)<figcaption>Outlaw with Warren Jones, Music for a Great Space.</figcaption>
</figure>

"I'd love to see more blacks in the administrative positions in the opera world," adds Outlaw, who himself has considered working as an artist manager. "That's one thing I would love to do, is see more black people in the arts administration portion of what we do as artists. Teaching, being the heads of voice departments, things like that."

Teaching is another avenue for the artistic "charge" that Outlaw senses. "That's very rewarding to know that the people who taught you were legends, and you're able to pass that on to the next generation of singers." He has students of his own that he sees while he's not onstage, noting that "I don't have to sing at an opera house in order to touch lives."

## "It all adds to my art."

"My mother, if she were here, she would tell you, 'this child was born to be a musician.'" Outlaw shares his mother's confidence: "I have never been more positive about anything in my life."

When he takes the stage in performance, Outlaw sings for his audience. It's in the practice room that he sings for himself. "It makes me happy. I could be in a cranky mood and I go practice for 20 minutes, and it would be like I woke up again, on the other side of the bed."

With his strong backing of teachers, coaches, agents, and a tight family (including his mother, whom Outlaw has jokingly dubbed, "the black [Maggie Griffin](https://twitter.com/tipitmaggieg?lang=en-gb)"), he has the foundation to become an influential performer. "It all adds to my art."

He has a true love for singing, both for how it can move other people, and for how it can move himself. "I sing because I love it," he puts it simply. His advice for other aspiring singers is almost as concise: "Just sing, put your heart into it, and do the work that needs to be done to achieve great success. That's how you out-Viola Viola Davis."

>[Click here](http://www.memphissymphony.org/2016-2017-season) for details about Sidney Outlaw's upcoming concert with the Memphis Symphony, November 12 and 13.
