+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-04-02T13:13:00+01:00"
lastmod = "2017-04-11T11:49:00+01:00"
preamble = "Last year, we brought you some tips on opera-insider jargon, and how to speak the industry shorthand. [Part I](/opera-shorthand-how-to-speak-like-an-insider/) focused on the names of operas and their nicknames, and in part II, we're talking rehearsals and types of voices. So, if you're hoping to infiltrate opening-night opera parties, or just keep up with the opera talk with your singer friends, we can help you with the shortened lingo.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491825759316/2017-04-10---Insider.jpg.jpg"
publishDate = "2017-04-11T11:21:00+01:00"
related_articles = ["articles/opera-shorthand-how-to-speak-like-an-insider.md","articles/back-to-school-opera-a-practical-glossary.md"]
short_description = "Last year, we brought you some tips on opera-insider jargon, and how to speak the industry shorthand. Part I focused on the names of operas and their nicknames, and in part II, we&#039;re talking rehearsals and types of voices. So, if you&#039;re hoping to infiltrate opening-night opera parties, or just keep up with the opera talk with your singer friends, we can help you with the shortened lingo."
slug = "shorthand-ii-proben-facher"
title = "Opera shorthand, part II: Proben &amp; Fächer"
+++

## The rehearsals & *probes*

English-speaking opera circles tend to use a lot of terminology from other languages. The French word *répétiteur* refers to the rehearsal pianist ("the repeater", literally), and the Italian term *da capo* ("from the top/head") is an easy way for a conductor to name a starting point in the score. 

For some reason, English speakers lean towards the German terms for various types of rehearsal; the simple term is *probe*, which translates into English somewhat optimistically as a "try". Two more terms, *Sitzprobe* and *Wandelprobe* refer to specific types of opera rehearsals. 

The ***Sitzprobe***, or "sitting rehearsal" is the first (and often only) chance for singers and orchestra to go through an opera together, without the distractions of staging. Opera folk tend to shorten the term, and just call it, "***Sitz***". Like the unpleasant skin condition.

The ***Wandelprobe***, or "wandering rehearsal", is when the orchestra and singers have a go at an opera, usually in the performance space, where the singers can add in a loose version of staging; it's generally done without full costumes or sets, but it gives the singers a chance to feel the geography of the stage, and decide how well they can see the conductor and hear the orchestra. Following suit with *Sitzprobe*, opera types tend to just say, "***Wandel***".

There are other rehearsals with duller terms, like the **dress rehearsal** and **technical rehearsal**. To sound like you're really in-the-know, the terms are simply, "**dress**" and "**tech**". "**Dress**" is the last rehearsal before opening night, which is supposed to be a full run-through of the show with orchestra, sets, costumes, lighting, the whole deal. **Tech** rehearsals are about getting lighting right, practicing set changes, basically everything that doesn't involve the music. If a singer says to you that they're off to "tech", wish them luck and ask them if they've brought a book.

Even more specific are **piano dress** and **piano tech**, which are the same concepts, but with a pianist filling in for the orchestra; these rehearsals with piano are generally not the ones that singers enjoy most, but if you're talking with a répétiteur who's set to play a piano tech or piano dress, it can be oodles of fun indeed.

## The voice types

The colourful spectrum of all the different shades of voices is full of detail, contention, and a bit of special-snowflake-ism. Within the broad term of "soprano", there can be variants like "lyric", "dramatic", "spinto", "coloratura", *et cetera ad nauseam*.

The common shorthand follows a fairly consistent pattern of leaving out the broad terms like "soprano", "mezzo-soprano", "tenor", or "bass". Opera folk tend to just mention the subtle shade. 

So, a "***buffo* bass**" is just a ***buffo***, which is kind of weird because "buffo" just means "funny" - technically, you could be a "buffo soprano", but no one really calls them that. A "**coloratura soprano**" is shortened to "**coloratura**", which is also odd, because "coloratura" just means you're good at singing fast-moving notes. In casual operatic vernacular, referring to a singer as a coloratura also implies that they're a soprano; for some reason, "coloratura mezzo" isn't really a thing, even though it should be. The sentence "He's a coloratura" is super confusing with the masculine pronoun, even though it could mean you're someone like Lawrence Brownlee or Luca Pisaroni, who are both men and known for singing lots of notes. 

A more straightforward shorthand is in the term "**Heldentenor**", who are the "heroic tenors" who sing a lot of German opera; they're often just called "**Heldens**". "**Spinto**" is more egalitarian, referring to both tenors and sopranos; but no one is really a spinto mezzo or a spinto baritone.

The weirdest shorthand is perhaps with the terms "**Zwischen**", which means "in between", and refers to a voice type that can sing a little bit of one voice type (like soprano), and a little bit of another (like mezzo-soprano). When people say a singer is a "Zwischen", they usually mean the example we just mentioned; for some reason, the term has come to apply mainly to women. The male version of a "Zwischen" is perhaps the cutesy term, "**baritenor**", meaning a baritone with extra high notes, or (more rarely) a tenor with extra low notes.
