+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-11-17T09:00:00-05:00"
lastmod = "2015-04-13T23:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428981452601/LIBRA.jpg.jpg"
publishDate = "2014-11-17T09:00:00-05:00"
related_articles = ["articles/live-theatre-respecting-short-attention-spans.md","articles/playing-the-long-game-fostering-artistic-respect.md","articles/opera-with-a-message-operation-superpower.md","articles/great-ideas-snappy-operas.md","articles/baby-opera-singers-getting-angry-for-the-right-reasons.md","articles/just-in-the-crowdsourced-melody-is-complete.md","articles/why-our-artistic-roots-matter.md","articles/cute-catchy-the-schoolyard-carmen.md","articles/dont-miss-beatrix-potter-at-edinburgh-fringe.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
short_description = "I&#039;m spending this month touring around Ontario, putting on opera for kids. We bring a whole set, costumes, props and electric keyboard, to school gyms and perform for hundreds of kids, twice a day. It&#039;s a lot of early mornings, a lot of equipment-schlepping, and a lot of time in the tour van. "
slug = "shhdont-tell-them-its-opera"
title = "Shh...Don&#039;t tell them it&#039;s opera!"
+++

I'm spending this month touring around Ontario, [putting on opera for kids](http://www.coc.ca/ExploreAndLearn/Schools/SchoolTour.aspx?agilitychannel=website). We bring a whole set, costumes, props and electric keyboard, to school gyms and perform for hundreds of kids, twice a day. It's a lot of early mornings, a lot of equipment-schlepping, and a lot of time in the tour van. But it's worth it. From where I sit at the piano, I can look out at the sea of kids as they take in live opera, probably for the first time in their lives. There's the usual gamut of reactions, like wide-eyed awe, laughter, terror, and indifference. I love them all, even the blatant hands covering ears when the singers get a bit too close for comfort.

It's true that enough slapstick comedy will get laughs from kids, even without much artistry behind it. But children are an honest litmus test for something like opera. They react in a big way, using their voices and bodies to tell the performers just how they feel about what's happening onstage. Conversely, it's really noticeable when there's no reaction at all. If a performer mumbles his words, a joke falls flat and crickets are heard. If there's no eye contact, no connection between singers and the kids, it's pretty easy to lose their attention and never get it back. Stage director [Ashlie Corcoran](http://www.ashliecorcoran.com/) has her fair share of experience in directing children's opera: "When I am directing an opera for children, my number one priority is that they have an artistic and cultural experience. By that, I mean that sometimes live performance directed at children is used as a vehicle to explore an issue, or a moral or a lesson. Personally, my priority is that the young audience walks away from their experience jazzed by what they saw - curious about the music, about staging and design, and inspired by live storytelling. Basically - wanting to see more opera, or theatre, or dance."

Performing for kids never fails to remind me of the "why?" in all this opera that we do. It jolts me out of the mainstream opera scene, and I can take an objective survey of the point of it all. See, the thing with kids is they don't have much patience for self-indulgent entertainment. There exists a fair amount of self-indulgence in "adult" opera (I say a "fair" amount in the sense that it's not always bad to be selfish in an opera. For singers, sometimes it's just necessary), and adult audiences are much more likely to forgive it. If a singer is singing a note-perfect, blandly-acted Violetta, opera-going grown-ups are more prone to enjoy the show and ignore the lack of storytelling. But singing for its own sake won't travel far with kids.

It's all about the story, and that holds the creators of opera for young people to a high standard of artistic integrity. I asked [Dean Burry](http://www.deanburry.com/), Canadian composer of several children's operas (_The Brothers Grimm_, _The Bremen Town Musicians_, _The Scorpion's Sting: An Egyptian Myth_), about his process: "Young people are generally not as jaded towards contemporary music as adults are, so, amazingly, they are often more open to new sounds. If the music is clear and engaging, they will usually go the distance for you. Yes, when writing for young people you need an exciting story, clarity of text and musical idea, and something which is relevant...but isn't that what everyone wants? I think a lot of so called 'grown-up' works could learn a lot from a 'children's' aesthetic."

That last sentence of Dean's is an important one; understanding that audiences of all ages demand the same thing can be a lightbulb moment for creators of opera. One of the things in common between audiences of all ages is that no homework is necessary to be moved by live theatre and music. It's a fair assumption that most kids under ten years old haven't seen opera, and perhaps they haven't seen any form of live theatre at all. With that in mind, it's really an amazing thing to see hundreds of kids simply react to what they see and hear. My biased opinion is that these kids are _totally loving_ opera. "Writing for 4 to 12 year olds in itself is a big challenge," says Dean. "This is where it is so important to create a multi-layered work. The younger kids love the slapstick (so do I) and the older ones can appreciate the more sophisticated story elements and metaphors. Honestly, I never write with one specific group in mind. I think it is possible for a good work of art to have something for everyone...and most of the times, parents and teachers seem to enjoy my operas as much as the kids. That means a lot to me."

Frankly, when it comes to kids getting introduced to opera, it doesn't matter what they noticed or liked; it doesn't even matter if they remember the show. The point is for them to have seen and heard something new, and for them to _feel something_. Says Ashlie, "One of the most fun parts of directing opera for children is the power that can be found in breaking the fourth wall. I encourage the singers I am working with to make real eye contact with the children sitting at their feet - to use them as their confidents and advocates. It's the best way to hold children's attention - and involve them in the story!" If kids experience a connection to live theatre, even one time, perhaps the idea of opera won't be associated with vague ideas of boredom and inaccessibility when they become adults. And when those adults start deciding how they want to spend their disposable income, perhaps tickets to a live show will be on the list.
