+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-01-18T11:46:00-05:00"
lastmod = "2016-01-28T20:25:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454030634731/DeathtoStock_London9Resized.jpg.jpg"
publishDate = "2016-01-29T09:00:00-05:00"
related_articles = ["articles/the-heart-and-the-art.md","articles/teeoh-eh.md"]
related_companies = ["scene/companies/the-bicycle-opera-project.md","scene/companies/against-the-grain-theatre.md","scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/krisztina-szab.md"]
short_description = "A question often lingers: would I love all of this stuff as much if you didn&#039;t already know half of the creative team? In an interesting experiment in journalistic bias, London is a place where there&#039;s no shortage of excellent music and theatre, yet in comparison to writing about Toronto, I&#039;ll have little personal connection to the artists onstage. Basically, the art that London has to offer will speak for itself, at least to me."
slug = "shes-leaving-home"
title = "She&#039;s leaving home"
+++

Last week I was sitting in Roy Thomson Hall, listening to the TSO play Mozart's *Requiem*, and taking in Joel Ivany's subtle and inclusive staging; one visual constant in this *Requiem* was the use of white index cards, which in the context of this piece about death and grieving, held the names of people that had been lost. Somewhere around the "Benedictus", I remembered the fleeting confusion I had when I was given my programme, along with a blank white card. I'm not sure why it took me until mid-way through the piece to really put that together, but when I did, my reaction surprised me. The inclusive gesture of giving me, little old me, an index card of my own felt so touching; on top of the overwhelming music and beautiful artists, this blank white card was a sort of straw that broke the camel's back of tugging at my heartstrings.

Of course, this was all happening at the same time as my partner and I pack up our lives, only days away from our move across the Atlantic, to settle in London for a little while. Things like boxing up your favourite books and selling your piano can throw wrenches in your comfortable routine; walking around Toronto, there's a near-constant awareness that I may be in a neighbourhood for "the last time" or that there's someone I'll forget to say goodbye to. So, hearing Mozart with my preferred concert date (contributor Greg Finney), in one of Toronto's iconic performance spaces, watching the work of Joel Ivany, a colleague, friend, and current figure of the city's opera scene, it felt a little bit like a Requiem for my time here in Toronto.

Of course, leaving the city isn't really a death at all, and so perhaps "Requiem" is a bit of a hyperbolic choice of word. The opera and classical music scenes here are a tightly connected web of people, constantly mixing and matching into various combinations. I have no doubt that there's a similar web to uncover in the London scene, not to mention its part in the larger European opera machine. Royal Albert Hall, the London Coliseum, the Royal Shakespeare Company, musicals in the West End, they're all going to wow me because there's an innate excitement of walking into a new venue to see new people perform.

And yet, the Royal Opera House won't be the Four Seasons Centre, and the West End won't be King Street, and there won't be as much [Krisztina Szabó](/scene/people/krisztina-szabo/) or [Bicycle Opera](/scene/companies/the-bicycle-opera-project/) [Tapestry Opera](/scene/companies/tapestry-opera/) or [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) or Roy Thomson Hall. It's something that has struck before, the fact that my "in" with the Toronto scene has come almost as much from my work as a pianist as it has from my place as a media-type. 

A question often lingers: would I love all of this stuff as much if you didn't already know half of the creative team? In an interesting experiment in journalistic bias, London is a place where there's no shortage of excellent music and theatre, yet in comparison to writing about Toronto, I'll have little personal connection to the artists onstage. Basically, the art that London has to offer will speak for itself, at least to me.

There's also context to be learned with a big move. To compare opera in a Canadian city versus a British or German or French city is almost an apples-to-oranges situation. The economics are different, the aesthetics change, and the voices, as always, will be varied. Most of all, the role that opera plays in contemporary society will be, I anticipate, quite different. 

The plan is to check in with my hypotheses in a few months, after I've been to a few shows, and hopefully have had a few British singers join our interview roster.

In the meantime, I hear that variety makes one's life spicy; is it ironic that I'm going to England to get my fix? 
