+++
author = ["authors/jenna.md","authors/greg.md"]
categories = "Review"
date = "2015-11-04T13:12:00-05:00"
lastmod = "2015-11-04T21:28:00-05:00"
preamble = "Last night, I went with [Greg Finney](https://twitter.com/gregory_finney) to [Centre Stage](http://coccentrestage.ca/), the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s Ensemble Studio Competition. The competition is the culmination of nationwide auditions, narrowing the 120 applicants down to eight young Canadian singers. Dressed in gorgeous gowns and suits (gifted to them from The Hudson's Bay Company's Queen Street store), finalists sing on the Four Seasons Centre stage, with the COC Orchestra led by Music Director Johannes Debus. It's a pretty big deal for these aspiring young singers.\n\nThe evening is separated into two rounds, one for the panel of judges and a private audience, followed by a second round for the public. This year, Greg and I were lucky enough to hear both rounds, and so we were each able to get a slightly broader look at these young artists. Here's what we thought, ladies first:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446663138166/2015-11-04---Centre-Stage-Winners---Square.jpg.jpg"
primary_image_credit = "All photos by Michael Cooper."
publishDate = "2015-11-04T14:26:00-05:00"
related_articles = ["articles/centre-stage-2014-lets-hear-it-for-the-boys.md","articles/coc1617.md","articles/duets-for-lunch-uoft-opera-in-concert.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/lauren-eberwein.md","scene/people/pascale-spinney.md","scene/people/samantha-pickett.md","scene/people/bruno-roy.md","scene/people/marjorie-maltais.md","scene/people/eliza-johnson.md","scene/people/emily-dangelo.md","scene/people/zachary-read.md","scene/people/joyce-elkhoury.md","scene/people/andrew-haji.md"]
short_description = "Last night, I went with Greg Finney to Centre Stage, the Canadian Opera Company&#039;s Ensemble Studio Competition. The competition is the culmination of nationwide auditions, narrowing the 120 applicants down to eight young Canadian singers. Dressed in gorgeous gowns and suits (gifted to them from The Hudson&#039;s Bay Company&#039;s Queen Street store), finalists sing on the Four Seasons Centre stage, with the COC Orchestra led by Music Director Johannes Debus. It&#039;s a pretty big deal for these aspiring young singers."
slug = "she-saidhe-said-centre-stage-2015"
title = "She said/He said: Centre Stage 2015"
+++

## She said...

I'm historically terrible at calling competitions, and this was no different. Placing in the competition doesn't directly correlate to a spot in the Ensemble Studio, but it's a good indicator; so, for those of us who like to make an educated guess at how the judges will vote, it can be hard to find the balance between looking for the best singer on competition day, and looking for a singer who is ready to begin a professional career. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666828098/2015-11-04---Centre-Stage-Lauren---MC.jpg.jpg)<figcaption>Ensemble Studio Competition Second Prize winner mezzo-soprano Lauren Eberwein, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

This year seemed the year of the mezzo, an appropriate choice for a male-dominated Ensemble Studio. Two of these mezzos took the top prizes; Emily D'Angelo (Toronto) won First Prize and Audience Choice Award, totaling $6500), and Lauren Eberwein (Qualicum Beach, BC) took Second Prize, worth $3000. The $1500 Third Prize went to baritone [Bruno Roy](/scene/people/bruno-roy/) (Montréal).

I want to first talk about all these mezzos. [Pascale Spinney](/scene/people/pascale-spinney/) sang with a lovely sound that was even and dark, but her choice of rep seemed a bit subdued. She sang "When I am laid in earth" from *Dido and Aeneas* for her first round, which I thought showed more of her voice than her second round choice, "Faites-lui mes aveux" from *Faust*. I was curious why she didn't offer anything with a bit more fire. Speaking of fire, [Marjorie Maltais](/scene/people/marjorie-maltais/) started with *La cenerentola*, and sang Gounod's "Que fais-tu, blanche tourterelle" for the public round. Hers was some of the night's most polished, smart singing, with a gorgeous natural affinity for the Rossini. I was very surprised that Marjorie didn't place.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666452869/2015-11-04---Centre-Stage-Marjorie---MC.jpg.jpg)
<figcaption>Ensemble Studio Competition finalist mezzo-soprano Marjorie Maltais, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

The winning mezzos each showed a big range with their aria picks. [Emily D'Angelo](/scene/people/emily-dangelo/) won the evening by starting with "Voi che sapete" from *Le nozze di Figaro*, saving "Contro un cor" from *Il barbiere di Siviglia*. She showed off a sense of humour, and some coloratura that bloomed into a cannon of a sound; she even did it on crutches. Emily was one of the few competitors who looked comfortable on that big stage (or at least masked her nerves well), and I was able to get drawn in to her performance. 

Second Prize winner [Lauren Eberwein](/scene/people/lauren-eberwein/) was another breath of fresh air. She began with a wink to Maestro Debus, and then launched into "Sein wir wieder gut" from Strauss' *Ariadne auf Naxos*. It was wonderful to see someone enjoying herself in a hyped-up environment, and Lauren really seemed to become the Komponist. She sang "Parto, parto" from *La clemenza di Tito* in the second round, an important foil to the Strauss. Her coloratura was less clear than it could have been, but there was maturity in her performance that I'm glad was recognized.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666546743/2015-11-04---Centre-Stage-Samantha.jpg.jpg)
<figcaption>Ensemble Studio Competition finalist soprano Samantha Pickett, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

Soprano [Samantha Pickett](/scene/people/samantha-pickett/) sang "Deh, se piacer mi vuoi," one of Vitellia's great arias from Mozart's *Tito*. Samantha's voice can do a lot, including some impressive agility in the aria's picky coloratura. I wish that more people had heard her first round choice, "Come in quest'ora bruna" from Verdi's *Simon Boccanegra*. I thought she had lovely poise, and the aria showed off some of the most exciting qualities in Samantha's voice.

[Eliza Johnson](/scene/people/eliza-johnson/) sang two of the night's best performances, if you ask me. She's another who I expected would be a no-brainer for the top three. She sang "Caro nome" from *Rigoletto* in the public round, but the real magic, I thought, happened in her first round performance of "Ach, ich liebte," from Mozart's *Die Entführung aus dem Serail*. With Eliza, it's always legato, it's always in her control, and it's always beautiful. I thought she was fantastic.

The men were certainly outnumbered last night. Baritone [Zachary Read](/scene/people/zachary-read/) started off brave with "Largo al factotum" in the first round, and I heard him settle into the nerves and begin to have fun. His second round pick was "Avant de quitter ces lieux" from *Faust*, which let us get a better listen to his voice. I thought both of his aria choices were built around having a great high G, but last night Zachary's high range sounded underwhelming, perhaps because of the size of the house. He did have some gorgeous sound and lovely onstage energy, and I wondered why he chose to make it about high notes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666571199/2015-11-04---Centre-Stage-Bruno.jpg.jpg)
<figcaption>Ensemble Studio Competition Third Prize winner baritone Bruno Roy, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

Third Prize winner [Bruno Roy](/scene/people/bruno-roy/) cut beautifully in the Four Seasons Centre, singing for the public round "Hai già vinta la causa" from *Le nozze di Figaro*, after "Bella siccome un angelo" from *Don Pasquale* in the first round. Bruno is still young, but he has an exciting voice that could go a few different ways. 

The night was full of pomp, hosted by two current Ensemble Studio members (and past Centre Stage winners), soprano [Karine Boucher](/scene/people/karine-boucher/) and tenor [Charles Sy](/scene/people/charles-sy/). I could have done with a little less hokey banter, but I did like the idea of current Young Artists having their hand in the event. While the jury deliberated, there were surprise performances by [Andrew Haji](/scene/people/andrew-haji/) and [Joyce El-Khoury](/scene/people/joyce-el-khoury/), two still-young artists, but at an audibly different point in their careers.

Like I said, I'm historically terrible at calling competitions. My picks included Marjorie Maltais and Eliza Johnson, and I'm curious to know if they're being considered for spots in the 2016/17 Ensemble Studio. From here on, I refer you to Greg Finney, for the "He Said" account of Centre Stage 2015.

## He said...

First off: great job! A billion mazels to all the singers that took part. It was an evening of some really great music by people I'm really excited to hear more of. 

Secondly. I did NOT call this one at all. Wow. 

### Round One. 

Pascal Spinney, mezzo-soprano, opened with Dido's Lament, which I thought wasn't the best choice. Not that she didn't sing it well, but it's such a finicky aria. Even something as small as a slightly faster tempo can set it off course, and I think that's what happened here. Great voice, lamentable tempo. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666599211/2015-11-04---Centre-Stage-Pascale.jpg.jpg)
<figcaption>Ensemble Studio Competition finalist mezzo-soprano Pascale Spinney, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

Baritone Zachary Read, from Halifax (902 Represent!!) sang the perennial hit "Largo al factotum". It was a solid delivery. His forward placement lent him a facility in his patter that let the diction come through. From where I sat his mid-range was difficult to hear through Rossini's orchestration.

Soprano Samantha Pickett followed with an aria from *Simon Boccanegra*. A powerful dramatic soprano in the making (I think), I feel this choice didn't quite show off some of the fireworks of which she's clearly capable. I think this was the best piece for marrying the orchestra with the singer well, though. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666760046/2015-11-04---Centre-Stage-Zachary.jpg.jpg)
<figcaption>Ensemble Studio Competition finalist baritone Zachary Read, Centre Stage 2015.</figcaption>
</figure>

Up next, mezzo-Soprano Emily D'Angelo sang the evening in a lovely gown and crutches. With her right foot in a cast, she delivered a solid Cherubino. Her "Voi che sapete" was clean, precise and very pretty. Exactly as Mozart should be. 

Baritone Bruno Roy of Montréal followed with a reasonable *Don Pasquale*. The coloratura was pretty decent but I could have done with a little cleaner Italian. The aria sat really quite well and he seems to handle a higher tessitura with quite a bit of ease. 

Another mezzo-Soprano, Marjorie Maltais wowed us with a stunning *La Cenerentola*. Fiery eyes and a flashy dress had me enthralled. Add the fireworks of her remarkable coloratura, each triplet was solidly in tempo and had wonderful direction. I was sold. Brava. 

Stratford soprano Eliza Johnson was up next with an aria from *Die Entführung auf dem Serail*. A twinkling soprano with a shimmer that filled the hall with ease delivered a delightful, nuanced, beautiful delivery. She may have started a little on the intimate or reserved side, but after her first passage she continued to open up throughout her performance. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666632930/2015-11-04---Centre-Stage-Eliza---MC.jpg.jpg)
<figcaption>Ensemble Studio Competition finalist soprano Eliza Johnson, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

Capping off round one was Lauren Eberwein, offering up Strauss' Composer's Aria from *Ariadne auf Naxos*. Clearly at home in pants roles, she gave a solid performance of a difficult aria over a lush full orchestration. I thought her dark tone occasionally found itself lost in the swells of Strauss, but the bloom on her upper register was dramatic and effective. 

Yes. You read correctly. This was definitely the year of the mezzo. 

### Ding: Round Two. 

Now for the good stuff.

Spinney steps up again with "Faites-lui mes aveux" by Gounod. I think this one suited her more than Dido. Lively and spritely she sang with a more solid production. She was more animated this time around in her breeches role which was a nice contrast to her staid, very recital-like presentation of the Purcell. 

Zachary Read also followed up with an aria from *Faust*. Singing "Avant de quitter ces lieux" he brought out a nice french baritone line of delivery. It was another strong outing for Read, who also does well with a high tessitura, however the "money notes" feel like they still need a bit more time to develop. 

Pickett followed up with a fantastic Vitellia from *La clemenza do Tito*. Here we got to see some of the fireworks I was hoping for. Clean quick solid runs and high notes for days. I'm really looking forward to more from Samantha. She sang the mozart with a bel canto sensibility, so I'd like to see her tackle some Rossini, Donizetti and Bellini in particular. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666671144/2015-11-04---Centre-Stage-Emily---MC.jpg.jpg)
<figcaption>Ensemble Studio Competition First Prize and Audience Choice Award winner Mezzo-soprano Emily D’Angelo, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

D'Angelo brought us Rosina's "Contro Un Cor" from *Il barbiere di Siviglia*. This is her wheelhouse for sure. I lost the sense that I was watching a competition and was transported to full gala headspace. It was a cheeky, well-rounded performance, and like a pro she definitely played off the fact that her right foot was in a cast. It was nice to see her having fun in a situation where the stakes are as high as this.

Bruno Roy followed up with the Count's aria from *Le nozze di Figaro*. I wasn't sold on this one. Still love the voice, but after hearing such clean Mozart arias from the ladies, it kinda fell flat for me. The recit was very tame and the 'B' section lacked clarity in the triplets. This was the first time in the night I was really separated from the performance due to dramatic choices. This Count just didn't seem angry enough for me. But it is a singing competition after all, I do recognize that. 

Maltais followed up with "Que fais-tu, blanche touterelle" the third in a surprisingly Gounod-heavy evening. I love hearing French people really enjoy singing their language. This was no different. A playful and jubilant Stephano, you got swept away in her taunts towards the Capulets. I think she handled the shift from "Cinderella to younger fella" quite well. 

And then, Eliza happened. In my opinion this was the standout performance for me. She sang "Caro Nome" from *Rigoletto*, flawlessly. She had a delicacy beneath her power that manifested as a beautiful long line when she sang with a fuller tone. Definitely a voice to watch out for.

Ending the evening with a robust "Parto, Parto" (again from *Tito*) was Eberwein. This also is a singer to watch. I look forward to her in a role so I can see her character physicalization fully, which she clearly intended to do tonight. I felt her to be the strongest acting singer of the night. 

Then. Surprise, we get some Haji! 

Toronto fave and super awesome tenor extraordinaire Andrew Haji gave us "En fermant les yeux" from Massenet's *Manon* and it was beautiful. Enough said.

Then! Surprise, surprise! Joyce El-Khoury comes out and devastates us with Dvořák's  "Song to the Moon" from *Rusalka*, and the Jewel Aria from, yup, you guessed it, *Faust*. It was the perfect way to round out the evening. She sang beautifully and elegantly and magnificently. Brava!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446666930774/2015-11-04---Centre-Stage-Joyce.jpg.jpg)
<figcaption>Centre Stage surprise musical guest soprano Joyce El-Khoury, 2015. Photo by Michael Cooper.</figcaption>
</figure>

The event was hosted by past winners Karine Boucher and Charles Sy. They were charming and lovely and dealt magnificently with a rather stilted script (emceeing is not easy, I've been there -  especially when they script out your anecdotes) but they kept the show going nicely and looked damn fine while they did it. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446667242894/2015-11-04---Centre-Stage-Tutti.jpg.jpg)
<figcaption>Canadian Opera Company General Director Alexander Neef with finalists of the Ensemble Studio Competition, Centre Stage 2015. Photo by Michael Cooper.</figcaption>
</figure>

The COC orchestra was in top form, if a little on the rambunctious side. Aside from the Purcell, I thought generally the tempi were rather lovely, especially "Largo al Factotum".

The winners did surprise me. Not that any of them didn't deserve it but I had just pegged it differently. For what it's worth, I was thinking Eliza first, Marjorie second, and Lauren third.

All in all: *bravi, tutti*. You all sang splendidly and I can't wait to hear more. 

\#YearOfTheMezzo \#EverybodySingGounodNow

