+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-02-08T10:50:00-05:00"
lastmod = "2018-03-14T10:58:00-04:00"
preamble = "Opera is opera is opera, right? Lots of singing, some love affairs and some deaths? Well, of course. But within the broad term of \"opera\", there are subgenres which all offer something a bit different.\n\nWhether you're looking for some clarity on the operatic styles, or you're hoping to make an educated choice on an upcoming trip to the opera, we've got a crash course in everything from *opera seria* to *Romantische Oper* - and even a few examples.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486907847979/2017-02-11---Types.jpg.jpg"
publishDate = "2017-02-13T05:50:00-05:00"
related_articles = ["articles/a-faq-checklist-for-opera-newbies.md","articles/back-to-school-opera-a-practical-glossary.md","articles/what-the-eff-is-a-zarzuela-anyway.md"]
related_people = ["scene/people/renee-fleming.md","scene/people/nina-stemme.md"]
short_description = "Verismo music is decidedly gorgeous, with long, sweeping lines and a thick orchestra. The musical style is a foundation for the film scores of today, and though the impression is powerful, the harmonic structure of many verismo scores is fairly simple; it adds to the audience accessibility, and makes for some beautiful tunes to hum as you leave the theatre."
slug = "shades-of-opera-how-to-tell-your-buffo-from-your-bel-canto"
title = "Shades of opera: how to tell your buffo from your bel canto"
+++

## *Opera buffa*/*opera seria*

Strictly speaking, "funny opera" and "serious opera", [*opera seria*](https://en.wikipedia.org/wiki/Opera_seria) and [*opera buffa*](https://en.wikipedia.org/wiki/Opera_buffa) are broad-reaching terms for 18th-century Italian opera, following guidelines of form and sharing common plot themes. Good examples of *opera seria* are Mozart's *Idomeneo* and *La clemenza di Tito*, and Handel's *Rodelinda* and *Alcina*. It's a form that fell out of fashion by the end of the 18th century, making way for more Romantic genres.

*Opera buffa* is another broad term, often mirrored in the French *opéra comique* or even the German *Singspiel*. *Buffa* operas have funny plots - obviously - but they're by no means fluff; they're also where singers will find some of the most difficult arias in all of opera. Rossini's *Il barbiere di Siviglia*, Mozart's *Le nozze di Figaro*, and Donizetti's *L'elisir d'amore* are all *opera buffa*; Mozart's *The Magic Flute* is likely the most famous *Singpiel*, and Berlioz's *Béatrice et Bénédict* and Donizetti's *La fille du régiment* are *opéras comiques*.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/gW1wC0q4_3k?start=2000" frameborder="0" allowfullscreen></iframe><figcaption>The Act I duet from Rossini's *Il barbiere di Siviglia*, sung by Hermann Prey (Figaro) and Luigi Alva (Almaviva).</figcaption></figure>

## *Bel canto*

Perhaps only second in prevalence to the horned Valkyrie stereotype is the trope of [*bel canto*](https://en.wikipedia.org/wiki/Bel_canto) opera. The Italian term means "beautiful singing" or "beautiful song"; appropriately, *bel canto* maximizes the power of the human voice. The orchestra is sparse and light, playing simple accompaniment that has lots of rhythmic flexibility to make it easy to follow the singer. On top of that accompaniment, the singers stretch out impossibly long melodies, flashy coloratura passages, and cadenzas meant to show off what they do best.

Operas like Bellini's *I Capuleti e i Montecchi*, Rossini's *Otello*, and Donizetti's *Roberto Devereux* are great examples of *bel canto*. Since it's more of a style of singing than a stand-alone operatic genre, *bel canto* can also be found in the Grand operas of Verdi or the *opera buffe* of Rossini. For a taste of real-deal *bel canto*, the clip below is a true classic.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/GrY66tzzveY?start=12" frameborder="0" allowfullscreen></iframe>
<figcaption>"Mira, o Norma", from Bellini's *Norma*, sung by Marilyn Horne and Joan Sutherland.</figcaption></figure>

## Grand opera

[Grand opera](https://en.wikipedia.org/wiki/Grand_opera) is perhaps a broader label than some others on this list. Italy and France both have their versions of Grand, which is essentially super-sized opera. The works can be four or five acts long, demanding extraordinary singers and a large orchestra; the set design is lavish, and there's usually a small ballet inserted somewhere around Act II.

Ballet in combination with opera has a strong tradition in France, which is why there are more French works that comply with the strictest definition of "Grand opera". Still, the ballet was often only a part of the show because of the demands of the opera patrons, some of whom had more interest in dancers than singers. They even planned the ballet around their preferred meal times.

Operas like Meyerbeer's *Les Huguenots*, Gounod's *Faust*, Halévy's *La Juive*, and Rossini's *Guillaume Tell* are good examples of Grand opera; you can also look to some Verdi (like *Un ballo in maschera*) and even Wagner's *Tannhäuser* for the same operatic recipe. As Grand opera matured, we got works like Massenet's *Le Cid* and Saint-Saëns' *Henry VIII*.

Grand opera became too expensive to sustain, and it fell out of fashion by the end of the 19th century. It's still too costly for many theatres today, which is why a lot of these titles may be a bit obscure.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/47Og7nQtWag?start=8221" frameborder="0" allowfullscreen></iframe>
<figcaption>Act II duet with Raoul (Anson Austin) and Valentine (Amanda Thane), from Meyerbeer's *Les Huguenots*.</figcaption></figure>

## *Verismo*

Puccini's *La bohème* is one of the most famous examples of [*verismo*](https://en.wikipedia.org/wiki/Verismo_(music) opera. It's an Italian sub-genre, and the name roughly translates to "realism". It's supposed to be an answer to all the operas about royalty, gods and goddesses, and other characters who are harder for the average audience member to indentify with. *Verismo* is about more earthly people, like starving artists, passionate actors, young geishas and political rebels.

*Verismo* music is decidedly gorgeous, with long, sweeping lines and a thick orchestra. The musical style is a foundation for the film scores of today, and though the impression is powerful, the harmonic structure of many *verismo* scores is fairly simple; it adds to the audience accessibility, and makes for some beautiful tunes to hum as you leave the theatre.

Puccini is certainly a big-gun of *verismo* (including rare comic picks like his *Gianni Schicchi*), but you'll also find gems like Leoncavallo's *Pagliacci*, Cilea's *Adriana Lecouvreur*, and Mascagni's *L'amico Fritz*.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/9KEaFLSiT2c?start=10" frameborder="0" allowfullscreen></iframe>
<figcaption>The "Cherry Duet" from *L'amico Fritz*, sung by Luciano Pavarotti and Renée Fleming.</figcaption>
</figure>

## *Romantische Oper*

The term [*Romantische Oper*](https://en.wikipedia.org/wiki/Romantische_Oper) isn't really as common in operatic vernacular as some others; people tend to say "German Romantic" when they're referring to operas by Wagner, Strauss, and Weber. *Romantische Oper* came in the 19th century, full of the themes - nature, folklore, and the supernatural - that exemplified a German national style. Weber helped to kick off German Romantic opera, and giants like Wagner and Strauss brought it the Late Romantic period, doing away with spoken dialogue and introducing the *leitmotif*.

Operas like *Der Freischütz*, *Tristan und Isolde*, *Die tote Stadt*, and *Salome* are considered German Romantic, and they're all delicious. The orchestration is rich and colourful, and these composers were using novel, ingenious ways of setting German text. On top of that, these guys loved the voice. Ahem:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/3D7abQTy71I?start=11049" frameborder="0" allowfullscreen></iframe>
<figcaption>The final trio from Strauss' *Der Rosenkavalier*, sung by Kiri te Kanewa, Anne Howells, and Barbara Bonney.</figcaption>
</figure>

## Operetta

Call it [operetta](https://en.wikipedia.org/wiki/Operetta), *opérette*, or even [Zarzuela](/what-the-eff-is-a-zarzuela-anyway/) - we call it *fun*. Operetta is an umbrella term for various forms of light opera, meant to be more entertaining than head-scratching. *Opérette* grew out of the French *opéra comique*, and composers like Offenbach made it popular with shows like *Orphée aux enfers* and *Ba-ta-clan*. 

Operetta was also big in Vienna, headed by biggies like Johann Strauss II (of *Die Fledermaus* fame) and Franz Léhar (whose *The Merry Widow* is still a favourite today). Over in Berlin, German operetta was infused with burlesque, vaudeville, and cabaret; in its later years, Kurt Weill was a composer who took operetta and moved it forward towards the musicals of the 20th century. Over in England, Gilbert & Sullivan were writing their [Savoy Operas](https://en.wikipedia.org/wiki/Savoy_opera), carving out an English-language world of operetta. 

And if you're curious about Zarzuela, our Toronto contributor [Greg Finney can fill you in.](/what-the-eff-is-a-zarzuela-anyway/)

Operetta is full of catchy tunes, some fun dance numbers, and light-hearted plots. There's a sense of national pride, whether it be French *opéra bouffe*, Viennese operettas, or English G&S.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/DWVq8dCM9xo?start=707" frameborder="0" allowfullscreen></iframe><figcaption>The "Galop Infernal" (or the Can-Can) from Offenbach's *Orphée aux enfers*. FUN!</figcaption>
</figure>

>What are your favourite corners of the opera world? Let us know in the comments below!
