+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2018-01-19T16:38:00-05:00"
lastmod = "2018-01-20T08:03:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516397579927/Conductors.jpg.jpg"
publishDate = "2018-01-20T08:03:00-05:00"
related_articles = ["articles/when-opera-companies-protect-abusers.md","articles/operas-sexual-assault-secret.md"]
short_description = "I pose a theory, though: things are changing. I&#039;m a woman in the industry who has worked with a number of conductors; I&#039;m either extremely lucky, wholly unattractive, or it&#039;s true that conductors in the 21st century are, like men in all industries, getting on board with the idea of respecting their colleagues (and keeping their sex lives outside of the rehearsal room). "
slug = "sex-is-one-of-the-perks-of-conducting"
title = "&quot;Sex is one of the perks of conducting.&quot;"
+++

Norman Lebrecht's [new article for *The Spectator*](https://www.spectator.co.uk/2018/01/the-sex-lives-of-conductors/), "The sex lives of conductors", is a doozy.

"Conductors are migratory birds who fly where their agents point them, hopping from one hotel bed to the next," he writes. "There is no shortage of bright young things on an orchestra’s staff and besotted fans backstage who are open to a wink and the whisper of a room number. A maestro is never alone for very long."

He's not wrong, but it's this next leap that made my eyebrows raise:

"Sex is taken for granted as a conductor’s prerogative. Never an act of love, it is a raw and explicit expression of power. The deal is: sleep with the maestro, or you’ll never work again."

His article is refreshingly frank, albeit full of a lot of unnamed anecdotal examples. With something like this, written by the man behind *Slipped Disc*, it's worth being slightly sceptical.

Still, for anyone involved in operatic or classical music circles, Lebrecht's stories of entitled conductors "too free with their hands" aren't unbelievable. For the great number of conductors working today, it's a minority who are so notoriously ill-behaved; but the threatening breed does in fact exist.

I pose a theory, though: things are changing. I'm a woman in the industry who has worked with a number of conductors, and I've never felt unsafe or objectified; I'm either extremely lucky, wholly unattractive, or it's true that conductors in the 21st century are, like men in all industries, getting on board with the idea of respecting their colleagues (and keeping their sex lives outside of the rehearsal room). 

I won't be obtuse, though, and pretend the whole sleep-with-the-maestro-to-keep-your-job thing doesn't happen. It does happen, and it probably always will, at least a little bit. It's almost a fascinating study, to find the correlation between pursuing conducting as a career, and pursuing subordinates as a pastime.

That large topic aside, two important things occurred to me while reading ["The sex lives of conductors."](https://www.spectator.co.uk/2018/01/the-sex-lives-of-conductors/)

Firstly, sex-entitled maestros are another reason that it's about fucking time the conducting world filled up with more women. Of course, women can be abusers too, but it's hard to deny that there's a difference between the air of power and authority that comes with a maestro, versus a maestra. (I'll admit that's a provocative thing to say, but I'm willing to make this particular logical leap.)

Second, any prevalence of creepsters with batons (be they male or female) is another argument in support of well-funded arts organizations. "Classical music conducts its business behind a screen of secrets, lies and euphemisms," writes Lebrecht. "A maestro is never absent without leave, only 'indisposed'. No maestro ever gets fired. He becomes Emeritus."

If opera companies, symphonies, and ballets are too afraid of offending their donors with potentially bad press to flat-out fire their senior staff members who behave abhorrently, that means money wins over morals. At the risk of sounding naïve, that just plain sucks.

Being beholden to donors and grants is tough enough; but it appears that many companies' financial supporters aren't on board with addressing sexual harassment and abuse in any sort of real way. 

These companies are perhaps stuck between firing someone who deserves to be fired, and keeping their patrons. If anything will contribute to the eventual irrelevance of opera houses, ballet companies, and symphonies, it will be the tacit tolerance of their ill-behaved top-level artistic staff.

If this angers or depresses you, consider supporting your local opera house, ballet company, and symphony. The mythology of the philandering conductor is ready to go away, but it can only be ushered out the door if the companies and their patrons all agree to make it happen.

Lebrecht's [article](https://www.spectator.co.uk/2018/01/the-sex-lives-of-conductors/) is a juicy read, almost a guilty indulgence. I hope that beyond the anecdotal examples is a whole lot of truth; I hope the unnamed in this article start to worry, and that worry turns to change.
