+++
author = ["authors/isaiah-bell.md"]
categories = "Op-ed"
date = "2017-05-30T15:15:00-04:00"
lastmod = "2017-05-31T11:04:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496173034533/2017-05-30---Self-Doubt.jpg.jpg"
publishDate = "2017-05-30T20:23:00-04:00"
related_articles = ["articles/on-the-ego.md","articles/the-business-of-passion.md","articles/in-defense-of-the-day-job-.md"]
short_description = "I can a) quit doing this thing I love and just sit in a corner, or, b) do a diffident, guarded, joyless job of it because I&#039;m hyper-aware of their negative opinions, and making room for their big important opinions is more important to me than my own fulfilment and mental health. (The latter is my default — that&#039;s where I&#039;m most likely to go when the self-doubt gets to me.)"
slug = "selfdoubt-the-accidental-manual"
title = "Self-Doubt: The Accidental Manual"
+++

An unsuspecting friend of mine recently posted on Facebook, "Any cures for (unfounded) self-doubt? Do you just tell your brain to knock it off?" How could she have known (how could anyone have known) that this was like giving Donald Trump the final exam question, "Are you good at making deals? Explain aloud, using accentuating hand gestures." 
 
Self-doubt has an effect on my ability to do my job that I can physically track and quantify. It is like a stillborn conjoined twin that I hide with jaunty, specially-made backpacks. I have expended countless hours, much of the patience of my husband and friends, and not an insignificant amount of good Canadian money addressing this issue. With that in mind, I confidently started typing a response to my friend's question.

An unspecified amount of time later, I came to in a nest of inspirational literature and realized that I had exceeded the character count limit of that refuge for the long-winded, the Facebook comment. It turns out that the only thing I don't have self-doubt about is my familiarity with the phenomenon of self-doubt.

The Internet's trove of self-help articles on this subject is literally bottomless (yes, literally) so there is no reason to add another voice to the cacophony (why bother, I said to myself, you don't know what you're talking about and anyway your opinions are so banal) unless you have a paradoxically inflated idea of your own expertise on self-doubt. So, obviously, here is my rant. [I am not a mental health professional and this is not by any means an exhaustive list! There are as many ways to fight self-doubt as there are hilariously insidious ways to sabotage yourself.]

Always knowing exactly what's wrong with me and with what I'm doing (even if nothing is actually wrong) is my superpower. In my experience, self-doubt exists in a sub-rational place that doesn't have much to do with the facts. This is why it can be totally unfounded and still be peskily difficult to rout. Hence, for me, trying to reason it away can only go so far. It's like trying to convince a deeply religious person, using logic, that a belief of theirs is "irrational" (to be fair to the religious, you'll run into this problem when trying to dissuade anyone from a deeply held belief). That's just not the part of the brain that's in play. 
 
I've been forced to do a lot of work on this stuff over the years because of how destructive self-doubt is to the physical act of singing. In addition to being unpleasant and unhelpful, the self-sabotaging instinct can be powerfully detrimental to my ability to perform in front of people (and of course it's always in front of other people that it flares up the worst — and is hardest to deal with, if you're an introvert like me for whom the very presence of other people already makes your sensors go all wonky). Self-doubt causes my lower abdomen to seize up in a way that prevents my breathing from effectively powering my voice. Which means: this is war. 

Now, obviously, there is no magic bullet. I still struggle with this issue all the time, and it keeps coming back in increasingly creative ways. That said, here are a couple of ways of addressing it that have brought me some relief:

#### Self-doubt, for me, usually comes in the form of a voice inside my head that presents itself as the rational truth. 

It's not even that it "presents itself" that way, actually — my brain never even entertains the idea that what the voice says might not be true. I was stunned when a teacher told me once, "You know, you don't have to believe every thought you have." Jaw --> Floor! 
 
This is easier said than done — obviously. However, I've found that methodically externalizing my negative thoughts can greatly contribute to eroding their power. If self-doubt is a too-familiar part of your inner monologue, you may not see much point in writing down or speaking aloud (in explicit detail!) the things your brain repeats to you all day, but it has been proven to be a great tool by people with much more knowledge in these matters than me. 

By writing down nagging thoughts, you can put some distance between you and them; the bully that was hovering over your shoulder shouting in your ear becomes someone sitting across a table from you. Now you can look him in the face and see him for what a wrong-headed asshole he is, instead of just being overwhelmed and cowed. Writer Paul Ford once made a bot called [Anxiety Box](http://anxietybox.com/) that would email him randomly generated tidbits of his own anxieties and sore spots. "You're fundamentally weak and lazy and because of that you'll never be able to rise above the rest of the pack and accomplish anything that matters." 
 
It's counterintuitive, but giving actual voice to the voice inside your head might allow you to understand how truly ridiculous it is. Recently I've found myself saying out loud things like, "He hasn't emailed me back... I guess my response of 'sure, let me know what time works for you, I'm flexible' made him realize that I'm a desperate and untalented fraud." Somehow, just shining the spotlight on the troll who's always trying to usurp the spotlight can damage his ability to be taken seriously.

#### Finding physical power in your body can be a wonderful way to fight self-doubt. 

Your irrational brain has a deep connection to your body; usually their conversation leaves your rational brain out of things altogether. If you feel oppressed or depressed or discouraged or paralyzed by your self-doubt, try looking for ways your body can feel powerful, happy, and in control. Then re-approach your self-doubt from inside that state. For me, something that helped a lot was dancing on my own. It sounds a bit silly but was actually incredibly effective. I would put on some music that made my body feel joyful and energized. Even jogging in place to the music or moving in a simple, grounded way to the beat let my body know that it was not at the mercy of bad thoughts. Then, when I was starting to feel more physically powerful and free, I confronted the voices that were telling me that I was not good enough. There's something elemental about connecting to your body's capacity for fighting or running away. If you don't feel physically inert or cornered, it's easier to fight back instead of just cringing and taking it when those voices give you shit.


#### One of my favourite ways of thinking about self-doubt... 

...especially when it's tied to fear of failure, and masquerading as a protective impulse — is related to that first idea of "giving the troll the spotlight". I try to imagine the worst possible outcome, and then I give absolute credence to whatever threatening eventuality the self-doubt is holding over my head. For instance: "I'm going to go into this audition, and these powerful people will (not "maybe they will" — they WILL) think I'm amateurish, unprepared, awkward, mediocre, underskilled, ridiculous, stupid, a waste of time." So then I sort of turn that over in my head, and think, OK, what am I going to do now that I know that to be the case? These experts think I'm a boring idiot. I guess I am a boring idiot. So, assuming I'm a boring idiot, how shall we proceed? 

I can a) quit doing this thing I love and just sit in a corner, or, b) do a diffident, guarded, joyless job of it because I'm hyper-aware of their negative opinions, and making room for their big important opinions is more important to me than my own fulfilment and mental health. (The latter is my default — that's where I'm most likely to go when the self-doubt gets to me.) 
 
Do both of those options seem unsatisfactory? What else is to be done, then? Could we possibly just say "fuck 'em!" and do it anyway, because now we have nothing to lose? Again: easier said than done. But the key to reaching beyond the "rational" here and actually talking to your inner child/inner lizard is to fully accept for a moment that all your worst fears about your own inadequacy are true. Not that they might be true if you don't try really hard, but that they're just cold hard fact. It can be, counterintuitively, magically liberating. If you aren't spending your energy trying to fight instinct with logic — in an attempt to convince your caveman brain that you actually ARE good enough, when she just can't quite believe it — then you can actually DO something! 
 
Self-doubt is an attempt at self-preservation. That's why it lives in such a deep place. Some overdeveloped danger sensor is saying, "Wait — you don't have the physical ability to attempt jumping over that ravine. If you try, you might die." Thanks, dog brain, that would have been useful a hundred thousand years ago. But I have this other brain now that can reason and analyze, and it has determined that the worst thing that can happen if I put my painting in this gallery is that no one will want the painting, and then I'll go home and watch TV. 
 
But! Even though I know that, l still can't turn these alarm bells off!! Evolution hasn't caught up with the modern world! I'm stuck dithering on the edge of this cliff! Of COURSE I don't want to fall to my death in that ravine. If I think there's a chance of that, I'm very unlikely to try to the jump. Unless, of course, I feel like NOT jumping is even worse. Will I tempt death for a handful of berries? No. (Thanks for using fear to protect me, amygdala!) However — oh no — Terrible Tigers are chasing me! — I will be torn limb from limb by fearsome fangs — disemboweled by claws! — flesh consumed by unstoppable monsters while yet I live, etc.!!
 
But wait — I have the possibility of jumping to safety, or, at very worst, suffering an instant and relatively painless death on impact at the bottom of the gorge. 
 
I make the jump. 
 
If you look at it like that, then the eventuality of giving up on something you really want to do because "I might not be good enough" might start to look — to both of your brains — like a fate worse than failing. 
 
**Option A**: Everyone hates you, you're not good enough, so you'd better sit at home in the dark and not ever try because you might not end up internationally recognized for your contribution. 
 
**Option B**: Everyone hates you, you're not good enough, so what the fuck is holding you back now, you might as well have some god-damned fun during your limited time on this planet?! 
 
I realize this might sound a little dire, but it can be surprisingly delightful. Because if you can manage to be OK with the worst, imagine how nice not-the-worst (which your logical brain knows is much more likely) might feel!

#### Try to use your imagination. ***Attention: this is legit.***
 
In his amazing book [*The Body Keeps the Score*](http://www.audible.com/t2/title?asin=B00OAOQJXY&source_code=GO1GB907ESH060513&mkwid=sJaI3gajQ_dc&pcrid=152669695569&pmt=e&pkw=the%20body%20keeps%20the%20score%20book&cvosrc=ppc.google.the%20body%20keeps%20the%20score%20book&cvo_campaign=250472289&cvo_crid=152669695569&Matchtype=e&gclid=CjwKEAjwsLTJBRCvibaW9bGLtUESJAC4wKw1L_uOYwJIZTGMB4Z_wxXcUdVDNmkvEBpfhtly1sIGlRoCX7Xw_wcB), trauma expert Bessel van der Kolk (M.D.!) talks about how PTSD sufferers often lose access to their imaginations. Their world becomes flat and grey, defined by fear and avoidance. Self-doubt is fear; it exists in a dark place where there are no dreams, bubbles, flowers, weird funny coincidences, laugh-out-loud YouTube videos, incredible fashion designers, unbelievable science facts, space mysteries, life hacks, surprising friends... no possibilities other than failure, or — absolute best case scenario, only achievable if you keep your head down and focus all your energy on staying safe — survival. 
 
If you can actively stimulate your imagination, it might help remind that deep-down part of you of what your rational mind already knows: self-doubt is boring. That familiar success-failure dichotomy it tries to promote is untenably one-dimensional. Life is so much more than just good/bad, yes/no, glamorous-lifestyle-as-celebrity-stylist-and-best-selling-cookbook-author/pathetic-shaved-existence-grovelling-for-gruel-outside-the-gates-of-King's-Landing. If you can manage to purposefully activate your imagination in times of self-doubt (again: if it were always easy, this would not even be a problem for anyone ever) you might find that the love and the fear can't coexist.


And that is only the begiiiiiinning….

