+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2017-12-10T13:48:00-05:00"
lastmod = "2017-12-10T21:26:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512930648773/2017-12-10---sq---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-149-copy.jpg.jpg"
primary_image_credit = "The House Without a Christmas Tree, HGO, 2017. Photo: Lynn Lane."
publishDate = "2017-12-10T13:48:00-05:00"
related_articles = ["articles/opera-is-artifice-giulio-cesares-conquest-of-houston.md","articles/its-official-breaking-the-waves-wins-best-new-opera.md","articles/8-contemporary-roles-to-covet.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/lauren-snouffer.md","scene/people/megan-mikailovna-samarin.md","scene/people/daniel-belcher.md","scene/people/heidi-stober.md"]
short_description = "Rarely have I ever been able to use the word &quot;effervescent&quot; to describe performances of newly-composed operas, but that is exactly the word I used to describe this one upon its conclusion. This work came as a breath of fresh air. It did not try overly hard to be anything other than a setting of a good story which happened to be set at Christmastime, and that is precisely why I perceive this work as having longevity."
slug = "seasonal-opera-done-right-at-hgo"
title = "Seasonal opera done right at HGO"
+++

In their so-far three-year odyssey of Christmas opera commissions, [Houston Grand Opera](/scene/companies/houston-grand-opera/) has finally managed to unearth that elusive commodity: a modern opera set around the holiday season that inherently possesses at least a modicum of universality and staying power. For though their stated goal of finding the exact equivalent of Pyotr Tchaikovsky's immortal ballet *Shchelkunchik* may well be ambitious and unrealizable without a dedicated aristocracy, yet Ricky Ian Gordon's newest opera, [*The House without a Christmas Tree*](http://www.houstongrandopera.org/the-house-without-a-christmas-tree), is indeed a greatly heartwarming piece, which is ultimately what matters for audiences accustomed to cinema, and a greatly sophisticated one, which is what matters for connoisseurs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512930759393/2017-12-10---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-170-copy.jpg.jpg)
<figcaption>Heidi Stober (Adelaide Mills), Patricia Schuman (Grandma Mills), Lauren Snouffer (Addie Mills), Daniel Belcher (James Addison Mills III, "Dad"), and the HGO Juvenile Chorus, in *The House Without a Christmas Tree*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

Indeed, I was in the audience for when the company first tried its experiment with Iain Bell's one-man setting of *A Christmas Carol* in 2014, and I had wondered if they had any notion of who their audience was: for the oppressive and funereal music of that show had given the impression as if the Ghost of Christmas Yet to Come was omnipresent throughout. All hints of levity felt completely artificial in that context. I was entirely skeptical if they understood the point of the holiday season at all. 

When *The House without a Christmas Tree* came around this year, therefore, I was glad for it to have been based on a story that actually worked as a dramatic setting in the form of a 1972 movie. I was also intrigued to see what Ricky Ian Gordon, a composer generally known in the vocal world for art songs that have a vague aroma of musical theater, would bring to the operatic table. Rarely have I ever been able to use the word "effervescent" to describe performances of newly-composed operas, but that is exactly the word I used to describe this one upon its conclusion. This work came as a breath of fresh air. It did not try overly hard to be anything other than a setting of a good story which happened to be set at Christmastime, and that is precisely why I perceive this work as having longevity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512930918100/2017-12-10---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-110-copy.jpg.jpg)
<figcaption>Daniel Belcher (James Addison Mills III), and Heidi Stober (Helen Mills) in *The House Without a Christmas Tree*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

The prose libretto by [Royce Vavrek](/scene/people/royce-vavrek/), employing much vernacular which will ensure this is indeed regarded as an American opera, was quite well-crafted and well-suited to musical setting, to the extent that I would not have known that it was derived from the 1972 movie of the same name had the publicity campaign not been specifically geared toward that end. The fact that I was able to follow the text without the supertitles was extremely gratifying. Granted, the storyline was dated and on the sentimental side, but those were both reasons that this opera captivated me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512930985323/2017-12-10---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-5-copy.jpg.jpg)
<figcaption>Heidi Stober (Adelaide Mills), and HGO Supernumeraries in *The House Without a Christmas Tree*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

The cast is small and well-suited to avoid confusing audiences for whom this might be a first operatic outing, which is the public I suspect HGO has been trying to attract this time around. Soprano [Lauren Snouffer](/scene/people/lauren-snouffer/) was brilliant and utterly engaging as an adolescent Addie Mills, entirely convincing us of being only slightly addle-brained. However, her aria toward the beginning, in which she pleads with her father (baritone [Daniel Belcher](/scene/people/daniel-belcher/)) for a Christmas tree at last, regrettably suffers from the faults so common in new operatic arias: namely, it is not perceivable as an aria until thirty seconds before the music stops for (slightly confused) applause. 

She and mezzo-soprano [Megan Mikailovna Samarin](/scene/people/megan-mikailovna-samarin/), on whose [Sesto](/opera-is-artifice-giulio-cesares-conquest-of-houston/) I have favorably commented before, made a very good pairing, especially in the highly amusing opening wherein they discourse upon the virtues of ovoid representations of their teenage crushes. In various interjectory supporting roles were members of the Houston Grand Opera Juvenile Chorus, whose individual enthusiasm was variable; nevertheless, this opera made me very interested in seeing such scoring choice repeated again in future. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512931065978/2017-12-10---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-42-copy.jpg.jpg)
<figcaption>Lauren Snouffer (Addie Mills), Maximillian Macias, Billy Wild, and the HGO Juvenile Chorus in *The House Without a Christmas Tree*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

Soprano [Heidi Stober](/scene/people/heidi-stober/), whose [Cleopatra](/opera-is-artifice-giulio-cesares-conquest-of-houston/) had likewise been well received, played multiple roles, including the mature Adelaide Mills in the prologue and epilogue, the ghost of Addie's mother, and Miss Thompson, Addie's schoolteacher. In these she managed to shift between roles so adroitly that one rightly wonders how costumes could ever be changed so quickly along with their characters. Soprano Patricia Schuman did a splendid job in naturally portraying Addie's Grandma, who must be in turns sympathetic and assertive. The aforementioned Daniel Belcher was a very assertive Dad in this story which challenges his perceptions in the world in which he lives: he certainly makes visible the struggle of his character to come to terms with his daughter's maturity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512931074237/2017-12-10---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-16-copy.jpg.jpg)
<figcaption>Megan Mikailovna Samarin (Carla Mae), Patricia Schuman (Grandma Mills), and Lauren Snouffer (Addie Mills) in *The House Without a Christmas Tree*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

Gordon's fluency in orchestration and adroitness at using different styles contributed in large part to the success of this performance, whose orchestra numbered approximately twenty people. While the evocative opening was marked by expansive sonorities alla Copland, many of the more sprightly moments were marked by nimble brass, in a manner which will remind the attentive listener of Poulenc, particularly the good-humored trumpet playing. The schoolhouse immediately sounded more learned by contrast, though opportunities for fugues were passed up, alas. And never let us forget the nostalgic waltz tune between Mr. and Mrs. Mills which is apt to remind operetta lovers of the immortal Léhar, or musical theatre lovers of Bernstein. There were numerous sections where the composer enjoyed pitting the various consorts off against each other. The strings were very effective at conveying a shimmering tone in such moments to contrast with the winds, despite their small number which made supporting the full orchestra quite the challenge on their part. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512931085953/2017-12-10---hgo---the-house-without-a-christmas-tree---2017---photographer-lynn-lane-72-copy.jpg.jpg)
<figcaption>Megan Mikailovna Samarin (Carla Mae), Lauren Snouffer (Addie Mills), and the HGO Juvenile Chorus in *The House Without a Christmas Tree*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

Overall, the music sounded undisturbed by any sort of gratuitous dissonant effects, which helped the orchestra cohere as an accompanying ensemble that supported and did not distract from the stage. One way in which this effect was achieved was through Gordon's inclusion of an entirely original Christmas carol, "Gather Round the Christmas Tree," which is heard in various ingenious forms throughout. One which particularly caught my attention juxtaposed this carol in common time against a waltz, an effect so unique that I have only otherwise heard it in Glinka's 1836 magnum opus *A Life for the Tsar*.

All in all, this opera deserves to be seen as no mere holiday entertainment, but as a genuine and heartfelt masterwork which has in it a life well beyond this performance. Whether or not some Beethovenian genius will make "Gather Round the Christmas Tree" into the basis for some magnum opus alla Diabelli's waltz will remain to be seen. But the point remains that this show was entirely an example of opera's power to inspire even the hardest of hearts, in real life as on stage.

>[The House Without a Christmas Tree](http://www.houstongrandopera.org/the-house-without-a-christmas-tree) is onstage through December 14. For details and ticket information, [click here.](http://www.houstongrandopera.org/the-house-without-a-christmas-tree)
