+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2017-10-08T23:02:00-04:00"
lastmod = "2017-10-08T23:32:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507518563006/2017-10-09---square---Quinn-Kelsey_RIGOLETTO_LYR171004_175_c.Todd-Rosenberg.jpg.jpg"
primary_image_credit = "Quinn Kelsey in the title role of Rigoletto, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg."
publishDate = "2017-10-08T23:26:00-04:00"
related_articles = ["articles/in-review-rigoletto-at-eno.md","articles/the-price-of-vengeance-rigoletto-at-roh.md","articles/great-music-distracting-sexuality-rigoletto.md","articles/piotr-beczala.md","articles/verdis-tragedy-in-jest.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/quinn-kelsey.md","scene/people/matthew-polenzani.md","scene/people/rosa-feola.md","scene/people/zanda-svede.md"]
short_description = "Here is when a reviewer typically starts reaching into his bag of superlatives, but at the risk of hyperbolizing, Kelsey&#039;s performance sets a new standard. At just 39 years old, the Ryan-Opera-Center-alumnus looked and sounded every bit the part of a father aged and disfigured by paranoia, disillusionment, and delusion."
slug = "searching-for-superlatives-locs-suberb-rigoletto"
title = "Searching for superlatives: LOC&#039;s suberb Rigoletto"
+++

Last month, The Lyric Opera of Chicago kicked off its 2017/18 season with an auspicious Gluck's [*Orphée et Eurydice*](/orphee/). An unforgettable new production—marking LOC's first collaboration with Chicago’s famed Joffrey Ballet, it was recently recorded by PBS to be broadcast as part of their Great Performances series. 

With this month's [*Rigoletto*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/rigoletto-opera-tickets), LOC continues to astound, delight, and move.

A colleague of mine once posited that one of the differences between French and Italian operas is that French opera is like diamond-cut glassware: though visually stunning, the intricate engravings can also distract from any minor nicks or imperfections. Italian opera, however, is like a fine crystal wine glass, the smallest hairline crack can disturb its aesthetics; the purity of the vessel serves the qualities of its contents. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507518750430/2017-10-09---RIGOLETTO_2_c.Andrew-Cioffi.jpg.jpg)
<figcaption>*Rigoletto*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

Taking in LOC's *Rigoletto* last night, the simile struck me as apt, yet like a bumbling wannabe oenophile, I found myself grasping for adjectives and metaphors (see above) to describe what was simply a superb experience.

Priority of mention must go to the core trio of singers, beginning with the baritone [Quinn Kelsey](/scene/people/quinn-kelsey/) in the title role. Here is when a reviewer typically starts reaching into his bag of superlatives, but at the risk of hyperbolizing, Kelsey's performance sets a new standard. At just 39 years old, the Ryan-Opera-Center-alumnus looked and sounded every bit the part of a father aged and disfigured by paranoia, disillusionment, and delusion. From the moment he appeared in the opening scene, hobbling cynically and spouting insults at the courtiers, to his final agonizing cry, "La maledizione!" ("the curse!") — himself now the victim of that same cynicism — Kelsey's *Rigoletto* was heartbreaking to see and captivating to hear. Particular highlights included his powerhouse Act 2 aria, "Cortigiani, vil razza dannata," as well as his touching final duet with the dying Gilda. The range Kelsey displayed was that of an artist fully in command of his instrument. Listening to Kelsey, I was reminded of some of the great Rigolettos of the past, such as Sherrill Milnes, with similar dramatic inflections and chiseled phrases. Kelsey's voice, dark and sonorous, was marked for qualities of its own and lost no nuance in the immense hall of the Civic Opera House.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507518729159/2017-10-09---Quinn-Kelsey_RIGOLETTO_LYR171004_081_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Quinn Kelsey in the title role of *Rigoletto*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

Singing opposite Kelsey in the role of Gilda, the jester's sheltered daughter, was the Italian soprano Rosa Feola, making her LOC debut. And what a spectacular debut it was! Feola met the expectations of the role immaculately with a crystalline coloratura and engrossing stage presence. This was an artist of supreme musical intelligence. "Caro nome," the opera's showcase soprano aria, was shaped with such a sense of style and finesse that gave this warhorse a freshness and immediacy that eludes most. Hers were not merely vocal pyrotechnics, but the pining sighs of youthful love (that is, lust). Feola has made Gilda something of a specialty, having performed the role previously at the Zurich Opera House and Turin's Teatro Regio. The experience of living with such a role certainly showed in her performance in Chicago. Feola captured the tragedy of Gilda’s existence with a disarming simplicity; one couldn’t look away while she was on stage. She was rewarded with a long, exuberant, and deserving ovation.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507518810351/2017-10-09---Quinn-Kelsey_Rosa-Feola_RIGOLETTO_LYR171004_257_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Quinn Kelsey (Rigoletto) and Rosa Feola (Gilda) in *Rigoletto*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

Tenor [Matthew Polenzani](/talking-with-singers-matthew-polenzani/) turned up the creep factor in his portrayal of the womanizing Duke of Mantua. His singing, though, was irresistible. Brash and bro-ish in demeanor, in voice he was clear and cutting, with a purity of expression that was truly mesmerizing. It was a conflicting experience to see Polenzani's Duke: sweet to hear, but uncomfortable to see. And I don't mean that in any pejorative sense for this is precisely who the Duke is — the personification of deceitful seduction. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507518910650/2017-10-09---Whitney-Morrison_Matthew-Polenzani_RIGOLETTO_LYR171004_069_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Whitney Morrison (Countess Ceprano) and Matthew Polenzani (Duke) in *Rigoletto*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

For the famous Act 3 quartet, "Bella figlia dell'amore," the protagonists were joined by the Latvian mezzo-soprano Zanda Švēde who sang Maddalena, the assassin Sparafucile's accomplice and sister. Švēde (also making her Lyric debut) added a superb velvety core to an ensemble of some pretty brilliant voices. 

The LOC orchestra sounded in top form last night. Guest conductor Marco Armiliato shaped the  work with magnificent sweep while also coaxing exquisite colors and refinements from the musicians. The whole orchestra breathed together with the singers on the stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507518979415/2017-10-09---Quinn-Kelsey_Rosa-Feola_RIGOLETTO_140_c.Andrew-Cioffi.jpg.jpg)
<figcaption>Quinn Kelsey (Rigoletto) and Rosa Feola (Gilda) in *Rigoletto*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

It can be trendy to sneer at classic favorites like *Rigoletto*, yet a production like the Lyric's reminds us why we keep returning to hear them: theirs is artistry and musicianship at the highest level, captivating and inspiring. If you’re in Chicago, don't miss [LOC's *Rigoletto*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/rigoletto-opera-tickets), which runs until **November 3**.
