+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2018-11-29T12:07:00-05:00"
lastmod = "2018-11-29T19:42:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543524050768/sqOpenChambers-3.jpg.jpg"
primary_image_credit = "Rachel Krehm and Vadim Serebryany in Open Chambers, Opera 5, 2018. Photo: Dahlia Katz."
publishDate = "2018-11-29T15:41:00-05:00"
related_companies = ["scene/companies/opera-5.md"]
related_people = ["scene/people/rachel-krehm.md","scene/people/jacqueline-woodley.md"]
short_description = "Hansen is a lover of chamber music, but is less enamoured with the traditional setting of chamber music performances. He writes in his director&#039;s notes, &quot;Audiences understand they&#039;ll arrive to a venue and see chairs set out awaiting the musicians, organized along very standard and - let&#039;s just say it - totally uninspired, predictable placements so that the musicians can see and hear each other.&quot;"
slug = "scattered-symbols-in-opera-5s-open-chambers"
title = "Scattered symbols in Opera 5&#039;s Open Chambers"
+++

Toronto-based indie opera company [Opera 5](/scene/companies/opera-5/) has launched its first expanded season, making room among their mainstage operatic productions for chamber music. Their inaugurual iteration of [*Open Chambers*](http://opera5.ca/openchambers/) was a staging by Patrick Hansen of Paul Hindemith's Oboe Sonata and *Die Serenaden* for soprano, oboe, cello, and viola, and of Shostakovich's *Seven Romances on Poems of Alexander Blok, Op. 127*.

Apart from the Oboe Sonata - which I fondly remember from my university years - the programme was unfamiliar. Sharing the singing were sopranos Rachel Krehm and Jacqueline Woodley; Woodley's bell-like warmth found a powerful foil in Krehm's steely, almost fearsome sound. Woodley was well-suited to Hindemith's *Die Serenaden*, with its transparency and delicate details; and Krehm found space for her powerful instrument in the shocking expanse of Shostakovich's Russian settings.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543523819763/OpenChambers-13.jpg.jpg)
<figcaption>Jacqueline Woodley in *Open Chambers*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

The ensemble was deft. Oboist Melissa Scott put personality into Hindemith, and cellist Wolfram Koessel played with a fallible, chameleonic sound. I was particularly drawn to the clarity and power in pianist Vadim Serebryany, and the enormous colour palette of violist/violinist Yosuke Kawasaki.

Hansen is a lover of chamber music, but is less enamoured with the traditional setting of chamber music performances. He writes in his director's notes, "Audiences understand they'll arrive to a venue and see chairs set out awaiting the musicians, organized along very standard and - let's just say it - totally uninspired, predictable placements so that the musicians can see and hear each other."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543523813405/OpenChambers7.jpg.jpg)
<figcaption>Jacqueline Woodley and Wolfram Koessel in *Open Chambers*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

Hansen's staging had me wondering, "what does it all mean?" Mildly surrealist, it reminded me of David Lynch, or maybe Salvador Dalì's design for the dream sequence in Alfred Hitchcock's *Spellbound*. The intimate space at Factory Theatre was filled with suspended picture frames and splashes of red roses and white orchids. Koessel briefly exchanged his cello for a singing Jacqueline Woodley. We saw silent displays of grace, the giving of a bouquet of flowers, the offering of a musical instrument.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543524006490/OpenChambers-6.jpg.jpg)
<figcaption>(l-r) Jacqueline Woodley (background), Rachel Krehm (background) and Yosuke Kawasaki in *Open Chambers*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

Hansen took the symbols of traditional chamber music performances - instruments, music stands, black concertwear, a red gown for the singer, and scattered them, turned on their heads. All six artists spent the hour-long programme either playing and singing, finding an unexpected place to have a seat, or walk up to a hanging picture frame to become, momentarily, a curious portrait.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543523795727/OpenChambers12.jpg.jpg)
<figcaption>(l-r) Yosuke Kawasaki, Jacqueline Woodley (background), Vadim Serebryany (background), Rachel Krehm, and Wolfram Koessel in *Open Chambers*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

The music didn't suffer for Hansen's unorthodox staging, but it didn't help me hear more clearly. It's true that there is a tradition, perhaps uninspired, of chamber musicians' perfunctory onstage habits - tuning, shuffling of chairs and music stands, and some level of perceived indifference to their audience. Yet there's a broad spectrum between "uninspired" and "simple"; the former comes out of stagnancy and a lack of innovation, and the latter comes out of finding the fewest obstructions to making excellent music (things like the musicians' being able to see and hear each other).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543523779092/OpenChambers1.jpg.jpg)
<figcaption>Jacqueline Woodley in *Open Chambers*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

I did walk away from the evening wanting to know more about these works of Hindemith's and Shostakovich's, and certainly wanting to hear more from Serebryany and Kawasaki. And though visually, this *Open Chambers* felt a bit superfluous, a parade of upended symbols, the music-making went on unobstructed. I wonder, if this staged night of chamber music was solving not problems, but personal preferences.

>*Open Chambers* runs at Factory Theatre through December 1. For details and tickets, [click here.](http://opera5.ca/openchambers/)
