+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-07-13T20:01:00-04:00"
lastmod = "2018-07-20T16:53:00-04:00"
preamble = "What does Canadian music sound like? It's a question that the members of [Ensemble Made in Canada](https://www.ensemblemadeincanada.com/mosaique-project/about-the-project/) address with their newly commissioned [Mosaïque Project](https://www.ensemblemadeincanada.com/mosaique-project/about-the-project/), a suite for piano quartet written by 14 different Canadian composers who make a musical nod to a particular province, territory, or region of the country.\n\nSinger-songwriter Sarah Slean is one of these 14 composers, and her part of the Musical Mosaïque evokes the spirit of Newfoundland. We spoke with Slean about her musical aesthetic, and what it means to be a part of this very Canadian project."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531526393387/sqsarahslean_promophoto_blazer_credit-david-leyes.jpg.jpg"
primary_image_credit = "Photo: David Leyes."
publishDate = "2018-07-20T16:53:00-04:00"
related_articles = ["articles/canada-sounds-like-mosaque-project.md", "articles/darren-sigesmund-on-the-mosaque-project.md", "articles/nicole-lize-on-the-mosaque-project.md"]
short_description = "&quot;It&#039;s always a treat writing music for master musicians and I&#039;m thrilled to be in the company of such great composers, but I&#039;m especially honoured to be part of this project, I think it&#039;s ambitious and timely and a beautiful tribute to Canada.&quot;"
slug = "sarah-slean-on-the-mosaïque-project"
title = "Sarah Slean on the Mosaïque Project"

+++
## What does it mean to you to be one of the 14 composers creating this musical mosaïque?

It's always a treat writing music for master musicians and I'm thrilled to be in the company of such great composers, but I'm especially honoured to be part of this project, I think it's ambitious and timely and a beautiful tribute to Canada. 

### What possibilities do you hear in the piano quartet ensemble? How will you approach composing for the Ensemble Made in Canada?

With the level of musicianship in this ensemble, it's really a vast palette of sonic possibilities, so I focused instead on how to evoke the spirit of Newfoundland in a unique, non traditional way. 

I have spent a lot of time in Newfoundland, and I love the light-hearted humour of Newfoundlanders - which stands in a kind of perfect balance to their profound natural compassion. I wanted to create musical figures that could capture that. The character Jonny Pippy (the Pouch Cove man who inspired this piece) seems to embody these - at times he was all jovial activity, riding around on his bike in the bay, greeting tourists, speaking with the locals - and at other times he was lost in contemplation looking out at the sea… these moods would wash over him in a sudden, mercurial way… much like the weather there…  

## What message or statement do you hope to bring to this multi-genre musical suite?

Hmm. Perhaps that genre is arbitrary, and music is music. The hard line drawn around classical music serves no one. 

### What do you think are some misconceptions Canadians may have, or assumptions they may make about where you're from, and your musical style? How do you hope to clearly represent yourself?

I chose the province of Newfoundland because I have some familial roots there, and I have chosen to write in a small town called Pouch Cove several times over the years. I love that place and I think there is so much more to it than the stereotypes.  I have no desire to represent myself in this music - my aim was to write something in honour of place that made a very positive and lasting impression on me.  It's a place with astonishing natural beauty and some fascinating people.  There is a powerful spiritual presence on "the Rock" because the land and the weather dominate all human endeavour.  There is an enforced deference to the largeness of nature and its power. Human hubris has zero chance in that kind of climate. So the people are humble, real, and for the most part have learned to be in harmony with their surroundings.

<figure data-type="video">
<iframe width="640" height="360" src="https://www.youtube.com/embed/-RH9dBTW_kQ" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

>For full details about the Mosaïque Project, and to follow its tour dates across Canada, visit [Ensemble Made in Canada's website](https://www.ensemblemadeincanada.com/mosaique-project/about-the-project/). To meet the other composers, check out this [YouTube playlist](https://www.youtube.com/watch?v=-RH9dBTW_kQ&list=PLFwYc7IVissZ0owB13vtwEFtu6Q8ymUEw).