+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-03-17T16:15:51+00:00"
disclaimer = ""
image_gallery = []
postamble = "Sarah Connolly returns to Wigmore Hall on 24 April, 2019. For details and tickets, [click here](https://wigmore-hall.org.uk/whats-on/dame-sarah-connolly-robin-tritschler-malcolm-martineau-201904241930)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1552839420/media/2019/03/sqSarahConnollyJanCapinski.jpg"
primary_image_credit = "Photo: Jan Capinski."
related_articles = ["articles/in-review-jamie-barton-at-wigmore-hall.md", "articles/at-arms-length-goerne-hinterhauser-in-recital.md"]
related_companies = []
related_people = ["scene/people/sarah-connolly.md"]
short_description = "Connolly, whose prolific contribution to classical performance over the course of her career - a career that has now made her a household name - garnered palpable excitement from the audience from the moment she walked on stage. She carries a sense of poise and authority as a performer, yet showed great vulnerability."
slug = "greater-than-the-sum-of-its-parts-sarah-connolly-at-wigmore-hall"
title = "Greater than the sum of its parts: Sarah Connolly at Wigmore Hall"
youtube_url = ""

+++
So often song recitals can feel disjunct; a gratuitous show rather than a well-crafted and meaningful reflection. Not so with this recital featuring works by Zemlinsky, Schumann, and Argento given by Wigmore Hall's Artist in Residence this year, Dame Sarah Connolly and Julius Drake. This was a fastidiously perfected programme which centred around storytelling from the female perspective and did so in a way that was uniquely contemplative.

>She carries a sense of poise and authority as a performer, yet showed great vulnerability.

The programme began with Zemlinsky's _Sechs Gesänge_, setting an initial quiet and introspective mood. But these pieces have great range and built to dazzling climaxes through sweeping, romantic phrases. There was something of early Berg in them and just a hint of Mahler, which is to be expected as Zemlinsky was hugely influential in the music scene in Vienna; he taught Schonberg, Webern, Korngold, Berg, and Alma Mahler. Premiered in two batches in 1910 and 1913, the text was selected from _Quinze Chansons_ by Maurice Maeterlinck and translated into German. Though originally composed in French, there is something that feels inherently Germanic about these pieces. Perhaps it is the harmonic turbulence with which Zemlinsky set them, or perhaps it is the dark and heavy folkloric nature of the text that lends itself well to the German language. Thematically, they centre around the trials of women taking on quite a macabre tone.

Connolly, whose prolific contribution to classical performance over the course of her career - a career that has now made her a household name - garnered palpable excitement from the audience from the moment she walked on stage. She carries a sense of poise and authority as a performer, yet showed great vulnerability. It was a sensitive, carefully contrived performance that featured her versatility, and subtlety of her instrument. Drake pulled a multitude of colours from the score, taking every opportunity for word painting and the two formed a seamless partnership, at times melding into one. These are beautiful, accessible pieces I would love to hear more often and to see included in what is generally considered to be the canon of German lied.

>It is rare for a singer to have to share the audience's attention in a recital setting. This was a unique opportunity to share the responsibility of storytelling with another performer.

Following the Zemlinsky was Schumann's favoured _Gedichte der Königin Maria Stuart_ which was aided in performance by the addition of text recited by actress Emily Berrington. The text for these readings was devised by Laura Tunbridge and based on Schiller's 1800 play _Maria Stuart_, perhaps the most celebrated dramatic rendition of the venerated tale. Interestingly though, Schumann's text was not based on the Schiller. It instead, was taken from a collection assembled and translated by Gisbert Freiherr Von Vincke and tells a slightly different account of events. It is doubtful that any of these poems chosen by Schumann were Mary's own words, many of them having been mistakenly attributed to her, but this does not make the poems nor Schumann's settings any less meaningful or valid.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552839783/media/2019/03/SarahConnollyPeterWarren.jpg){{% /md %}}

<figcaption>Sarah Connolly, mezzo-soprano. Photo: Peter Warren.</figcaption>

</figure>

Generally, I think these cross-arts productions which employ the use of actors, dancers, or visual elements to further the performance are an inventive and successful way to approach the modern song recital. It is not that the singer is not captivating enough on her own, but the use of the spoken text really assists the music by adding depth and context. The recited text filled in some of the important gaps in a story of a life that is otherwise quite fragmented. However, in this case I found myself wishing that the choice had been made for the text to be memorized. I know that depending on the rehearsal process this can sometimes be a big ask, but I found the presence of the script, distracting. The text between songs was often quite long and though spoken expertly by actress Emily Berrington, I found myself disconnecting from her words from time to time because I felt that she was reading rather than portraying the character. Perhaps this was the intention, but I think more could have been gained from a fully integrated performance.

>The emotional ups and downs are very indicative of real life and I found this to be extremely relatable and touching.

Having said that, Connolly somewhat faded into the background for me in this set and I found most of my attention was instead focused on Berrington. Connolly's sense of the character paled in comparison. This subtle and contemplative performance may have simply been her artistic take on the work, but it felt like a significant drop in energetic engagement. Perhaps this is what the performance was calling for. It is rare for a singer to have to share the audience's attention in a recital setting. This was a unique opportunity to share the responsibility of storytelling with another performer which I felt Connolly did very graciously.

>Here the focus was on thought-provoking storytelling and intelligent programming.

A beautiful tribute to the late composer, Argento's _From the Diary of Virginia Woolf_ was performed in the second half of the concert. Premiered in 1975 by Dame Janet Baker for whom the set was written, the eight pieces take snippets from Virginia Woolf's diary from 1919 up to her last entry in 1941. Interspersed with the songs was text put together by Kate Kennedy, compiled from Woolf's diaries and writings. Kennedy focused on Woolf's connection to music as a theme for these texts. The addition of the text was extremely effective in that it was mostly light-hearted and even funny nature which contradicted the growing morose and reflective mood of the songs. This spoke to her decent into depression eventually leading to suicide and to the inscrutable and unpredictable nature of mental illness. The emotional ups and downs are very indicative of real life and I found this to be extremely relatable and touching. It was a beautiful addition to the set and created a dramatic and emotional piece of theatre. Connolly and Berrington were two sides of the same coin, each taking on a different aspect of Woolf's character, while perfectly embodying her spirit. Argento's thematic music continuously cycled back on itself, returning to the theme of the first piece in the final one, giving us a sense of scope, of completion, and of the futility and the grandeur of this one woman's life.

It was a joy to watch such an accomplished duo take on this very exciting programme and breathe so much life and intention into it. The dwindling art form of the song recital is calling out for innovation. Here the focus was on thought-provoking storytelling and intelligent programming, creating a performance that was greater than the sum of its parts.