+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2018-11-29T19:55:00-05:00"
lastmod = "2018-11-30T14:54:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546222659/media/2018/12/sqTRUCE.jpg"
primary_image_credit = "San Diego Opera presents All is Calm: The Christmas Truce of 1914, a co-production with Bodhi Tree Concerts and SACRA/PROFANA, December 7, 8, and 9m, 2018. Part of the Detour Series. Illustration by Scott McKowen."
publishDate = "2018-11-29T20:53:00-05:00"
related_articles = ["articles/talking-with-composers-david-t-little.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
short_description = "&quot;In Turandot, that we did last year, or in All is Calm, the expressive potency of the human voice is the commonality. The spoken word is expressive too because it uses the human voice. It has music, it has rhythm, it has form, and it has pitch – all the things that some music does, but just that it is spoken. That is the dramatic glue to this piece.&quot;"
slug = "san-diego-opera-takes-a-detour-with-all-is-calm"
title = "San Diego Opera takes a detour with All is Calm"

+++
San Diego Opera, Bodhi Tree Concerts and SACRA/PROFANA are presenting [*All is Calm: The Christmas Truce of 1914*](https://www.sdopera.org/season/2018-2019-season/all-is-calm), a choral opera, on December 7, 8, and 9, 2018 at the Balboa Theater in San Diego. All is Calm is an acapella opera told through first-hand accounts of a moment during World War I when soldiers from France, the U.K., and Germany took a break from fighting in the trenches around the Christmas holiday and shared food, exchanged gifts, buried their dead, and sang Christmas carols. *All is Calm* was created by Theater Latté Da’s artistic director, Peter Rothstein, with musical arrangements by Erick Lichte and Timothy C. Takach. Juan Carlos Acosta, the Artistic Director of SACRA/PROFANA, a professional Chamber Choir, will be conducting. Walter DuMelle co-founded Bodhi Tree Concerts, which presents music events exclusively with local artists and donates the profits to charitable causes is also singing in the opera. *All is Calm* is being presented as part of San Diego Opera's Detour series, comprised of productions and works outside of traditional grand opera.
 
I sat down with David Bennett, General Director of San Diego Opera, Juan Carlos Acosta, conductor of *All is Calm* and Artistic Director of SACRA/PROFANA, and Walter DuMelle, Co-Founder of Bodhi Tree Concerts, and singer in the opera, for a discussion of *All is Calm* and how it compares to traditional opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543539516362/TruceCollage.jpg.jpg)
<figcaption>(clockwise from top left) Walter DuMelle, Co-Founder of Bodhi Tree Concerts, David Bennett, General Director of San Diego Opera, and Juan Carlos Acosta, conductor of *All is Calm*.</figcaption>
</figure>
 
#### Is it a challenge to tell the story of *All is Calm* as an *a capella* opera rather than as a more narrative story like Kevin Puts' *Silent Night*?
 
**Walter DuMelle**: The story telling works in its simplicity and its directness. From a dark and silent stage, you hear a lone voice start to sing "Will ye go to Flanders", an old tune, but a song of men going off to war. These songs are very direct and personal as are the letters, all written by actual soldiers on the front, writing home from the trenches, with newsreels of the day. It is all real and very personal story telling. Even if it is not one single narrative where you follow the characters throughout, the story telling is so direct and so immediate that it works in a very personal and human way, in a way that telling actual battles of World War I would never be able to.
 
**Juan Carlos Acosta**: One of the things that makes this so poignant is that instead of having a librettist and poet who create beautiful flowery texts to describe the situation and express emotions, the creators of this show have gotten out of the way and let the voice of the soldiers speak for themselves. We are hearing directly from the soldiers. That makes it even more powerful than a traditional narrative story plot. The arrangers have also done a great job of picking the songs that are mentioned specifically in many of these letters or in documents of that time period. 

They have set them *a capella* because, although we know they had some instruments in the trenches, for the most part they were just singing. The simple *a capella* arrangements bring this story to life and really allow the narrative and voice to come out in a way that works very effectively. In most of the letters the soldiers sign off. We know these are real people who wrote them. But it does not name the characters, which in some way reflects the nature of war. These are individuals, but they almost lose their identity within the greater cause. Whether they were intentional or not, all these things make it a powerful experience.
 
**David Bennett**: Typically, in creating a narrative work, you have to select story lines, as done in *Silent Night*, and some relationships that you focus on to drive the narrative. This piece is in effect recreating what happened on that night, several stories, and the commonality is that they all were in war, leaving behind beloved people but hearing music that made them make the decision to lay down their arms. It was in fact *a capella* choral music. It was first almost like a battle of music, which is what made them raise their heads above the trenches. It is that commonality which brought them together. Instead of selecting specific storylines, we really focus on that event and let the real words they wrote home, and the music that was from that period, tell the story.
 
**Walter DuMelle**: The unspoken character in this piece is the energy that is created by 16 virile men singing together *a capella*. It will be a sensation that you will not experience in any other way. Sometimes it is just a melody line and other times it is great eight-part harmony. It is going to be a wall of men participating in this experience together. The sound of the male voice really becomes a character in and of its own, even if you cannot single it out.
 
**David Bennett**: I've heard from other general directors who have produced *Silent Night* that audiences sometimes come away saying they expected to hear the song *Silent Night*. That opera is a fully composed new 20th century work, by a beautiful composer, Kevin Puts, but does not reference Christmas music or military music that we know. Even his setting of *Dona Nobis Pacem* is a new melody. In *All is Calm*, we hear familiar music. That gives audiences music we recognize.
 
#### Everyone loves Christmas music, but what are some of the creative challenges around this piece? How do you make it dramatic? How do you make it more than just Christmas music?
 
**Juan Carlos Acosta**: It is not just Christmas songs. There are a lot of folk songs woven throughout, and early on we get martial music, the patriotic and recruitment pieces that we know in that time period were used to rouse the interest of the young men. That music is woven throughout. In one of the moments that is also the most touching part of the story, the two sides come together, and they hold a burial service for the dead. "Lo, How a Rose E'er Blooming"/"Es ist ein Ros Entsprungen" is sung at that moment. One of the challenges artistically and technically is that it is all *a capella*. There is no orchestra to support you. We are really charging ahead on our own and continuing throughout with that music, but they have done a great job of using a lot of familiar pieces as underscore of text. All of a sudden, you hear a Christmas carol and it goes to the background as a soldier is describing the scene. It works terribly effectively because you are in the trenches and then you hear this music come wafting from the other side. You are hearing this soldier narrate it. It is very effective.
 
**David Bennett**: Thinking about the Mozart's *Le nozze di Figaro* that we just had here in San Diego, recitative is what drove most of the narrative in Mozart's writing. You have arias that are moments of reflection. The music in *All is Calm* is oftentimes moments of reflection. In Mozart's arias you have recitative. In operas like from Kevin Puts, it is usually some symphonic writing that creates the narrative color, that stretches the moments that are between arias and ensembles. We have here a very beautiful thing, the expressive nature of spoken word. It is the spoken word that is the cohesive dramatic glue of this piece. It is not a concert. It is a dramatic work.

In everything we are doing at the opera, we are trying to focus on the expressive nature of the human voice being the commonality. In *Turandot*, that we did last year, or in *All is Calm*, the expressive potency of the human voice is the commonality. The spoken word is expressive too because it uses the human voice. It has music, it has rhythm, it has form, and it has pitch – all the things that some music does, but just that it is spoken. That is the dramatic glue to this piece.
 
### What makes this an opera when you compare it to the more traditional Italian, German, and French opera classics?
 
**David Bennett**: This expands people's definition of what opera is. If you look at operas that are being written today, it is an expansive list. The expressive nature of the human voice is what binds all opera together. Spoken word has been part of opera for a very long time. If you like *The Magic Flute*, then you hear spoken word. Singspiel is a big part of the German tradition. Operetta too is a big part of our tradition. Just the fact that it has spoken dialogue does not invalidate this in any way from us conceiving of it as an opera. Choral music has been a big part of opera from the very beginning. I think it fits very well with our definition at the San Diego Opera today of what opera is.
 
**Walter DuMelle**: In all art, and in opera as well, we are shining a spotlight on an element of the human condition in a way to find connectedness in an experience, whether it is a time in history or human emotion, and this piece does it in spades. It connects us not only to a time and place, but it connects us to each other around camaraderie, around the horrors of war, around the uselessness of war. An opera allows us to heighten that experience in a space, with an audience, with all the elements of theater. Just reading it, or listening to it, or seeing a straight play, may not be able to amp up the volume quite as much emotionally.
 
**Juan Carlos Acosta**: If you look at the word, opera is the plural of opus, which means work. Opera means works. That term was used originally because opera was the grand combination of words and music and scenery and acting and costuming. This is certainly all of those things. In some ways, it is an exciting new take on it because it also involves historical scholarship in a way that many other operas choose not to for artistic reasons, or side step because it is inconvenient. That is one of the really exciting things for me.

### Musicals have some of the elements you mentioned, and this is being performed off-Broadway. Why is this not a musical but an opera?
 
**David Bennett**: I'm going to counter that and say, why not? Because a piece of music is being performed off-Broadway does not mean that in an expansive look at what opera is, it cannot also be considered an opera. I imagine that those who will hear it off-Broadway will say this is not a musical because it has classical music in it. But what they are seeing as classical music is familiar Christmas carols. They will look and say this does not feel like a musical. What is the commonality between the two? It's got spoken dialogue and there is a chorus. It is definitely bridging the gap.
 
**Juan Carlos Acosta**: From a technical standpoint, a lot of people make a delineation because of vocal technique. They use a musical theater type of vocal production. We are doing an operatic, or more classical, concept for the sound. This is one of the technical differences, the technical approach, that can pinpoint it. It does not invalidate the way they sing at all. It is just different. One of the most encouraging and beautiful things I have seen in the world of classical music has been that the walls between genres are coming down. That is an incredibly powerful and important thing for the survival of our art forms. 

But also, there have been artificial barriers that say if you do this you can't do this. Or certain people don't have access to this. It is really important that we always examine what is and why is opera important. Part of it is helping to define what opera is and also to break down those genres, to say that just because you think you do not like opera, it does not mean you do not like every opera ever written. It is important, and it is one of the things David Bennett has done really well. Producing this piece of music theater in this setting is going to be very helpful for that.
 
**David Bennett**: Jeanine Tesory has written a very successful musical, *Fun Home*, and she also was commissioned by Glimmerglass Opera to write an opera. She is really a genre bending composer. If you look at anyone that is at the forefront of composition and opera today, every one of them has tons of musical references in their vocabulary. They have all grown up with all of these references, music theater being one of them - Choral music, 20th-century music, rich different Renaissance music. There is an opera composed by Gregory Spears called Fellow Travelers, a big success in Cincinnati, NY, and Chicago where he references troubadour singing in his 21st-century vocabulary. All of these elements show up in the work of contemporary composers. We did David T. Little's *Soldier Songs* here in San Diego two years ago. There is always a lot of electronic and rock music in his compositions because that is what references him. Walls are becoming porous and they are going to continue doing so. As music advances forward, it is going to reference things that have been in the composer's ear. That is going to influence their vocabulary.
 
**Walter DuMelle**: Lest we forget, in Offenbach's day or in Mozart's day, they were the rock stars. Their opera was the big deal. To put the walls up really is a reaction or result of history. Offenbach was making political and social references that would have been on the tongues of every single person in the Parisian streets, not just the few that chose to go to the opera house. If you can sing the material and deliver it in a way that is dramatically compelling, I think we should all be able to go to all kinds of music theater.
 
**David Bennett**: Since I've been here, I've also been saying let's not forget that opera is theater. During my first summer here, I saw a lot of music theater because we were dark and there was a lot of music theater, and theater in general, going on. One critic, after seeing me for the seventh or eighth time, said he couldn't believe how much theater I was seeing. I said opera is theater. I don't know why I wouldn't see those pieces.

**Juan Carlos Acosta**: One of the exciting composers in opera right now is Nico Muhly, who just had a piece performed at the Met, which is probably, for many people, the most orthodox of opera companies in the world. Nico Muhly shares a creative space and studio with independent composer and pop artist, Sufjan Stevens. They have released a pop album together. Sufjan composes and plays oboe and trumpet on his own album. The idea there is a divide is artificial. In many ways we're just getting a corrective look at that.
 
#### Is having a work like this going to bring in audiences that are maybe younger and maybe more attracted to this kind of music to explore more traditional opera as well? Or should we just let traditional opera go?
 
**David Bennett**: That is one of our hopes with the Detour series. As we expand people's perception of what the experience of opera is, it is discovery and not just expansion - of things like repertoire, venue, composers, artists, and all of that. It may be a different brand and people may not crossover and go back to our mainstage [opera] series but they may. It is our hope that they will after they have experienced something and really liked it, because they found it dramatically compelling and engaging. They will want to try it. We have anecdotal data – it is fairly new, and we are in our third year of detour now – and we see that people are now buying tickets to the mainstage that found their way to us through the Detour series. They purchased Detour tickets and subsequently are now buying mainstage. Whether that will stick over the years we don't know but it's a great thing if it happens. If not, as some people like Coke and some people like Diet Coke as a preference, they may not cross over. But it is our hope that they will.

**Walter DuMelle**: It is also a great opportunity not only for audience building but experiencing theater, no matter how you do it, and no matter where you do it. We definitely need to water that garden. The Detour series is a great way of saying to a very broad audience base that this is going to be good. It is not only going to be fun, engaging, and rich. We can worry if they are going to be buying seats to *Aida*, but getting their butts in their seats in the first place, to engage them in this wonderful genre of compelling music theater that puts the human voice front and forward, whatever the story, whatever the period, you've got to get them there. The idea of the Detour series is doing less familiar venues and not the traditional topics. Maybe more contemporary topics is just the way to do it.

**Juan Carlos Acosta**: The reality is that folks like things they already know. People like familiarity. This piece might provide crossover. They are going to recognize 80% of the music in this piece. Maybe they are going to say this art form is not so scary, maybe it is not so daunting. Regardless of age, young people are unfortunately just as reticent to try new things as seasoned opera goers. Maybe this piece will provide that door to make people think they like it and maybe they'll go to see something else.

The vocal arrangements are intentionally simple through most of *All is Calm*. Compositionally, there's nothing that they have done with the music that listeners from that period would not identify. The one potential exception is when different troops from the different countries sing *Silent Night* in different languages and in different keys. It is perfectly poetic. They are singing their own song in their own language in a different key and there's a discord. As they work through it, that discord becomes harmony. That is also what's going on in the story. That is the one statement the arrangers tried to make and they did it very effectively.

**Walter DuMelle**: Opera is about the human voice and the story telling it can convey. *All is Calm* does it in spades from the very first note of "Will ye go to Flanders" to the final utterance of "Peace on Earth". Everything in between is about the power of how the human voice can take you on a journey. I don't know what else opera does but that.
 
**David Bennett**: That is exactly what I'm trying to convey, the expressive potency of the voice. If you think of opera carrying something that perhaps other forms don't, it is because the voice is inside us. As we express with our voice, we express a part of our human condition and that is really the centerpiece of what this is about in every note that is sung and every word that is spoken. The entire art of this piece is expressed through the human voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543539643894/TRUCEfull.jpg.jpg)
<figcaption>San Diego Opera presents *All is Calm: The Christmas Truce of 1914*, a co-production with Bodhi Tree Concerts and SACRA/PROFANA, December 7, 8, and 9m, 2018. Part of the Detour Series. Illustration by Scott McKowen.</figcaption>
</figure>

>*All is Calm: The Christmas Truce of 1914* runs December 7-9 as part of San Diego Opera's Detour Series. For details and tickets, [click here.](https://www.sdopera.org/season/2018-2019-season/all-is-calm)