+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = 2020-10-08T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1602026180/media/2020/10/sqSDOBoheme_ou64lz.jpg"
primary_image_credit = "La bohème is part of San Diego Opera's 2020-2021 Season. Photo by Yves Renaud, courtesy of Opéra de Montréal."
related_articles = ["articles/aging-magician.md", "articles/talking-with-singers-stephen-costello.md", "articles/talking-with-singers-frederica-von-stade.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = ["scene/people/keturah-stickann.md", "scene/people/ana-maria-martinez.md", "scene/people/joshua-guerrero.md"]
short_description = "“It's going to be like a torpedo of Mimì and Rodolfo's emotional trajectory. There's no pause to reflect. It's going to go straight through from the moment they meet until the end. As a director that's very exciting. It makes us shine a light on some of the emotional aspects that sometimes get glossed over,\" she adds. "
slug = "san-diego-operas-drive-in-la-boheme-a-step-forward"
title = "San Diego Opera's drive-in La bohème a step forward"
youtube_url = ""

+++
"I'm really grateful that San Diego Opera has had the courage to move forward with this," says tenor [Joshua Guerrero](/autobiographical-recitals-joshua-guerrero-in-the-amphitheatre/) about the company's upcoming [presentation of _La bohème_](https://www.sdopera.org/season/2020-2021-season/la-boheme), opening October 24, with additional performances October 27, 30, and November 1, 2020. This production of Puccini's opera will stand out for many reasons, not least for its star singers, [Ana María Martínez](/scene/people/ana-maria-martinez/) as Mimì, and Guerrero, as Rodolfo, but also because it will be presented in a parking lot, as a drive-in.

"I believe wholeheartedly that as a community, this is what people need. People need an excuse to go out, people need again some sort of normalcy in their life. Even if we can't get back to the theater, at least we’re paying homage to it by way of performance and while it will be in a car and outside, people will get that sensation and that connection that they were longing for," Guerrero says.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1602025995/media/2020/10/SDOGuerreroMartinez_caahaa.jpg){{% /md %}}

<figcaption>Ana María Martínez (left) and Joshua Guerrero, singing Mimì and Rodolfo in San Diego Opera's 2020 production of La bohème.</figcaption>

</figure>

"Because of the parameters we have set because of COVID-19, this _La bohème_ will be different. We have pared it down to its bare bones," says stage director [Keturah Stickann](/scene/people/keturah-stickann/), whose work has been seen in opera houses across the United States, Canada, Chile, Japan, France, Germany, Hungary, and Australia.

The duration of the production will be 90 minutes, with no intermissions, no chorus, and a smaller orchestra. There will be a 120-square-foot perimeter for the singers, who will be required to be 15-feet away from the person they are singing to. Those restrictions can remove the physical connection – Rodolfo warming up Mimi's hand - and sensation that the audience and singers usually experience, says Stickann. It is, however, an opportunity to pull the piece apart "in a different way, to get to know it more deeply, to see what it means to be putting it in someone's memory." She is staging the story in the future, from Rodolfo's recollection.

"The interesting thing about memory is that we can feel it, we can emotionally invest ourselves in it, and we can dive into the way the sounds and sights affected us. All these things can become real for us. But the only thing that we can't do with memory is physically touch it," she says. "We're going to be experiencing that longing that Rodolfo is experiencing. We're going to want Mimì and Rodolfo to touch. That desire is going to be in every audience member watching. But the fact is that they truly can’t because she no longer exists. I think it's going to be a much more multi-layered _La bohème_."

> "When it's live and in person, there’s a connection."

"It's going to be like a torpedo of Mimì and Rodolfo's emotional trajectory. There's no pause to reflect. It's going to go straight through from the moment they meet until the end. As a director that's very exciting. It makes us shine a light on some of the emotional aspects that sometimes get glossed over," she adds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1601747754/media/2020/10/SDOBoheme1_i7kymz.jpg){{% /md %}}

<figcaption>La bohème is part of San Diego Opera's 2020-2021 Season. Photo by Yves Renaud, Courtesy of Opéra de Montréal.</figcaption>

</figure>

As a drive-in, the atmosphere will be very different from the traditional opera house. People will listen through the FM transmitter in their car and there will be two video screens erected on either side of the stage for close-ups and subtitles.

This will be one of the first professional opera performances since the pandemic forced cancellations across the globe and left opera audiences yearning for the connection opera brings.

"When it's live and in person, there’s a connection. There's something magical and that's why we seek that out. If it's live entertainment, or sports, we want that unity, we long for that human connection," says Guerrero.

This will be very different for production members also. "You're usually able to build a community but because of COVID, we won't be able to. Going out, sharing dinner, the things that happen on the road, are going to be stripped away," he says. "We'll all be there physically but we won't be able to access each other."

> "On a community level, we have to figure out how to gather again."

COVID-19 has taken a big toll on the arts and opera. "It's the first time I've done something in eight months," says Guerrero, even if it has at the same time allowed him to spend time at his home and take on projects there. "I find difficulties and challenges to be an opportunity to be more innovative, to do things a little differently, and to think outside of the box."

"Opera has been in a 35-year identity crisis," says Stickann. "As stressful as COVID has been, it's allowed opera and all of us who work in it to reassess why we love it, what we're doing, and how we can move forward with it as the world changes around us."

"Opera is an art form that is very well suited to the drama of our time. We have a lot of heavy issues happening in the world right now. Opera is an art form that can tell our stories. That's important and that’s why opera needs to forge ahead and pivot and think about how it's going to work," she says.

> "The importance of live art is so we can grieve and laugh and rage with each other."

"In these times of COVID, where we feel the rug was pulled out from under us, singing and performing are giving people the opportunity to congregate, even if with restrictions. There's a longing for human connection," says Guerrero.

"I sing because it's my purpose in life," he adds. "It's my way of expressing myself, of being able to communicate to others. It's my purpose, and that goes hand in hand with the ultimate purpose in life, to help each other. If you can do that by way of your talent, you're a very blessed individual."

"On a very personal level, making art is my soul," says Stickann, for whom this piece is also the first work since the start of the pandemic. "Collaborating with singers and composers and designers and all the people that put opera together is how I feed my soul. On a personal level, this is why I keep making opera. It's because we have to."

"On a community level, we have to figure out how to gather again. Some companies are presenting online, a wonderful way to keep the art form coming into people's living rooms. But companies like San Diego who are making this effort to figure out how to put live performance together right now are feeding a certain part of the community soul in this desperate need that we have as humans to engage in experiences that people are having at the same time. The essence of the performing arts is the collective experience that brings us together as a community. This is why we must continue to figure out how to do this," she says.

"The importance of live art is so we can grieve and laugh and rage with each other in a way that is cathartic and helps us feel more connected to our neighbor."