+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2018-06-23T20:50:00-04:00"
lastmod = "2018-06-24T16:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854813520/1DSC_4544.jpg.jpg"
primary_image_credit = "Sara Gartland in Rusalka, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera."
publishDate = "2018-06-24T11:46:00-04:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/talking-with-singers-elizabeth-deshong.md","articles/a-nextlevel-fledermaus-in-des-moines.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
short_description = "The last act brought the curse to its deadly conclusion. I could sense the audience collectively grimacing as Rusalka wandered onstage, knife in hand and feet bloodied. The pristine white floors became stained with pools of red where she discarded her silvery heels. The imagery and music made it clear. There will be no happy ending for the poor nymph."
slug = "rusalka-opera-at-its-most-operatic"
title = "Rusalka: Opera at its most operatic"
+++

Not all fairy tales have happy endings. In fact, the majority of them are quite bloody. Des Moines Metro Opera delivered a production of [*Rusalka*](http://desmoinesmetroopera.org/productions/rusalka/) that perfectly balanced the fairy tale dichotomy of whimsy and darkness. When the *Little Mermaid* melds with Czech folklore and music, the results are beautiful, haunting, and heartbreaking in the best possible way.

This idea of dichotomy was prevalent in all aspects of the production. The scenic design of Jacob A. Climer was a blend of the surreal and the familiar. Furniture was floating in the air or sinking into the floor, and every surface was white with blue, pastoral illustrations. It felt like you were in a vintage palace while tripping on acid. Rusalka finds herself not belonging to either the fairy or human realms, and the set mirrored this uncertainty.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854833571/1DSC_4373.jpg.jpg)
<figcaption>Sara Gartland and Zachary James in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The orchestra, under the direction of David Neely, sounded lush and nuanced. Dvořák's music alternates from folk tunes to romantic harmonies, and often the orchestral melodies supply the emotional dialogue when Rusalka cannot speak. This was most evident in the first scene between Rusalka and the Prince. The orchestra becomes the Prince's duet partner on behalf of his beloved, and Dvořák's music must be a talented wingman because the Prince ends up taking this strange mute woman home with him at the end of the act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854841394/1DSC_0005.jpg.jpg)
<figcaption>A scene from in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

Des Moines Metro Opera has gathered a stellar cast for their production. Let me start off by saying that Zachary James is merman goals personified in the role of Rusalka's father, Vodník. Covered in glitter and sporting green facial hair, James cannot avoid being the center of attention onstage. After seeing him as the villain last season, it was fun to witness James in a more playful role. However, the bass still managed to convey Vodnik's darker emotions with gravitas. Sure, he seems harmless when chasing wood sprites in act one, but if you mess with his daughter, you better watch out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854857854/1DSC_0026.jpg.jpg)
<figcaption>Zachary James in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

Jill Grove was enchanting as the witch, Jezibaba. She brought swagger to the role which was the perfect balance of comedy and malevolence. Grove elicited chuckles when blowing smoke rings and rolling her eyes at the naive water nymph, but her bloodthirsty side in the final act was jarring and creepy. You kind of like her, but you know you can't trust her either. I was a bit disappointed in the magical transformation in the first act. With how long they kept Rusalka hidden in the wardrobe onstage, you would think she would emerge with a whole new look. Alas, the poor nymph only appeared to have obtained a new pair of shiny heels. (I mean, if you're going to risk being cursed forever, you might as well get a full makeover in the process, right?)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854870834/1DSC_4118.jpg.jpg)
<figcaption>Jill Grove in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The minor characters in the opera were all vocally and dramatically sound. Laura Wilde sang the role of the Foreign Princes with fire and passion, menacing the silent Rusalka with catty superiority. The duo of the Gamekeeper and the Kitchen Boy, portrayed by Gregory Warren and Grace Kahl respectively, provided some much needed comic relief in the second and third acts. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854883763/1DSC_0786.jpg.jpg)
<figcaption>Evan LeRoy Johnson in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The production also featured a group of dancers who brought another layer of interest to the story as the Prince's servants. Sometimes dance scenes can feel superfluous in operas, but the choreography by Isaac Martin Lerner was delightful with a touch of humor. Although, I did find myself wondering whether you have to be a natural redhead to work for the Prince or if you just have to dye your hair when you get the job?

Sara Gartland was masterful in the title role of the opera. She beautifully portrayed Rusalka's journey from restless optimist to defeated outcast. Gartland sounded reserved at the beginning of the famous "Song to the Moon," but as the aria progressed, her voice blossomed into its full rich tone. Rusalka is a demanding role, most notably for its emotional range. She must be ethereal at times and heart wrenching at others, and Gartland excelled in all of the character's vocal guises.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854894814/1DSC_4304.jpg.jpg)
<figcaption>Evan LeRoy Johnson and Laura Wilde in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

Rusalka was equally matched in her love interest, the Prince, sung by Evan LeRoy Johnson. His bold, heroic tone contrasted with the murky supernatural realm, and it is clear why Rusalka finds this character so exotic and appealing. He is sunshine to her moonlight, and this is reflected in their vocal lines throughout the opera. (Opposites attract sounds like a great idea on paper, but if their relationship is any indicator, it can be a bit of a disaster.) Johnson brought complexity to his character, but I thought he was too likable in the second act. The Prince's betrayal of Rusalka when he declares his love for the Foreign Princess didn't feel convincing. Perhaps that was the idea, but the rivalry didn't build up to the dramatic climax I expected.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529854907351/1DSC_4525.jpg.jpg)
<figcaption>Sara Gartland in *Rusalka*, Des Moines Metro Opera. Photo: (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The last act brought the curse to its deadly conclusion. I could sense the audience collectively grimacing as Rusalka wandered onstage, knife in hand and feet bloodied. The pristine white floors became stained with pools of red where she discarded her silvery heels. The imagery and music made it clear. There will be no happy ending for the poor nymph.

Dvořák's music reached its pinnacle in the final duet between Rusalka and the Prince, and both Gartland and Johnson gave their most powerful vocal performances in this scene together. I was captivated by that moment, bathing in the romantic swells of the orchestra. It was depressing and beautiful all at the same time, and there was blood everywhere! Opera at its most operatic.

>[Rusalka](http://desmoinesmetroopera.org/productions/rusalka/) runs at Des Moines Metro Opera through July 14. For details and tickets, [click here.](http://desmoinesmetroopera.org/productions/rusalka/)
