+++
author = ["authors/jenna.md"]
categories = "News"
date = "2016-05-15T16:07:00+01:00"
lastmod = "2016-05-16T11:03:00+01:00"
preamble = "Mezzo-soprano and performance artist [Roxanna Walitzki](/scene/people/roxanna-walitzki/) is set to unveil her latest project on **May 20**. Her new EP, [*Exquisite Corpse*](http://www.roxannawalitzki.com/exquisite-corpse), is a collection of uniquely arranged French art songs; Walitzki incorporates electronic music, manipulated sounds, vocal glitches, and \"sweeping guitar notes\" by [Anomie Belle](http://anomiebelle.tumblr.com/), into the existing piano and voice lines of Debussy's *Ariettes Oubliées* and Fauré's *Le jardin clos*.\n\n*Exquisite Corpse* was originally conceived as a collaboration with Walitzki's sister, visual artist [Redd Walitzki](http://www.reddwalitzki.com/), and the digital release of the EP will include limited edition prints of Redd's work from her [exhibition of the same name](http://www.moderneden.com/pages/exquisite-corpse), seen at San Francisco's Modern Eden Gallery in the fall of 2015.\n\nWe spoke with Roxanna about her novel work, and her unique response to the inspiration of these famed French composers. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463324840761/2016-05-15---Exquisite-Corpse-Album-Cover.jpg.jpg"
primary_image_credit = "Artwork by Redd Walitzki."
publishDate = "2016-05-15T22:26:00+01:00"
related_articles = ["articles/in-review-death-desire.md","articles/the-art-of-defining-a-singer-and-squashing-anomalies.md"]
related_people = ["scene/people/roxanna-walitzki.md"]
short_description = "&quot;I only recently began down this path, but have received mostly positive feedback about my approach. What I do isn&#039;t what most people expect when picturing electronic-meets-classical (it&#039;s a far cry from things like The Fifth Element aria and other techno-driven reinterpretations), but the layering of textures can be helpful to those less accustomed to listening to art songs. It adds another emotive dimension to tune into, and I try to stay attuned to, and respectful of, what made the compositions great in the first place.&quot;"
slug = "roxanna-walitzki-exquisite-corpse"
title = "Roxanna Walitzki: Exquisite Corpse"
+++

## What made you choose these songs, and how did you come up with the aesthetic of the new arrangements?

I chose these six songs while musing with my sister, [Redd [Walitzki]](http://www.moderneden.com/pages/exquisite-corpse), about the themes in her [solo-show at Modern Eden](http://www.moderneden.com/pages/exquisite-corpse). We decided to approach the show as an interdisciplinary collaboration, in which I portrayed the figures in her paintings and produced this music exploring similar motifs.  Our main inspiration came from the Greek myth of Chloris (the Goddess of Flowers), who stumbles upon a nymph's dead body while walking in the woods.  Moved by her sad fate, Chloris decides to transform the nymph into a flower.  This story made me think of "Dans la nymphée" from Fauré's *Le jardin clos*.  In the poem, Lerberghe paints the picture of a nymph lying mysteriously in a bed of flowers, only to rise, or bloom, in a transformative and dreamlike flash of light.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463329050835/2016-05-15---Exquisite-Corpse.jpg.jpg)<figcaption>Artwork by Redd Walitzki.</figcaption>
</figure>

Another point of inspiration was the French surrealist parlor game [*cadavre exquis*](https://en.wikipedia.org/wiki/Exquisite_corpse), in which artists sequentially assemble a composition, adding their distinct vision to create a strange and unique whole.  I felt the five selections from Debussy's *Ariettes Oubliées* would lend themselves to a re-contextualized interpretation in line with the parlor game's method.  I again took the myth of Chloris as a starting point, and pictured the speaker stumbling upon the nymph's body, but only realizing in fits and starts that she is dead.  Fleeting moments in the text and music hint at that fact: he attempts conversation without response, questions his directionless melancholy, brings her flowers and adoration, but only apprehends that she has left him in the final, unresolved exclamation and chords.

This backstory gives a rather unique tone to the songs, which influenced my style of production and the overall arrangements.  I incorporated dissonance and suspense through hovering and droning synths and guitars, and aimed to ornament the dramatic moments with swells and electronic stutters.  Nature, which features so prominently in the texts, also played a large part in my interpretations.  I recorded sounds, like creaking branches and flowing water, on a field recorder while shooting the reference photos with Redd.  I also tried to heighten the sense of story and connection by creating interludes and postludes that tie the songs together and place them in a consistent environment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463329063692/2016-05-15---Field-Recording.jpg.jpg)
</figure>

## What appealed to you about this repertoire's take on death and beauty?

Rebirth and transformation are an inherent part of nature. Where there is decay there is also new life, and, while this process is often one of vast sadness, it is also one of beauty.  This repertoire has a similar quality: the compositions are lush, flowing, and full of life, but also turbulent and rich with emotional depth and darkness. I see the texts as open to interpretation and not necessarily fixated on death, but thinking about them in this context almost enhanced their beauty for me. Each little voice and rustling branch in "C'est l’Extase" was previously something else in the constantly changing and evolving flow of existence, but everything (from the red roses to the endless countryside lamented in “Spleen”) has meaning and beauty only if we choose to see it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463329126396/2016-05-15---Exquisite-Corpse-Exclusive.jpg.jpg)<figcaption>Model: Roxanna Walitzki, Photographer: Redd Walitzki.</figcaption>
</figure>

## What kind of feedback have you received from your incorporation of electronic music into classical/art song repertoire?

I only recently began down this path, but have received mostly positive feedback about my approach.  What I do isn't what most people expect when picturing electronic-meets-classical (it's a far cry from things like *The Fifth Element* aria and other techno-driven reinterpretations), but the layering of textures can be helpful to those less accustomed to listening to art songs.  It adds another emotive dimension to tune into, and I try to stay attuned to, and respectful of, what made the compositions great in the first place.  I am finding what I do to be a little difficult to categorize, and I know it will not be for everyone.  That said, I see this fusion of electronic and classical music as one possible way to engage a new audience with the art-form, and I’m really excited to explore more projects of this nature!

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/U6SM7rtVJ9c" frameborder="0" allowfullscreen></iframe>
</figure>

>For full details and to hear a taste of *Exquisite Corpse*, [click here](http://www.roxannawalitzki.com/exquisite-corpse).
