+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = 2019-12-28T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1577394233/media/2019/12/Roundup2019-2_j5ojja.jpg"
primary_image_credit = ""
related_articles = ["articles/metoo-intro.md", "articles/thestories-part-i.md", "articles/roundup-2015.md", "articles/roundup2016-greg-jennas-top-10.md", "articles/greg-jennas-roundup2017.md", "articles/2018-in-review-a-confession.md"]
related_companies = ["scene/companies/amplified-opera.md"]
related_people = ["scene/people/zachary-james.md", "scene/people/kathryn-lewek.md", "scene/people/tamara-wilson.md", "scene/people/teiya-kasahara.md"]
short_description = "This year has certainly been different, though - and maybe you’ve noticed the change in tone since I’ve gone from being Schmopera’s primary voice, to its behind-the-scenes editor and sometimes-guest author."
slug = "roundup-2019-or-why-id-prefer-to-just-look-ahead"
title = "Roundup 2019, or why I'd prefer to just look ahead"
youtube_url = ""

+++
So, I set out to write a roundup-type post for 2019, where I list my favourite shows or singers or whatevers of the last 12 months. I know it's a bit predictable and maybe even pandering, but I like doing that kind of thing. At the end of a year, especially at the end of a decade, it's nice to take stock even of something as unnecessary as a year's worth of opera-going.

But if I'm entirely honest, I can't actually offer a fair roundup for this particular year. For a few reasons that I'll get into shortly, Schmopera has been ticking along as a hub of opera-loving content - often without me. I think that's essentially a good thing; we are now a far-reaching team of writers, who contribute reviews, [interviews](/talking-with-singers-nina-stemme/), [op-eds](/the-business-of-passion/), even [record recommendations](/4-singers-you-might-not-know-but-should/), and the content they produce has great impact with you, our readers.

> I've been flitting around lately.

This has been a cool twist for Schmopera in 2019; admittedly, I'm proud of its new independence, but I have little pangs of guilt akin to how a parent feels dropping their kid off a daycare. _She'll be fine on her own, she's got people taking care of her… But what if she needs me??_

I guess I'm feeling extra reflective right now, because I'm sat in a chalet near the ski village of Mont-Tremblant, QC, where the amazing Andrej and I started Schmopera six years ago. That ski trip has been a near-annual tradition for us, and this year is the first with our son; Schmopera has a bit of a personal side for me, too, since it's been an ongoing, engrossing project that Andrej and I work on together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1577395815/media/2019/12/Alex_ltn7oc.jpg){{% /md %}}

<figcaption>Alex, Mont-Tremblant, QC, 2019.</figcaption>

</figure>

This year has certainly been different, though - and maybe you've noticed the change in tone since I've gone from being Schmopera's primary voice, to its behind-the-scenes editor and sometimes-guest author. There's been one major exception, of course, and that's the series I headed called [#TheStories](/thestories-are-coming-out-and-heres-why/); of course, these weren't pieces written by me, rather first-person accounts of abuse, sexual harassment, and sexual assault in the opera and classical music industries. I published 15 stories and received many more. Though I wouldn’t necessarily call the series a highlight - the word feels a bit gross in this context - #TheStories had a social effect, which is something I'm proud of this year.

I've been flitting around lately. I'm writing fairly regularly for _The Globe and Mail_, and I just started as Social Media Manager at _Opera Canada_. I’m happy about it, and the healthy workload is a far cry from [this time last year](/2018-in-review-a-confession/), when I was in the thick of baby-land and feared I'd never have time to think, let alone write about opera, again.

> I'm so proud that, going into yet another a new decade, it's crystal clear that there are fierce opera-lovers scattered over the world.

It all means that Schmopera is going to be something quite different, going into the new decade. It won’t go anywhere, don't fret; we'll still have great content, and a lot of it by authors other than me. If you're into tracking me on my little opera-writer path, I'd head over to [_The Globe and Mail_](https://www.theglobeandmail.com/arts/), and follow [_Opera Canada_](https://operacanada.ca/)'s social media channels. And if you want to be a total stalker about it, [here's my Instagram](https://www.instagram.com/jennadoogles/).

I guess that's it. Be it the new decade, a seven-year-itch of sorts for Schmopera, or just the ebbs and flows of life, I'm out to do some new things, readers. Instead of a roundup at the end of the year, instead I'm offering a bit of candor.

… But I guess if I had to pick some sort of Top 5 of 2019:

## Interviewing Jessye Norman

[I spoke with Ms. Norman](https://www.theglobeandmail.com/arts/theatre-and-performance/article-opera-legend-jessye-norman-on-receiving-glenn-gould-prize-gratitude/) in February of this year, when she was in Toronto to accept the Glenn Gould Prize; I caught her between masterclasses at the University of Toronto, and sat face-to-face with the legendary soprano in a roomy studio overlooking Philosopher’s Walk. She has that thing that’s really rare, that larger-than-life presence that seems to make someone physically larger than normal. She spoke with that gentle hum, almost casual as she talked about singing for world leaders and being in Berlin as the Wall fell. She was amazing and intimidating, and so interesting to interview that I left with more questions than I came in with. Definitely a highlight.

## Singers getting vocal...about social issues:

[Tamara Wilson ](https://www.instagram.com/p/B0TiF2Wh7fKHk-HmP_jwo8YO8sgwOOytHBv_980/)balked at blackface, [Kathryn Lewek ](https://twitter.com/KathrynLewek/status/1165963897641324545)got real about body-shaming, and [Zachary James ](/thestories-part-i/)spoke out about his assault and the bloated power dynamics in the opera world. It's not necessarily great that all of this happens, and will likely continue to happen for a little longer; but it is great that these artists were among those who used their platforms to tell the industry how it can be much, much better.

<figure data-type="image">{{% md %}}![](https://pbs.twimg.com/media/EC5V-1FWwAEmwet.jpg){{% /md %}}

<figcaption>Photo via Kathryn Lewek on Twitter (@KathrynLewek).</figcaption>

</figure>

## The Irish Art Song Project

It's not strictly opera, but you'd be hard pressed to find a singer who couldn't use a resource like [The Irish Art Song Project](https://www.cmc.ie/AmhrainEalaineGhaeilge). Dáirine Ní Mheadhra and John Hess are the folks behind Queen of Puddings Music Theatre, and a power-couple of the Canadian music scene if there ever was one. While on one of their frequent visits to Dublin, they noticed a serious dearth of contemporary art songs written in the Irish (Gaelic) language. In response, they commissioned 50 new songs by international composers, all set to Irish texts. They’ve published the scores, translations, and full pronunciation guides online, for free.

Bam, Irish Art Song Project. Problem you didn’t know existed, solved.

## _The Queen in Me_

That's the name of the one-person show by Toronto-based soprano [Teiya Kasahara](https://www.theglobeandmail.com/arts/music/article-the-queen-in-me-is-a-damning-inside-scoop-on-canadian-operas/), workshopped this fall at the Ernest Balmer Studio in the Distillery District. [_The Queen in Me_](https://www.teiyakasahara.com/the-queen-in-me) is a fusion of opera, satire, and almost vaudeville elements; its story is about "fallen women", people who are misunderstood and dismissed by the opera industry. It's gorgeously written, and Kasahara does some serious singing of everything from Manon to Lady Macbeth to the Queen of the Night. Crazy impressive. I can't wait for its official premiere in 2020 - details are still TBA, but I'd follow [Teiya](https://www.teiyakasahara.com/the-queen-in-me) and stay in the loop.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1577396075/media/2019/12/TheQueeninMe-19Oct11-Amplify_dz6idx.jpg){{% /md %}}

<figcaption>Teiya Kasahara in The Queen in Me, October 2019. Photo by Tanja-Tiziana.</figcaption>

</figure>

## _Belle Darling Klondike Queen_

This bit of historically-inspired vaudeville by playwright Natalie Frijia, premiered at Alumnae Theatre's FireWorks Festival this year, [_Belle Darling Klondike Queen_](/a-fab-kick-off-to-the-fireworks-festival-belle-darling-klondike-queen/) is essentially another one-person show that, out of the blue, really stuck with me. I wouldn't really deem it opera, but it had the stuff of a great operatic experience; set in the Klondike Gold Rush of the late 19th century, soprano, actress, and cabaret-pro Lindsay Sutherland Boal stars as the real-life vaudeville star Kate Rockwell, aka "Klondike Kate".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573411741/media/2019/11/LSB_D859221_dj75ux.jpg){{% /md %}}

<figcaption>Lindsay Sutherland Boal, star of Belle Darling Klondike Queen.</figcaption>

</figure>

It's an amazing, revue-style account of Kate's lust for adventure, her business-savvy hustle in the Yukon vaudeville scene, and the tragic vulnerability of a still-energized woman desperately recounting what she obviously sees as her best days. I still think about Kate, believe it or not. In case you're curious, [here's her Wiki.](https://en.wikipedia.org/wiki/Kathleen_Rockwell)

***

There. That's as close as I can get to picking my 2019 favourites. Thanks for reading - not just this specific meandering post, but all of it. I'm so proud that, going into yet another a new decade, it's crystal clear that there are fierce opera-lovers scattered over the world.