+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-12-21T17:32:00-05:00"
lastmod = "2015-12-27T19:05:00-05:00"
preamble = "2015 is almost done, everyone! Slightly incredulous over here. It means it's time for some retrospective writing about notable moments in the opera scene for yet another calendar year. \n\nThe easy (?) part is naming some standout performances, like [*Bluebeard's Castle/Erwartung*](/in-review-bluebeards-castle-erwartung/) at the Canadian Opera Company, [*Death & Desire*](/in-review-bluebeards-castle-erwartung/) with Against the Grain Theatre, and [Sondra Radvanovsky's recital](/in-review-sondra-radvanovsky-at-koerner-hall/) at Koerner Hall. More importantly, 2015 started tangible conversations about looming issues around opera, the money it costs, and the reasons to produce it. Like water-cooler conversations, but with more substance.\n\nSo, here are a few of our notable moments from 2015, and why they deserve writing for posterity. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450751253619/2015-12-22---Roundup.jpg.jpg"
publishDate = "2015-12-27T10:25:00-05:00"
related_articles = ["articles/roundup2014.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-bicycle-opera-project.md","scene/companies/indie-opera-to.md","scene/companies/tapestry-opera.md","scene/companies/opera-lyra-ottawa.md","scene/companies/vancouver-opera.md","scene/companies/canadian-art-song-project.md"]
related_people = ["scene/people/krisztina-szab.md","scene/people/joel-ivany.md","scene/people/wayne-gooding.md","scene/people/michael-mori.md","scene/people/alexander-neef.md","scene/people/larissa-koniuk.md","scene/people/stephanie-tritchew.md","scene/people/geoffrey-sirett.md","scene/people/christopher-enns.md","scene/people/david-pomeroy.md","scene/people/lauren-segal.md","scene/people/peter-barrett.md","scene/people/jordan-de-souza.md","scene/people/jacqueline-woodley.md","scene/people/christopher-mokrzewski.md","scene/people/jennifer-nichols.md","scene/people/ambur-braid.md","scene/people/carla-huhtanen.md"]
short_description = "2015 is almost done, everyone! Slightly incredulous over here. It means it&#039;s time for some retrospective writing about notable moments in the opera scene for yet another calendar year. 2015 started tangible conversations about looming issues around opera, the money it costs, and the reasons to produce it. Like water-cooler conversations, but with more substance."
slug = "roundup-2015"
title = "Roundup, 2015"
+++

## When Don Giovanni wreaked his usual havoc

The [Canadian Opera Company](/scene/companies/canadian-opera-company/) put up Dmitri Tcherniakov's production of *Don Giovanni* in January 2015, and by golly was it memorable. I was in the camp who didn't go for the "concept" of this production, which included a longer timespan of the story, familial relationships between characters, and other stuff that wasn't in the score. Call me the puritan of 2015 if you must, but I'll at least vouch for spectacular singing across the board. The silver lining was that this production sparked, for Canadians at least, a series of [conversations](/concept-production-real-reason/) about directors, concept productions, and the difference between creativity and superimposition. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450755588475/2015-12-22---Don-Giovanni-MC.jpg.jpg)
<figcaption>Russell Braun (Don Giovanni) and Kyle Ketelsen (Leporello) in the Canadian Opera Company's production of *Don Giovanni*, 2015. Photo by Michael Cooper.</figcaption>
</figure>

## When we held an opera panel

Speaking of conversations, this year, we hosted our first [panel discussion](/panel-regietheater/), and the topic at hand was that beloved/hated German word, [*Regietheater*](/regietheater-ja-oder-nein/). We sat down with a great group of people who know about this kind of thing: COC General Director [Alexander Neef](/scene/people/alexander-neef/), Tapestry Opera's [Michael Mori](/scene/people/michael-mori/), Against the Grain Theatre's [Joel Ivany](/scene/people/joel-ivany/), mezzo-soprano [Krisztina Szabó](/scene/people/krisztina-szabó/), and writers/critics Robert Harris (*The Globe and Mail*), [Wayne Gooding](/scene/people/wayne-gooding/) (editor, *Opera Canada*) and Lydia Perović (*Definitely the Opera*). The conversation flowed around specific productions (like the COC's *Don Giovanni* and others), and the expectations of audiences in Europe versus in North America. In a collegial way, the panelists represented various corners of the Canadian opera scene; the big, the established, the shoestring, the forward-looking, the singer who pulls it all off.

## Small and mighty

Canada's small opera companies continued to gain traction, and it was certainly tangible in 2015. [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) got me pretty pumped this summer. They started with a run of [Dean Burry](/scene/people/dean-burry/)'s *The Bells of Baddeck* in Baddeck, Nova Scotia, and went straight into a month-long Nova Scotia and Ontario tour (on two wheels, of course). Their touring production was called [*shadow box*](/in-review-shadow-box/), a collection of shorts and excerpts, all from the Canadian contemporary opera repertoire. They put together a clean, coherent, fascinating touring show, all transported from between venues by the artists and their bikes; plus they were showcasing Canadian opera the whole time. There's an ongoing conversation among new companies about opera's relevance for today's audiences; Bike Opera, in bringing opera to places like Port Hope and Barrie, is doing us one better than convincing audiences it's relevant, they're *making* it relevant.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450755379763/Hike-at-Uisge-Bahn-Falls.jpg.jpg)
<figcaption>l-r: Stephanie Tritchew, Giles Tomkins, Larissa Koniuk, Geoffrey Sirett, and Erika Nielsen, enjoying a hike to Uisge Bahn falls. Photo: Geoff's camera's self-timer.</figcaption></figure>

Though not as small (but certainly mighty), [Tapestry Opera](/scene/companies/tapestry-opera/) spent 2015 producing art that is completely novel, even for the company who has been putting up new opera for over 35 years. There was [*M'dea Undone*](/in-review-mdea-undone/) in May, in the raw and real Holcim Gallery at Evergreen Brickworks. Plus, they put out two more of their *Tap:Ex* series, and both were total wow-factors. In March was [*Tables Turned*](/in-review-tapex-tables-turned-or-go-see-this-show/), combinging turntable artists Nicole Lizée, soprano [Carla Huhtanen](/scene/people/carla-huhtanen/), some Maria Callas, Stanley Kubrick, and *The Sound of Music*. November's [*Tap:Ex: Metallurgy*](/he-saidshe-said-tapex-metallurgy/) had Krisztina Szabó and [David Pomeroy](/scene/people/david-pomeroy/) sharing the stage with members from Canadian punk band [Fucked Up](http://fuckedup.cc/home/), collaborating with Canadian composers and librettists to create original works.

The cool part of *Metallurgy* is that it may be an answer to the question about finding contemporary opera in a large-scale presentation. Microphones were used unashamedly, and the sound was symphonic - the possibilities are exciting.

## A shrinking scene?

Of course, not all opera companies did well in 2015. We [lost Opera Lyra](/opera-lyra-and-the-five-stages-of-grief/), which (somewhat suddenly) closed its doors following its recent production of *Il barbiere di Siviglia*, starring [Joshua Hopkins](/scene/people/joshua-hopkins/) in the title role. [Vancouver Opera](/scene/companies/vancouver-opera/) did some slimming down this year, abandoning its full season in favour of a spring festival. The new performance model will take effect in 2017, and the polarizing announcement seemed sudden, even for [those more in the loop](http://www.theglobeandmail.com/news/british-columbia/now-is-the-time-to-support-vancouver-opera/article25032174/) than most. The downsizing and closures aren't great, of course; but with each example of companies who face unsurmountable financial crises (like New York City Opera, Gotham Chamber Opera, Opera Hamilton, and almost San Diego Opera), we get a bit more context, more of a big-picture look at what these struggling companies had in common. 

It's likely an oversimplication to claim a sort of Phoenix-effect, with the big-named, big-spending opera companies crumbling and things like [Indie Opera T.O.](/scene/companies/indie-opera-to/) rising out of the ashes. But I do think that social media and the interest in off-the-beaten path opera venues are great leveling factors between shoestring companies and their established colleagues.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450756121759/0058IMG_9339%252B%2525281%252529.jpg.jpg)
<figcaption>Jennifer Nichols and Carla Huhtanen in The Canadian Art Song Project's *The Living Spectacle*. Photo by Karolina Kuras.</figcaption></figure>

## Moving to the music

Finally, it was a great year for pairing music with movement. At the Canadian Opera Company was [*Pyramus and Thisbe*](/pyramus-thisbe-and-canadian-opera-history/), a triple bill directed by [Christopher Alden](/scene/people/christopher-alden/) and choreographed by Tim Claydon. The movement was unnatural, un-operatic, and oddly still; yet, no one could deny that it went against the music by Monteverdi and Barbara Monk Feldman. There was the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/)'s recital project *The Living Spectacle*, in which Carla Huhtanen's singing of Brian Harman's song cycle *Sewing the Earthworm* was amplified by adding dancer/choreographer [Jennifer Nichols](/scene/people/jennifer-nichols/). Nichols also returned this year the Against the Grain Theatre creative team to choreograph *AtG's Messiah*, remounted with plenty of hype after its "smash success" in 2013. Also, I figure the Robert Lepage's *Erwartung* at the COC counts as music-plus-movement, if you count Michael Levine's terrifying, shifting set pieces and dizzying stage effects.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450755944509/Erwartung.jpg.jpg)
<figcaption>Krisztina Szabó as The Woman in the Canadian Opera Company's production of *Erwartung*, 2015. Photo by Michael Cooper.</figcaption>
</figure>

Combining music and movement is by no means new, but choreographing opera singers at this level of detail is relatively novel, both for the performers and the audience. The reactions to the three examples were strong and largely positive, so I don't see a reason to stop when the going's good.

>That's all for 2015! Readers, what did you love/not love this year? Leave your favourite artists, shows, and new stories in the comments below!
