+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-05-15T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557941305/media/2019/05/sqRoughforOpera17-SpeakRed-ClaireShovelton.jpg"
primary_image_credit = "Speak Red, by Santa Bušs and Finn Beames. Presented at Second Movement's rough for opera #17, 2019. Photo: Claire Shovelton."
related_articles = ["articles/fine-mess-composer-new-opera.md", "articles/talking-with-singers-heloise-werner.md"]
related_companies = []
related_people = []
short_description = "We are talking about an indeterminate and ever-changing tradition that has been developing for over four hundred years. Perhaps it is time to cast form aside entirely and explore where it is headed for the future."
slug = "fascinating-insight-rough-for-opera-17"
title = "Fascinating insight: rough for opera #17"
youtube_url = ""

+++
Second Movement presented its 17th [_rough for opera_](https://secondmovement.org.uk/) scratch night for new opera at the Cockpit theatre with a set of three scenes that sought to question the way we typically perceive opera as an art form. A rare opportunity for creators of new opera, _rough for opera_ selects project proposals to participate in each year's scrap night providing the funding, venue, and creative freedom. Each piece is then workshopped and presented in front of an audience as a work in progress; a chance to test their work, discuss their process, and receive feedback. In many ways, it is a learning experience for both the creators and audience.

The three "operas" presented this year though they differed greatly in their conception and execution, contained some similar thematic ideas in that they all brought to light some critical social issues. The first piece, _Speak Red_ was a selection of excerpts from a larger work composed by Santa Bušs with text by Finn Beames. The roughly 30-minute-long piece was more community theatre than opera and was originally conceived by Beames as a way of raising awareness around aphasia, the little known condition that effects speech and language due to (usually) stroke related brain damage.

>It is a beautiful story to tell but I took issue with the way Werner imitated the disability in an improvised scene during which she stuttered over some text.

The piece was centred around the 15 volunteer performers all of whom had aphasia. Each performer had an opportunity to play around on one of the two pianos on stage as well as introduce themselves and speak about their condition. It was at times difficult to watch as the performers struggled with their words, often needing assistance from their peers and patience from the gracious audience. But it was also sweet, funny, and poignant. This truly felt like a collaborative effort. It was obvious that these volunteers were at the heart of this piece and instrumental to its realization. I think there is a very convincing argument for this kind of opera that brings together amateurs to participate in music making in a very collaborative manner. And for those with this disability, music can be a far easier means of expression than speech.

>A somewhat heavy-handed libretto is softened by Crispin Lord's subtle and sensitive staging.

Where I think the piece struggled though, was in the scene about Ruby Mcdonough portrayed by vocalist/cellist [Héloïse Werner](/talking-with-singers-heloise-werner/). Mcdonough who has aphasia, was assaulted but was denied the opportunity to have the crime prosecuted because of her communication disability. In a historic court case, Mcdonough was able to testify without accommodation and the case eventually went to the supreme court, changing the law for those who have similar struggles. It is a beautiful story to tell but I took issue with the way Werner imitated the disability in an improvised scene during which she stuttered over some text. In other places, the piece showcased the effects of aphasia in a much more effective way.

Bušs very cleverly made use of the instruments (piano and cello) in a non-traditional way to present an alternative means of communication that does not use words. This included dragging the hands down the back of a cello or over the lid of a piano to create a very evocative squeaking, using horsehair to bow the strings of the piano, and running a tuning fork along the keys of the piano. All of these alternative methods created an eerie and compelling image of a world without words. But the focus on the Ruby Mcdonough switched the focus to sexual assault when it should have been about disability and I think this is where they went wrong.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557941440/media/2019/05/RoughforOpera17-AFatherIsLookingForHisDaughter-ClaireShovelton.jpg){{% /md %}}

<figcaption>A Father Looking for His Daughter, by Alex Mills and Gareth Mattey. Presented at Second Movement's rough for opera #17, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

The second short piece heard was _A Father Looking for His Daughter_ with music by Alex Mills, text by Gareth Mattey and direction by Crispin Lord. Of the three performed, this piece was the most traditionally presented. The story focuses on issues of transgender identity as a father (played by soprano, Ella Taylor) looks for the daughter that was taken from him. A somewhat heavy-handed libretto is softened by Crispin Lord's subtle and sensitive staging which features a range of pre-recorded and live video feed as well as puzzling ceremonial use of sand which he leaves totally up to the audience's interpretation.

The music was wonderful – captivating and very well prepared. a simple orchestration, Mills used cello, and percussion to accompany the two singers and to evoke the harsh, hot, nebulous plane the piece existed on. The story was somewhat lost on me as the social issues of the piece seemed to take precedence. In this way it felt more like a lecture than a performance and I think it is crucial that in this process of tackling important issues through opera, that we do not lose the sense of magic.

>Perhaps it is time to cast form aside entirely and explore where it is headed for the future.

Closing the evening was _Dreaming Clouds_, a short piece from composer Alex Ho and choreographer Julia Cheng. This piece was the least operatic of the night but by far the most emotionally engaged performance. The sacred nature of the performance space was established immediately as the performers entered in darkness and placed their instruments ceremoniously centre stage. The piece explored the basic elements of Chinese opera – dance, martial arts, folksong, and traditional Chinese instrumentation all while exploring themes of identity as a British-Chinese.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557941533/media/2019/05/RoughforOpera17-DreamingClouds-ClaireShovelton.jpg){{% /md %}}

<figcaption>Dreaming Clouds, by Alex Ho and Julia Cheng. Presented at Second Movement's rough for opera #17, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

A work in progress, the piece felt very improvisational, almost as if we were witnessing the process of something coming into existence which was a remarkable experience. Ho hummed folk songs while playing the violin in a style that was imitative of the Chinese horse-head fiddle while Cheng danced, whipping her body across the stage with astonishing agility, drawing a bow string across her throat and keening in an unearthly warble. An opera without words, it will be interesting to see how the subtleties of storytelling begin to emerge as this piece develops.

Scratch nights are a highly successful format in which to see new opera and a fascinating insight into the creative process. Second Movement's commitment to providing these invaluable opportunities is commendable. These pieces in a certain sense felt very far away from what I understand opera to be but maybe that's ok. We are talking about an indeterminate and ever-changing tradition that has been developing for over four hundred years. Perhaps it is time to cast form aside entirely and explore where it is headed for the future.