+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-03-13T09:47:00+00:00"
lastmod = "2017-03-14T09:40:00+00:00"
preamble = "When it comes to learning about all things opera, there are more ways to do it than you may think. Compared to the common structure of music and opera degrees at universities and conservatories, South London's [Rose Bruford College](https://www.bruford.ac.uk/courses/opera-studies-ba-hons-by-online-distance-learning/) is unique in its operatic training. The course schedule is flexible - even offering online resources - and there are accessible points of entry for students of various ages, experience levels, and post-study plans.\n\nWe spoke with Dr. F. Jane Schopf, Programme Director, and current students Owen Davies and Natasha Hardy, about the broad-reaching possibilities at Rose Bruford College."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489399064467/2017-03-13---Opera-image-1.jpg.jpg"
publishDate = "2017-03-14T09:40:00+00:00"
short_description = "&quot;I began studying for the opera degree soon after I retired. I discovered I finally had time to pursue a passion for opera that began in my teenage years. For someone like me, online learning is a real treat. I couldn&#039;t see myself returning to a university campus and I can organise my studying around a busy social life. I love being able to work my way through the excellent course papers at my own pace.&quot;"
slug = "rose-bruford-college-we-are-absolutely-unique"
title = "Rose Bruford College: &quot;We are absolutely unique.&quot;"
+++

## What does the online BA (Hons) Opera Studies programme offer, in comparison with more traditional degrees from conservatories and universities?

**Dr. F. Jane Schopf**: We are absolutely unique in offering modules on all aspects of opera – no other degree worldwide does this. We delve into everything: productions, criticism, history, the libretto, the orchestra, arts administration, current trends, directors' approaches, the singer, women in opera, music analysis, opera companies and how they work, and, of course, composers and their works.

As the course is delivered online it means people can study anywhere, any time – the course will fit around any life style with or without work. We provide free access to many online study resources so students are not restricted to library opening hours or having to attend lectures, etc. We have a global student demographic spanning all ages – the course is for anyone passionate about this incredible, all-inclusive art form! 

For those with vocal coaching but still waiting for their voices to mature, our programme is ideal, enabling them up to continue into MA operatic vocal studies in conservatories.

## What do you find the most beneficial with the online learning offered by Rose Bruford College?

**Natasha Hardy**: There are several things:

Opportunity to study a degree around my work and lifestyle, and easy access to my tutors and staff (e.g. when I had a problem at the beginning with figuring out how to use the library, the librarian really helped me. The admission staff have always been really prompt at responding to emails and queries. My course Director went out of her way to help coach me on how to write my first 'proper' essay  (I haven't been in higher education before and she totally put me at ease and explained the process); access to professional websites such as Athens & Naxos.

Access to everything online makes it easy to keep documents, i.e. reading course material, watching operas and keeping research in one place.  (The RBC website is really good and the IT department are really helpful if there is a problem.)

**Owen Davies**: I began studying for the opera degree soon after I retired. I discovered I finally had time to pursue a passion for opera that began in my teenage years. For someone like me, online learning is a real treat. I couldn't see myself returning to a university campus and I can organise my studying around a busy social life. I love being able to work my way through the excellent course papers at my own pace. There is such a wealth of opera online - full operas and excerpts - that I often find myself pursuing musical trails that aren't directly relevant to the assignment I am preparing but enhance my understanding of music and singing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489399144011/2017-03-13---Owen-Davies.jpg.jpg)
<figcaption>Owen Davies, student at Rose Bruford College.</figcaption>
</figure>

## How do the courses adapt to the varying levels of experience or previous operaticstudies among students?

**Dr. Schopf**: The programme is open access, as we teach everything you need to know within the course, but students with previous vocal or musical studies or experience in the industry can apply for exemption from relevant modules or get advanced standing into the last year of study. The modules can be taken as free standing for those wanting Continued Professional Development, or a Professional Certificate. There are numerous exit points at Certificate, Diploma, Ordinary degree and Honours degree level.

## Can you describe the timeline and workload involved in completing a BA (Hons) Opera Studies online?

**Davies**: I am doing one module per semester at the moment.  Some weeks I will just spend half a day studying - other weeks I do a bit more.  Some days I just dip in and out of the course material and find myself watching three or four online versions of the same aria or the same scene from a particular opera. I very rarely find the studying anything other than a pleasure - it's the opposite of hard work to watch three different versions of Act 2 of *La traviata*!

**Hardy**: Basically there are two options: you either start to study in September or in January.  Each term you have the module you are studying, which is (normally) divided into two parts.  Each part you have two months to study and prepare your essay.  If you study over the first 5-6 weeks doing research and jotting ideas down that gives you 2-3 weeks to complete your essay.  Whilst you are doing all this you have access to your tutor for the module, whom you can also send in a draft essay for them to assess and give you pointers on how to improve.

I would recommend studying approximately 1-2 hrs a day.  It might seem a lot, but if you watch 45 mins of an opera and read an article or research online the time used to do these things really adds up.  I have learnt to watch things online late at night before bed or read whilst I am commuting or early in the morning.  Also using weekend time slots really helps:  for example I will study all day on a Sunday if I haven't had time during the week. 

The main thing is it sometimes (depending on the module) doesn't feel like studying, as it is just so interesting!

Last but not least, by the end of this year (2017) I will have completed my first year of my degree which will have taken 2 and a half years.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489399100204/2017-03-13---Natasha-Hardy.jpg.jpg)
<figcaption>Natasha Hardy, student at Rose Bruford College.</figcaption>
</figure>

## How much of the curriculum is theoretical, and how much is practical?

**Dr. Schopf**: We have practical modules in collaboration with Associated Studios, which require a four month residency in London. The practical elements include acting, movement, vocal health, vocal training, repertoire, audition preparation and performance, etc. 

There are practical elements in other fields too such arts administration (fund raising and company accounts) and orchestral conducting in so far as we teach these elements within the module material. The term "theoretical" is restrictive as it can imply dryness and "exercises" - I prefer "reading" in all its many manifestations – for instance, we deconstruct productions by looking at DVDs, listen and analyse singers' performances, look at how music is composed, delve into philosophy, literature, poetry, history, design and myth. So the course is anything but reading dry facts, it is about getting to the substance of this all-embracing art form in living, actualised, real performances.

We are currently working with Associated Studios in London to develop a unique joint BA programme with 50% practical delivered by Associated Studios and 50% Rose Bruford College's online modules (proposed for 2018). The aim of this course will be to give singers an all-round immersion in opera and all its facets, in order to prepare them for their careers in opera. They will receive grounding in the context and understanding of the music they will be singing, as well as physical, vocal and acting techniques to enable them to excel as performers.

## What are your professional plans following completion of your degree/programme?

**Davies**: My plans are not about a profession - they are all about becoming more knowledgeable about an art form that has been my passion for 50 years.  I do review operas for a website and I hope that my reviews will improve as my knowledge and understanding develops, but my objective is purely and simply to enhance my enjoyment or operas, old and new. And I want to introduce as many people as possible to the delights of opera. The course at Rose Bruford College is helping me do that.

**Hardy**: To perform my operatic inspired music to as many people as possible. I am a professional singer and studied classical singing for 15 years.  This course is making me a better performer. This course has made me a better musician, I feel more grounded and I believe in myself and my ability more and this is due to the fact that my knowledge in my chosen field has expanded more than I ever thought it would. 

I didn't do this course because I wanted to be a teacher. I just wanted more knowledge about this art form, that I fell in love with by accident (I wanted to be an actress not a singer). I do think it has made me write music differently; I am writing and developing my first children's opera and I am excited to be able to talk to other people about opera from a singer's perspective with the knowledge of how everything has developed and how it will develop in the future.  So in answer, all I know is that this course has made me excited about opera and that it is an art form that deserves to be continued, stretched, developed and expanded - as so many great composers, singers and directors have in the past - and I feel like I am part of that.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/gnRuc05YltY" frameborder="0" allowfullscreen></iframe>
</figure>
