+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-01-15T18:47:30+00:00"
disclaimer = ""
image_gallery = []
postamble = "ROH's _La traviata_ runs through 31 January, including a live cinema broadcast on 30 January, 7pm. For details and ticket information, [click here.](https://www.roh.org.uk/productions/la-traviata-by-richard-eyre)"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1547589269/media/2019/01/sq405ErmonelaJahoasViolettaValeryCharlesCastronovoasAlfredoGermontROH2019.jpg"
primary_image_credit = "Ermonela Jaho (Violetta Valéry) and Charles Castronovo (Alfred Germont) in La traviata, ROH, 2019. Photo: Catherine Ashmore."
related_articles = ["articles/heartfelt-and-intimate-manitoba-operas-la-traviata.md", "articles/in-review-la-traviata-at-roh.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/simon-shibambu.md", "scene/people/igor-golovatenko.md", "scene/people/charles-castronovo.md", "scene/people/ermonela-jaho.md"]
short_description = "Sitting in the audience, I had the feeling I was part of a long standing tradition, one that dates back to 1858 when the opera was first performed at Covent Garden."
slug = "a-long-standing-tradition-la-traviata-at-roh"
title = "A long-standing tradition: La traviata at ROH"
youtube_url = ""

+++
A rich portrait of 1850's Parisian socialite life was beautifully presented in this classic Richard Eyre production of [Verdi's _La traviata_](https://www.roh.org.uk/productions/la-traviata-by-richard-eyre), which this year sees its sixteenth revival at the Royal Opera House since its premiere in 1994. Sitting in the audience, I had the feeling I was part of a long-standing tradition, one that dates back to 1858 when the opera was first performed at Covent Garden. Since its premiere up until World War I, and during the interwar years, it was performed there nearly every season and to this day is staged every couple of years. In fact, _La traviata_ remains the most performed operas worldwide today.

> In many ways, _Traviata_ is one of those operas you just don't fiddle around with.

I have to wonder why it is this opera in particular that has captured global audiences more than anything that came before it or that we've heard since. Violetta Valéry remains one of the most well-known and beloved characters in all of opera, the music is some of the most universally recognizable in the repertory, and audiences flock to see it performed year after year.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547589343/media/2019/01/090ErmonelaJahoasViolettaValeryCharlesCastronovoasAlfredoGermontROH2019.jpg){{% /md %}}

<figcaption>Ermonela Jaho (Violetta Valéry) and Charles Castronovo (Alfred Germont) in La traviata, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

From a purely logistical standpoint, it draws large audiences. Revival productions are less expensive for the opera houses to produce and staging these classics year after year bring in die-hard opera lovers and willing converts alike. Big repertory houses use opportunities like this to bring in much needed funds.

> Sometimes tender, sometimes viperous, each emotion was well placed and calculated in its execution.

But speaking more broadly, I think the opera covers sweeping universal themes while presenting a straightforward storyline that is easy to follow and also features memorable, singable music. Perhaps most importantly though, it is one of the most infamous tragedies in the operatic repertory. And who can resist such an exquisitely executed tragedy?

It is tragic because it tells the story of a great love that dies before it has a chance to bloom. But what makes it relatable, and therefore, even more painful, is that dotted throughout the piece are moments of regret; moments that most people will easily relate to. Germont regrets driving Violetta away from Alfredo, Alfredo regrets his anger towards Violetta, and Violetta, perhaps to some degree, regrets allowing herself to fall in love with Alfredo against her better judgement. Each character makes rash and emotional decisions and once they realize the error of their ways, it is far too late. There is nothing more tragic than the feeling that we've wasted precious time with the inability to make any changes. The very nature of regret is tragic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547589396/media/2019/01/325CastronovoasAlfredoGermontJahoasViolettaValeryCarbyasAnninaShibambuasDoctorGrenvilROH2019.jpg){{% /md %}}

<figcaption>Charles Castronovo as Alfredo Germont, Ermonela Jaho as Violetta Valéry, Catherine Carby as Annina, and Simon Shibambu as Doctor Grenvil in La traviata, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

For the arc of this story to be believable, character relationships have to be secure and and immediately established. We, as audience members, need to feel connected to these characters from the beginning in order to remain invested into the third act which is where the tragedy truly unfolds. There is not much time for these relationships to be established and so the singers must work very hard to create these character relationships instantly.

This is where I feel the production got off to a bit of a rocky start. Happy to simply chock it up to opening night shakiness, I was able to live with the slight lacklustre and disjunct staging of Act I. The characters seemed to lack motivation in their movements in the opening scene in particular, and I'm not sure whether this was a limitation of the staging or unfamiliarity on the part of the singers.

> It does bring up some questions about the viability of revival productions; things can easily begin to stagnate.

Violetta especially seemed to suffer from this. It was not soprano [Ermonela Jaho](/scene/people/ermonela-jaho/)'s first stab at this having sung the role in the 2012 revival and though it was obvious that the role was fully integrated, she was initially unconvincing. The voice, though remarkable in the floaty high pianissimos we come to expect from a Violetta, was on the whole over-darkened and lacking in depth and colour in the middle-low range. Her gestures were theatrical but misplaced and she featured some alarming physical habits that looked more like they were constricting her singing rather than being integrated physical character choices. The Italian diction was quite unspecific generally, but particularly from Jaho and her "Sempre libera" was disappointingly laboured.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547589524/media/2019/01/13ErmonelaJahoasViolettaValeryCharlesCastronovoasAlfredoGermontROH2019.jpg){{% /md %}}

<figcaption>Ermonela Jaho as Violetta Valéra in La traviata, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Despite all of this, it was a performance full of soul that got better every moment she was on stage. I could tell that she was giving her whole self to the performance, and that Violetta was a character she had spent a long time carefully thinking about. She was at her finest in the captivating 45-minute death scene that makes up Act III. Appearing distressingly ill, she was nuanced and existed fully in the moment. The tender exchanges shared between Violetta and Alfredo were touchingly believable which was a pleasant surprise as every shared moment up until then had been slightly uninspired. If done right, the final moments of the opera will easily move the entire audience to tears and these two actors did an absolutely commendable job.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547589578/media/2019/01/200CharlesCastronovoasAlfredoGermontROH2019.jpg){{% /md %}}

<figcaption>Charles Castronovo as Alfredo Germont in La traviata, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Tenor [Charles Castronovo](/scene/people/charles-castronovo/) was convincing and steady in the role of Alfredo. He seemed to handle all of the emotional ups and downs of this character with grace and confidence. Sometimes tender, sometimes viperous, each emotion was well placed and calculated in its execution. The voice sounded comfortable and free which made him very easy to watch on stage.

Baritone [Igor Golovatenko](/scene/people/igor-golovatenko/) was a very young Giorgio Germont, I thought, but managed to create a believable character, appearing persuasively aged. Never purely villainous, grieving for his son and for the loss of the daughter that could have been, he was a sensitive and complex, fully realised character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547589670/media/2019/01/211CharlesCastronovoasAlfredoGermontIgorGolovatenkoasGiorgioGermontROH2019.jpg){{% /md %}}

<figcaption>Charles Castronovo (Alfredo) and Igor Golovatenko (Germont) in La traviata, ROH, 2019. Photo by Catherine Ashmore.</figcaption>

</figure>

I did have to wonder though, if I was perhaps the fact that this production is over 20 years old that made it feel a little stiff at times. The stage requirements from singing-actors has changed greatly in the last two decades and I think had this been a brand new production, we would have seen more physical integration of character as opposed to quite a lot of standing still. It does bring up some questions about the viability of revival productions; things can easily begin to stagnate. Rehearsal time is short and virtually non-existent, particularly for a professional chorus of which nearly every member would have likely sung the very same production as recently as the season before. But being an extremely expensive art form, it is important for opera houses to be able to cut costs where possible while maintaining a high calibre of performance and it would seem these under rehearsed revival productions are the best way to do that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547589783/media/2019/01/398CharlesCastronovoasAlfredoGermontErmonelaJahoasViolettaValeryROH2019.jpg){{% /md %}}

<figcaption>Ermonela Jaho (Violetta Valéry) and Charles Castronovo (Alfred Germont) in La traviata, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

However, it did not diminish the level of craftsmanship and storytelling I was witnessing and of every opera I have ever had the fortune to see performed, _La traviata_ lends itself best to a classic production. Re-invention is always possible, and in most cases, welcome, but _La traviata_ provides the rare opportunity to tell a very particular story from a very particular moment in time. The woman upon whom Violetta is based was hugely influential in social circles in Paris and greatly revered by many. It is her story, and she that Verdi is honouring. In many ways, _Traviata_ is one of those operas you just don't fiddle around with. Alright by me; I quite like it just the way it is and I have a feeling it is a story that will continue to be told for many years to come.