+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2019-12-13T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The Royal Opera House's production of [_Otello_](https://www.roh.org.uk/tickets-and-events/otello-by-keith-warner-details) is onstage through 22 December."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1576260549/media/2019/12/sq0689GregoryKundeasOtelloOtelloROH2019_oizmf8.jpg"
primary_image_credit = "Gregory Kunde in the title role of Otello, ROH, 2019. Photo: Catherine Ashmore."
related_articles = ["articles/in-review-stiffelio.md", "articles/talking-with-singers-gerald-finely.md", "articles/talking-with-singers-gregory-kunde.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/ermonela-jaho.md", "scene/people/gregory-kunde.md"]
short_description = "Though Otello may be the title character and tragic hero of the story, in truth it is Iago who is the most alluring character on stage. For four hundred odd years, Shakespeare’s infamous villain has captured the imaginations of audiences everywhere. Spanish baritone Carlos Alvarez played him with chilling ease."
slug = "a-chilling-iago-a-devoted-otello-at-covent-garden"
title = "A chilling Iago & a devoted Otello at Covent Garden"
youtube_url = ""

+++
I have a potentially controversial confession to make; though I can appreciate the significant cultural impact Verdi’s music has had, I would not list him among my favourite composers. However, what I do enjoy about Verdi’s operas is the sense of grandeur. It feels very much as though you are experiencing opera in its truest form. The high drama, grand sweeping orchestra, and larger-than life characters are quintessentially operatic and, in the case of [_Otello_](https://www.roh.org.uk/tickets-and-events/otello-by-keith-warner-details), a nod to the renowned Shakespearean tragedy and everything it has come to stand for.

Already committed to retirement after the success of Aida in 1871, Verdi was ultimately coaxed by his profit-hungry publisher to write again being given the opportunity to write an opera based on Shakespeare’s _Othello_. It is fortunate he didn’t stop with _Aida_ as he had originally intended, as _Otello_ features some of the most forward thinking, harmonically complex, and textually astute music the composer ever produced.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1576282070/media/2019/12/1205OtelloproductionimageROH2019_mzfocp.jpg){{% /md %}}

<figcaption>Production image from Otello, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

In [this production](https://www.roh.org.uk/tickets-and-events/otello-by-keith-warner-details), the Orchestra of the Royal Opera House, led by Music Director Antonio Pappano, took centre stage as the most enthralling character of them all. There were far too many stunning moments to list in this intensely dramatic piece but what stood out the most to me was the deftness with which Verdi was able to provide a soundscape for the story, and the rich text painting he was able to achieve by experimenting with provocative harmonic choices and orchestrations.

This production directed by Keith Warner with set design by Boris Kudlička premiered at the Royal Opera House in 2017 and makes its first revival appearance this season. It is an unobtrusive production with simple yet striking era-indefinite set pieces. Visually, it is a design that caters to the needs of the piece and then quietly steps aside, allowing the work to speak for itself, facilitating the drama and storytelling. Costumes by Kaspar Glarner take a similar approach. Pieces adapted from traditional 15th-century dress feature a subdued colour palette and richly textured garments added nuance and interest on stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1576282158/media/2019/12/0559GregoryKundeasOtelloandErmonelaJahoasDesdemonainOtelloROH2019_kdvxwn.jpg){{% /md %}}

<figcaption>Gregory Kunde (Otello) and Ermonela Jaho (Desdemona) in Otello, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Soprano [Ermonela Jaho](/scene/people/ermonela-jaho/) shone in the demanding role of Desdemona. Though the role was slightly on the heavy side for her, the colour and bloom she achieved in the upper part of her range was stunning. She played the role with a great sense of dignity and strength of character. Desdemona is an unfortunate woman who is a tragic product of her time but Jaho gave her a sense of agency. She made the most significant impression in act four in a quiet and feminine scene which was in direct contrast with male-dominant aggression of the rest of the opera. But here we catch a glimpse of the intimacy of female friendship as Emilia – Iago’s wife – helps to prepare Desdemona for bed. There is a sadness in this scene as both women know that this will likely be the last time they see each other. The purity and subtle drama of this scene was handled with expert care both by Jaho and mezzo Catherine Carby as Emilia.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1576282191/media/2019/12/0576CarlosAlvarezasIagoinOtelloROH2019_kes8rb.jpg){{% /md %}}

<figcaption>Carlos Alvarez (Iago) in Otello, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Though Otello may be the title character and tragic hero of the story, in truth it is Iago who is the most alluring character on stage. For four hundred odd years, Shakespeare’s infamous villain has captured the imaginations of audiences everywhere. Spanish baritone Carlos Alvarez played him with chilling ease. There was something enthralling about his performance that went beyond the clarity and precision of his voice. Iago speaks directly to the audience - almost like a less well-meaning Figaro – and we can’t help but be captivated by his relentlessly evil quest for domination.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1576282226/media/2019/12/0370GregoryKundeasOtelloandErmonelaJahoasDesdemonainOtelloROH2019_xjrhwe.jpg){{% /md %}}

<figcaption>Gregory Kunde (Otello) and Ermonela Jaho (Desdemona) in Otello, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Though not wholly convincing vocally, American tenor [Gregory Kunde](/talking-with-singers-gregory-kunde/) gave a courageous and devoted performance in the title role. He took vocal risks to serve the character over a more finished sound and though not every note was perfectly beautiful, I think his commitment was commendable and, in my opinion, preferable to the alternative. He and Jaho had great chemistry as the ill-fated lovers and even in his most intense moments of derangement I felt that he was truly living with this role.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1576282260/media/2019/12/0616ErmonelaJahoasDesdemonaandCarlosAlvarezasIagoinOtelloROH2019_metgjd.jpg){{% /md %}}

<figcaption>Ermonela Jaho (Desdemona) and Carlos Alvarez (Iago) in Otello, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

This was a thoroughly enjoyable production. Verdi’s _Otello_ is a sensitive adaptation of Shakespeare’s story which keeps all of the key elements while catering to an operatic setting. It is a story that gets to the heart of something for each of us and makes us question the nature of evil in its basest of forms.