+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-07-03T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "The Royal Opera's production of [_The Marriage of Figaro_](https://www.roh.org.uk/productions/the-marriage-of-figaro-by-david-mcvicar) is onstage through 21 July."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1562262235/media/2019/07/sqJoe%CC%87lleHarveyasSusannaROH2019photobyMarkDouetC31B3589.jpg"
primary_image_credit = "Joélle Harvey (Susanna) in The Marriage of Figaro, ROH, 2019. Photo: Mark Douet."
related_articles = []
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/kangmin-justin-kim.md", "scene/people/simon-keenlyside.md", "scene/people/julia-kleiter.md", "scene/people/joélle-harvey.md", "scene/people/christian-gerhaher.md"]
short_description = "Somehow, though now over two hundred years old, it maintains a certain freshness. Even a standard production like this 2006 David McVicar classic which this season sees its sixth revival run at the Royal Opera, still feels relevant."
slug = "the-ever-relevant-classic-rohs-marriage-of-figaro"
title = "The ever-relevant classic: ROH's Marriage of Figaro"
youtube_url = ""

+++
There is something special about _Le nozze di Figaro_. Somehow, though now over two hundred years old, it maintains a certain freshness. Even a standard production like this 2006 David McVicar classic, which this season sees its [sixth revival run](https://www.roh.org.uk/productions/the-marriage-of-figaro-by-david-mcvicar) at the Royal Opera, still feels relevant. The familiar tunes have not lost their lustre over time and the story remains as relatable and insightful as ever.

A cut-and-dry production, yes, but an intelligent one which paid a lot of attention to detail. The staged overture provided an insight into the life of a servant in the house of Count Almaviva in a very clear way. This is of course, quite a typical approach to the opening of the opera to have the servants bustling about, preparing for the day ahead but McVicar really focuses in on the minutia, bringing to light the idea that secrets are never safe in a big house.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562262291/media/2019/07/SimonKeenlysideasCountJuliaKleiterasCountessROH2019photobyMarkDouet50A9045.jpg){{% /md %}}

<figcaption>Simon Keenlyside (Count) and Julia Kleiter (Countess) in The Marriage of Figaro, ROH, 2019. Photo: Mark Douet.</figcaption>

</figure>

Doors are constantly - and intentionally - shut, in an attempt to keep secrets in as servants lurk nearby, eavesdropping, whispering, and gossiping behind their masters' backs. In a very real sense, this is most likely what life would have looked like working in a big house at the time and it creates a rich backdrop for the unfolding drama of the opera.

The production design was devoid of much of the pomp and circumstance that often comes with a period setting of this piece and though it lacked some of the usual ostentation, I enjoyed the departure. Opting for a more realistic design, the set was grand but understated, bordering on drab. It was much like what I would imagine a real manor home of the time to look like. The lighting design was basic and a little ambiguous, which could have been intentional, but it gave the impression of being a little haphazard. The best moment was the slow dimming and yellowing of light as evening fell over the course of the act three finale. And in slow motion, the chorus leave the stage in disarray as the trees that form the act four garden silently descend from the fly. It was a masterful transition.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562262306/media/2019/07/Joe%CC%87lleHarveyasSusannaGerhaherasFigaroROH2019photobyMarkDouetC31B4686.jpg){{% /md %}}

<figcaption>Joélle Harvey (Susanna) and Christian Gerhaher (Figaro) in The Marriage of Figaro, ROH, 2019. Photo: Mark Douet.</figcaption>

</figure>

But it is Beaumarchais' beloved characters interpreted by Da Ponte and Mozart that truly make this piece so memorable. The cast led by German baritone [Christian Gerhaher](/scene/people/christian-gerhaher/) in the title role presented fully integrated and well-rounded performances of these characters across the board. Gerhaher makes his role debut here and though he was very entertaining to watch and elicited many laughs from the audience, I felt that there was something missing. For my taste, Figaro is generally a rounded, bouncier, more light-hearted sound whereas Gerhaher seemed to get a little bogged down in the severity of it all. Though I enjoy his singing, all told I’m not sure it was the right casting choice. By contrast, American soprano [Joelle Harvey](/scene/people/joelle-harvey/) as Susanna, his bride-to-be was reassuringly solid. Her voice was clear and bubbly. She passed the whole role off effortlessly, no small feat that deserves to be commended.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562262321/media/2019/07/Joe%CC%87lleHarveyasSusannaSimonKeenlysideasCountROH2019photobyMarkDouetC31B3047.jpg){{% /md %}}

<figcaption>Joélle Harvey (Susanna) and Simon Keenlyside (Count) in The Marriage of Figaro, ROH, 2019. Photo: Mark Douet.</figcaption>

</figure>

German soprano [Julia Kleiter](/scene/people/julia-kleiter/) makes her Royal Opera debut as the Countess Almaviva and baritone [Simon Keenlyside](/scene/people/simon-keenlyside/) takes on the role of her philandering husband, the Count. Keenlyside was a buffoonish Count. Angry, brash, and at times edging on manic he was the perfect opposition to Kleiter’s Countess who by comparison, was sweet-natured, and sympathetic. This just emphasised the destructively abusive nature of their relationship, giving greater significance to the ensuing confusion and hilarity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562262338/media/2019/07/ChristianGerhaherasFigaroJoe%CC%87lleHarveyasSusannaROH2019photobyMarkDouetC31B2497.jpg){{% /md %}}

<figcaption>Christian Gerhaher (Figaro) and Joélle Harvey (Susanna) in The Marriage of Figaro, ROH, 2019. Photo: Mark Douet.</figcaption>

</figure>

I was very excited to see Korean American counter tenor [Kangmin Justin Kim](/scene/people/kangmin-justin-kim/) in the role of Cherubino which has historically been the realm of trouser-toting mezzos. In fact, it was so startling to see an actual man in this role that he almost didn’t register as male on stage. This was aided by Kim’s voice which bears a particularly resonant mezzo quality. He was very charming and funny easily proving why it is Cherubino who is always the favourite.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562262349/media/2019/07/KangminJustinKimasCherubinoCROH2019photobyMarkDouetC31B276.jpg){{% /md %}}

<figcaption>Kangmin Justin Kim (Cherubino) in The Marriage of Figaro, ROH, 2019. Photo: Mark Douet.</figcaption>

</figure>

John Eliot Gardiner conducted what was not the most cohesive renditions of opera. Perhaps it was simply the fact that it was opening night, but the band seemed to struggle with ensemble. Blending became an issue as well as certain instruments came out of the texture in ways that felt unintentional. There were a few perilously unsure moments in the first act when the singers were not in time with the band as well. Mozart is unforgiving in this sense; when it is wrong, there is no hiding. Still, there were some sublime moments musically where the score came alive and overall it was a very creative interpretation that was intentioned and well-paced, leaving plenty of room for the storytelling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562262359/media/2019/07/ProductionimageTheMarriageofFigaroROH2019photobyMarkDouet80A2388.jpg){{% /md %}}

<figcaption>A scene from The Marriage of Figaro, ROH, 2019. Photo: Mark Douet.</figcaption>

</figure>

Ultimately it was the collaborative work of the cast and the commitment to character that made the production so successful. This opera truly does not work without that effort and it felt as though every aspect of the performance was in service to the story. All in all, it was a very solid and enjoyable production.