+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-04-16T01:24:58+00:00"
disclaimer = ""
image_gallery = []
postamble = "_Faust_ runs at the Royal Opera House through 6 May. For details and ticket information, [click here](https://www.roh.org.uk/productions/faust-by-david-mcvicar)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1555378480/media/2019/04/sqROHFaustMichaelFabianoTristramKenton.jpg"
primary_image_credit = "Michael Fabiano as Faust in Faust, ROH, 2019. Photo: Tristam Kenton."
related_articles = ["articles/michael-fabiano-the-profound-effect-of-artsmart.md", "articles/talking-with-singers-erwin-schrott.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/mandy-fredrich.md", "scene/people/erwin-schrott.md", "scene/people/rolando-villazon.md"]
short_description = "He subjects Faust to a writhing, grotesque circus; tormenting him with visions of a pregnant Marguerite, and a dead Valentin. Schrott is maniacal and callous, delighting in the pain of others and becoming more despicable every moment he is on stage."
slug = "classic-lavish-faust-at-roh"
title = "Classic & lavish: Faust at ROH"
youtube_url = ""

+++
Gounod's most beloved of grand operas, _Faust_ receives the royal treatment in a revival of this 2005 David McVicar production at the Royal Opera that can only be described as lavish. We are immediately transported to 1870's Paris; a dark gothic cathedral looms over the far right of the stage, a bustling market square is filled with soldiers and shoppers, and under dazzling lights, a cabaret show is performed. Imposing set design by Charles Edwards, glitzy costumes by Brigitte Reiffenstuel, and striking lighting design by Paula Constable culminate to make this the perfect representation of the grandeur of opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555378694/media/2019/04/ROHFaustTristamKenton1.jpg){{% /md %}}

<figcaption>A scene from Faust, ROH, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

American tenor [Michael Fabiano](/scene/people/michael-fabiano/) takes on the title role in this production and brings a palpable energy to the stage. His voice has a robust, triumphant quality to it, and he was every bit the romantic hero. He and bass [Erwin Schrott](/talking-with-singers-erwin-schrott/) in the role of Méphistophélès made the perfect comedic duo on their ridiculous and ill-fated romp. Schrott, though suffering from a bout of illness, gave no sign of fatigue and only seemed to get better as the performance went on. 

It wasn't until the final act – the demonic Walpurgis night ballet – that we see his true nature. Schrott casts off an enormous black robe to reveal an exquisite shimmering gown - a costuming choice that elicited shock and amusement from the audience. He subjects Faust to a writhing, grotesque circus; tormenting him with visions of a pregnant Marguerite, and a dead Valentin. Schrott is maniacal and callous, delighting in the pain of others and becoming more despicable every moment he is on stage. I would have liked to see a lot more of this from the get-go but there was, nevertheless, an intelligence and a thoughtfulness to the way he approached the character that I found very intriguing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555378717/media/2019/04/ROHFaustErwinSchrottTristramKenton.jpg){{% /md %}}

<figcaption>Erwin Schrott as Méphistophélès in Faust, ROH, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

German soprano [Mandy Fredrich](/scene/people/mandy-fredrich/) took on the role of Marguerite very last minute in place of an ailing Irina Lungu. The role is not a new one for her having performed it both in Stuttgart and Vienna recently, but this was her Royal Opera debut and therefore her first time stepping into this particular production. Considering she had only arrived in London earlier that day, she did phenomenally well. Her voice was light, with a bell like clarity perfectly suited to Marguerite's angelic nature but I found she waned in character slightly. Her most honest moment on stage was in her final scene when her soul ascends to heaven and even this lacked the necessary emotional weight.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555378748/media/2019/04/ROHFaustStephaneDegoutTristramKenton.jpg){{% /md %}}

<figcaption>Stéphane Degout as Valentin in Faust, ROH, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

Gounod's score was wondrously brought to life by conductor Dan Ettinger who imbued it with so much energy and passion. Breathing along with the players, he created a performance atmosphere that was alive with intensity. Gounod's music shapeshifts much like his central, devilish character. It is sometimes militaristic, sometimes gushing and romantic and at its core is a wild ferocity that hints at the mystical.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555378783/media/2019/04/ROHFaust2TristramKenton.jpg){{% /md %}}

<figcaption>A scene from Faust, ROH, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

This classic production ticked all of the major boxes; elaborate set design, imaginative costuming choices, an integrated chorus, a ballet sequence, thrilling music, and stunning vocal performances but the few truly jaw-dropping moments of the performance were created not by the singers in relationship with one another, but by the spectacle on stage. Relationships were established, yes, but the commitment to the development of those relationships was lacking. This is where the heart and soul of the performance lies. Some of the details can get missed out in an opera of this scale, that is understandable. But it left me wondering how much of a disadvantage we are at without them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555378801/media/2019/04/ROHFaust3TristamKenton.jpg){{% /md %}}

<figcaption>A scene from Faust, ROH, 2019. Photo: Tristam Kenton.</figcaption>

</figure>