+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-04-26T00:14:14+00:00"
disclaimer = ""
draft = false
image_gallery = []
postamble = "_Billy Budd_ is onstage at the Royal Opera House through 10 May. For details and ticket information, [click here](https://www.roh.org.uk/productions/billy-budd-by-deborah-warner)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1556237961/media/2019/04/sq2860ashm_0843JacquesImbrailoasBillyBuddROH2019.jpg"
primary_image_credit = "Jacques Imbrailo as Billy Budd in Billy Budd, ROH, 2019. Photo: Catherine Ashmore."
related_articles = []
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/toby-spence.md", "scene/people/jacques-imbrailo.md"]
short_description = "This production co-produced with Teatro Real, Madrid and Rome Opera is the first return of the opera to the Royal Opera stage in nearly 20 years and welcomes back the incomparable Deborah Warner, who has made a career staging Britten."
slug = "transcendent-ambitious-billy-budd-at-roh"
title = "Transcendent & ambitious: Billy Budd at ROH"
youtube_url = ""

+++
There is something spiritual and incredibly empathetic about Britten's work. He shows a deep understanding of the human condition which is heartbreakingly expressed through his music. His 1964 grand opera _Billy Budd_ is a move away from the chamber form he had championed in previous works such as _Albert Herring_, _The Turn of the Screw_, and _The Rape of Lucretia_. 

>It is a very special work of art and should be respected as such.

_Billy Budd_ was a joint effort with long-time collaborator Eric Crozier and long admired E.M Forster and at its heart, is the love and respect these men shared for Herman Melville, from whose posthumously published novel of the same name the opera is adapted. Melville, ever the poet of the sea, can be felt in all aspects of this production - not least in the sensitive setting of the libretto which capture the essence of his work and great passion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556238507/media/2019/04/2860ashm_1100BillyBuddproductionimageROH2019.jpg){{% /md %}}

<figcaption>A scene from Billy Budd, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

This opera was conceived as an all-male production as it concerns the lives of the sailors living and working on an 18th-century English war ship. Normally, I would be up in arms about the lack of female representation in this production and would question the validity of its place in the repertory but it is a well-known fact that Britten never showed much interest in the female perspective, and I think it is important in this case, to take the piece at face value. It is a very special work of art and should be respected as such. This production co-produced with Teatro Real, Madrid and Rome Opera is the first return of the opera to the Royal Opera stage in nearly 20 years and welcomes back the incomparable Deborah Warner, who has made a career staging Britten.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556238533/media/2019/04/2860ashm_1308JacquesImbrailoasBillyBuddROH2019.jpg){{% /md %}}

<figcaption>Jacques Imbrailo as Billy Budd in Billy Budd, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Warner and set-designer Michael Levine have created a visually stunning performance piece featuring a predominantly British cast which strives to tell this poignant story with a great amount of sensitivity and authenticity. The production faces some design challenges as the entirety of the piece is set on the ship at sea. But instead of having a boat on the stage which would have likely appeared outdated and tacky, the stage becomes the boat featuring a complicated set of ropes, pulleys, ladders, canvas, and planks. 

>At the root is a beautiful and visceral connection to the raw emotion of the character and the music.

The stage consisted of three lateral platforms that hung from a set of ropes that could be raised or lowered at certain angles. This enabled action to take place both above and below decks creating levels, adding interest and, allowing the suspended platforms to imitate the swaying motion of a rocking ship. Beautiful vignettes were created with Jean Kalman's minimalist lighting, which clearly differentiated the feel of below and above deck, night and day, and crew versus the Captain's quarters. The sailors on these ships would have been living in close quarters, been worked to the bone, mistreated and underfed. They would have gone to sleep at the end of each day filthy, cold, and exhausted. This oppressive atmosphere is achieved through this set design, which creates this imprisoned, claustrophobic sense for the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556238552/media/2019/04/2860ashm_1818CliveBayleyasDanskerJacquesImbrailoasBillyBuddROH2019.jpg){{% /md %}}

<figcaption>Clive Bayley as Dansker and Jacques Imbrailo as Billy Budd in Billy Budd, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

Particularly impressive was the ambitiously physical nature of the staging of this production. The 60-man strong chorus, plus 30-odd supers, hauled ropes, hoisted sales, climbed ladders, scrubbed floors and bounded across the stage. I could not have imagined a better way to stage this opera. What Britten does so successfully is use his music to tell a story, dropping the audience into a very specific time and place. The production therefore needs to feel authentic in order for the audience to have a sense of and relate to these characters' very real emotional struggles. The commitment to this aspect of performance was exceptionally done. Just as a ship's crew share a sense of camaraderie, this same camaraderie was felt on stage, making the tender moments of friendship and love the men share, the beating heart at the core of this performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556238580/media/2019/04/2860ashm_1713BrindleySherrattasJohnClaggartROH2019.jpg){{% /md %}}

<figcaption>Brindley Sherratt as John Claggart in Billy Budd, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

The piece was very well sung throughout. South African baritone [Jacques Imbrailo](/scene/people/jacques-imbrailo/) takes on the title role, a character he has performed previously in productions at Glyndebourne, Teatro Real, Dutch National and Norwegian National Opera. Though I was initially unconvinced by his voice, I became persuaded as the performance wore on. On first listen, it is an unspecific and untidy sound, but at the root is a beautiful and visceral connection to the raw emotion of the character and the music. This was a terrific performance from Imbrailo.

>Claggart's ability to arouse sympathy is pivotal to the tragedy of this story and Sherratt achieved this remarkably well.

Bass [Brindley Sherratt](/scene/people/brindley-sherratt/) was fantastic in his role as the villainous John Claggart. He had the ability often sought for in the best villains to be extremely sympathetic and despicable all at once. Claggart's story is a complicated one; tormented by his feelings for the pure and beautiful Billy Budd, he decides his only course is to crush his spirit, destroy his reputation, and inevitably, see him hanged. Sherratt captured the needed restraint for a character of this class and nature but in the key moments, made his internal struggle clear to the audience. Claggart's ability to arouse sympathy is pivotal to the tragedy of this story and Sherratt achieved this remarkably well.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556238597/media/2019/04/2860ashm_1531copyTobySpenceasCaptainEdwardFairfaxVereThomasOliemansasMrRedburnROH2019.jpg){{% /md %}}

<figcaption>Toby Spence as Captain Vere in Billy Budd, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

English tenor [Toby Spence](/scene/people/toby-spence/) was a thoroughly three-dimensional Captain Edward Fairfax Vere. Though he arguably has a less prominent role than Billy, his character is critical to the telling of the story. It is he who sets the scene in the prologue and he who has the final word in the epilogue (a trope that Britten was fond of and used often). It is in these moments when Spence is alone onstage that are the most poignant and beautifully told. An impressive Britten tenor, Spence has a noble and versatile sound. Using a liberal amount of falsetto and straight tone he shaped his words with intention, creating a heart wrenching image of regret.

>Britten has never shied away from bringing to light the stories of those on the side-lines of society, marginalized for their differences.

Britten has never shied away from bringing to light the stories of those on the side-lines of society, marginalized for their differences. In a way, it is his own story he is telling again and again. This piece is a departure from the preceding works and a return to the large-scale sweeping orchestra used for _Grimes_. Strangely though, unlike in _Grimes_, nearly all imagery of the sea is missing here. Perhaps it is because in a place surrounded and defined by water, the true story is about the lives of the men on these ships; their fears, desires, and needs. In a very real way, it is about the threat of war, the powerful structures of society that shape us, and what it means to be English. All of these themes come together in a production which was as transcendent as it was ambitious.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556238617/media/2019/04/2860ashm_0784copyaJacquesImbrailoasBillyBuddAlasdairElliottasSqueakROH2019.jpg){{% /md %}}

<figcaption>Jacques Imbrailo as Billy Budd (centre) in Billy Budd, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>
