+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-05-21T22:11:00+01:00"
lastmod = "2016-05-25T10:04:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464094565508/2016-05-24---Robert-Ames.gif"
publishDate = "2016-05-24T21:45:00+01:00"
related_articles = ["articles/great-nights-sketches-of-miles.md","articles/aurora-orchestra-fun-frankenstein.md"]
related_companies = ["scene/companies/london-contemporary-orchestra.md"]
related_people = ["scene/people/robert-ames.md","scene/people/hugh-brunt.md"]
short_description = "&quot;I keep notes all the time of pieces that I want to do, and dreaming up programmes. There&#039;s an absolutely humongous list of composers, and specific pieces of music, different artists I&#039;d work with, people in theatre, people in dance, electronic artists, certain films that I&#039;m interested in that we&#039;d love to do live scores for.&quot;"
slug = "robert-ames-deep-minimalism-lco"
title = "Robert Ames: Deep Minimalism &amp; LCO"
+++

The folks behind the London Contemporary Orchestra seem to be some of today's most insatiable seekers of the new and creative. The short version of their extensive list of collaborations includes projects with Terry Riley, Beck, Radiohead's Jonny Greenwood, members of Arcade Fire, Vivienne Westwood, and Nike.

"We seem to sell out every show that we do," says [Robert Ames](http://www.robertames.co.uk/), violist, conductor, and co-Artistic Director of the LCO. Their sold-out venues are everything from abandoned Underground stations, to pop/rock concert settings like London's [Roundhouse](http://www.roundhouse.org.uk/), to "the top of Primrose Hill", and to the more common orchestra haunts, like the Royal Festival Hall and the Barbican Centre. They have no trouble selling out live venues, and the LCO has also recorded original soundtracks for [films](http://www.lcorchestra.co.uk/films/) like *There Will Be Blood*, *The Master* (both composed by Jonny Greenwood), and *Macbeth* (composed by Jed Kurzel).

Ames established the LCO in 2008 with co-Artistic Director and conductor [Hugh Brunt](http://www.hughbrunt.com/), whom he met when they were members of the National Youth Orchestra. The pair had an early concept of starting an orchestra, and when they both began to fall in love with contemporary classical music, "the idea merged into a more collaborative, contemporary music-based group."

"We kind of were getting a bit frustrated with how contemporary music was being programmed in London," admits Ames. "With a lot of the main, big, established orchestras, in a concert programme, you typically get a symphony, a concerto, whatever, and then a kind of token piece of contemporary music wedged in between, almost like an apology." Ensembles like the London Sinfonietta and the [City of London Sinfonia](/scene/companies/city-of-london-sinfonia/) are hard at work and breaking these norms, and the LCO is an exciting part of what it means to be an orchestra in the 21st century. "We were just really keen to programme orchestral concerts of purely contemporary classical music, and find interesting ways of doing that."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464094602253/Oval-Space-Conducting-2.gif)
</figure>

Along with big ideas, the London Contemporary Orchestra has its dedicated corps of musicians, who average at about 25-30 years old, putting great intentions into practice. "We've got an amazing group of players, a lot of whom are soloists, and improvisors, making electronic music, and doing all sorts of interesting things as well as playing their instruments," says Ames. They contribute not simply their playing, but they are an important part of LCO's decisions in programming repertoire for their concerts. "It's a group of open-minded musicians who have other interests outside of traditional classical music, and a love of contemporary music." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464094611359/PV9A1823.gif)
</figure>

Coming up next from LCO is the [DEEP∞MINIMALISM](http://www.lcorchestra.co.uk/events/deepminimalism/) festival, at the Southbank Centre's St. John's Smith Square on June 24. On the programme is the world premiere of *Still Point*, by British composer and electronic musician [Daphne Oram](https://en.wikipedia.org/wiki/Daphne_Oram), famous for establishing the [BBC Radiophonic Workshop](https://en.wikipedia.org/wiki/BBC_Radiophonic_Workshop). "She basically started writing this piece and didn't finish it, and it was never performed," adds Ames. "It was for orchestra and vinyl and turntables. We think it's one of the earliest examples of music for orchestra and electronics. She was doing this interesting stuff way before Stockhausen and all the famous guys were doing it."

*Still Point* has been realized by composer and LCO artist Shiva Feshareki. "She was reconstructing the piece of music from the notes she's found, and the little bits of music that she's found, and she'll be performing the electronic element on turntables as well."

Also on their DEEP∞MINIMALISM programme are works by John Cage and Pauline Oliveros; the latter is known for developing the concept of ["deep listening"](https://en.wikipedia.org/wiki/Pauline_Oliveros#Deep_Listening), and finding wonderfully resonant spaces in which to improvise with groups of musicians. "It's basically a practice that's supposed to heighten your awareness of sound and silence and making noise," Ames explains. "She writes pieces of music that help you practice that form of listening.

Oliveros' *Rock Piece* is what audiences will hear on June 24th, and the score is simply a set of directions, which Ames read to us:

"Each participant chooses a pair of resonant rocks to use as percussive instruments. After listening for environmental pulses, each participant establishes an independent pulse with the rocks. The pulse is to be maintained steadily without any rhythmic interpretation or accents. While listening to the overall sound, if the participant perceives that he or she is synchronising exactly, or in a simple multiple of division of 2 or 3 of another participant's pulse, he stops in order to listen, and begins a new pulse, which is independent in rate from all other pulses."

As a result, the piece can be as long or as short as the performers want, and the musicians are free to either stay in one place, or to walk freely around the space.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464094621327/Theeb-Session-2.gif)
</figure>

Ames is slowly working through what he calls "a massive list of things" that he'd like to perform with the London Contemporary Orchestra, including the "wild and zany". "I keep notes all the time of pieces that I want to do, and dreaming up programmes. There's an absolutely humongous list of composers, and specific pieces of music, different artists I'd work with; people in theatre, people in dance, electronic artists, certain films that I'm interested in, that we'd love to do live scores for." 

With their cross-cultural and cross-disciplinary reach, the LCO seems to have an embarrassment of riches when it comes to ways they can wow audiences and get younger listeners excited about the concept of "The Orchestra".

"Orchestras are slowly starting to pick up on the fact that there are interesting cross-cultural collaborations that you can do," he says. "If everybody's coming from the right place, and at the core is some really good quality music and good performance, it turns out to be something special."

>The London Contemporary Orchestra presents [DEEP∞MINIMALISM](http://www.lcorchestra.co.uk/events/deepminimalism/) at the Southbank Centre on June 24, 7:30pm. For more details and ticket information, follow our box office links below. 
