+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-12-10T09:22:00-05:00"
lastmod = "2017-01-02T09:24:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483149756850/2016-12-31---Types.jpg.jpg"
publishDate = "2017-01-02T09:24:00-05:00"
related_articles = ["articles/how-i-acted-my-way-into-an-opera-career.md","articles/why-this-opera-singer-took-a-nonsinging-job-at-an-opera-company.md","articles/audition-arias-101-the-young-singers-guide.md","articles/would-you-rather-prove-me-wrong.md"]
short_description = "To be fair: maybe these singers can do subtle, and we just didn&#039;t get the chance to see it (and most of the above examples come from an arguably different era of directing opera). But they&#039;re still quite different from singers like Diana Damrau, Christopher Purves, Krisztina Szabó, Barbara Hannigan, Alice Coote, and Allan Clayton. These guys are versatile, and they really do pair their beautiful sounds with mature, layered dramatic performances that feel organic and believable, rather than hokey and overdone."
slug = "risky-opinions-there-are-2-types-of-singers"
title = "Risky opinions: there are 2 types of singers..."
+++

Even within a niche environment like opera, there are extremes, aesthetic poles that define subgenres within the larger art form. There are composers who write opera scores which are objectively beautiful to the ear; the music of *Madama Butterfly* or *Norma*, for example, is pleasing and memorable even out of context from the operas' plots. Conversely, there are composers whose operas have fewer hummable tunes, but instead try to find an exaggerated version of real-time drama with their scores; Britten, Monteverdi, Strauss, these guys took speech and turned it into a fantastical world of subtext and heightened emotions.

There are also similar subgenres (for lack of a better word) of singers. It has a bit to do with voice type, perhaps combined with a certain kind of personality. On one side of the singer spectrum is the detail-oriented, thoughtful singing-actor; they do English opera well, Baroque and contemporary opera, comprimario roles, anything that takes a fair amount of dramatic technique paired with smart singing. The polar opposite to this kind of opera singer is the big, broad makers of sound; these singers do Puccini-type *verismo* well, where they can let their voices soar, and move the audience with the heartbreaking combo of music and tragic love story.

Now, in the 21st-century, operas like *Silent Night*, *Cold Mountain*, *The Tempest* and *Doctor Atomic* have demonstrated a new balance in the pairing of music and drama. Composers offer up a handful of memorable tunes (and extremely demanding music), yet their musical aesthetic comes out of a goal to amplify speech and tell stories. 

It's no new concept for operatic composers to write music that serves drama; just ask Handel, Mozart, Rossini, Donizetti, Verdi, Wagner, Strauss...you get the idea. Yet 21st-century opera seems to fuse together speech and song, drama and music, more tightly than did even Puccini or Verdi. It's difficult to pull "numbers" from contemporary opera; stand-alone arias à-la-"Sempre libera" or "Dove sono" are a rare find today. Similarly, opera today rarely gives way to music-free dialogue, like in *Die Zauberflöte* or *Carmen* or *Die Fledermaus*. 

Predictably, this style of creating opera demands of an opera singer more skills in stagecraft. Already gone are the days of parking-and-barking, of "schmacting", the tableau-by-numbers, and (for the most part) both the baritone- and tenor-claws. Opera companies are also taking advantage of the lean mobility of chamber operas; with the smaller-sized works come smaller venues in which to perform them, meaning the audience is quite literally up close.

Inevitably, this all means that opera singers today need to be better actors than they ever were.

The dramatic demands of contemporary opera have sectioned off among singers what can almost be described as new divisons of voice type. Broadly categorized, these singers can fall into two categories: those who can make glorious sounds, and those who can do so while acting.

At the risk of seeming unfair, we first noticed this big, over-generalized divide among - you guessed it - tenors. There are certainly tenors who can act; there are even tenors who can act while making glorious sounds. But doesn't everybody know a tenor who has a great voice, yet heaven help him if he has to speak dialogue or sing for an audience of 300 in a black-box theatre? That tenor can sing the pants out of Rodolfo, Pinkerton, Manrico, Radamès, and the Duke of Mantua, but it's almost laughable to think of that same tenor as the Painter in *Lulu* or in the title role of *Peter Grimes*. (And frankly, we've even worked with tenors who are so confident in their high Cs that don't seem concerned about their rudimentary acting abilities.)

We're not here to rag on tenors. Among all voice types, there exists a "camp" of opera singers who can make extraordinary sounds, but who don't seem to do subtle. We'll offer some examples (at the risk of getting yelled at in the comments section): Anna Netrebko, Plácido Domingo, Dolora Zajick, Kiri te Kanewa, and Luciano Pavarotti.

To be fair: maybe these singers *can* do subtle, and we just didn't get the chance to see it (and most of the above examples come from an arguably different era of directing opera). But they're still quite different from singers like Diana Damrau, Christopher Purves, Krisztina Szabó, Barbara Hannigan, Alice Coote, and Allan Clayton. These guys are versatile, and they really do pair their beautiful sounds with mature, layered dramatic performances that feel organic and believable, rather than hokey and overdone.

Before we forget to say it: there are singers who do it all. [Sondra Radvanovsky](/talking-with-singers-sondra-radvanovsky/) is one of those artists, and so are [Jane Archibald](/scene/people/jane-archibald/) and [Craig Colclough](/scene/people/craig-colclough/). It's utterly thrilling to see artists who rise to the challenge, as contemporary opera asks more and more of a singer's voice and stagecraft.

When we're feeling fair, generous, and understanding, observing the two broad poles of opera-singerdom is similar to noticing how some people like tea, and others prefer coffee. But when we're exasperated by phoned-in performances of famous operas, draped in expensive production value and sold out with the help of big-name singers, it's infuriating to see little room made for dramatic skill. It makes us ask, loudly in our own heads, *What is the effing point?* It makes us sympathize with people who opt for musical theatre, film, and TV for their fix of storytelling; if the singers are just going to park-and-bark-and-add-in-some-swoons, why go to the opera when you can listen to an excellent recording on your couch? And by extension, where's the story we're meant to be told?

The voice certainly counts for a lot when it comes to opera; some people say it's "all about the voice", but the word "all" is not synonymous with the word "only". We love that opera has continuously raised the bar for singers, in the same way that Olympic athletes continue to break world records. It's thrilling and visceral. Perhaps that's why it's so irritating to hear a glorious voice paired with a face that's, at best, a canned collection of acting-by-numbers, and at worst, resembles a deer-in-headlights.
